/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.businessobject;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterConstants;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

@ParameterConstants.COMPONENT(component="OutstandingCertificationsByOrganization")
public class OutstandingCertificationsByOrganization
extends EffortCertificationDocument {
    protected static final Logger LOG = Logger.getLogger(OutstandingCertificationsByOrganization.class);

    public String getCertificationOrganizations() {
        String certificationOrganizations = "";
        ArrayList<String> certificationOrganizationList = new ArrayList<String>();
        List<EffortCertificationDetail> details = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            String accountOrg = detailLine.getAccount().getChartOfAccountsCode() + "-" + detailLine.getAccount().getOrganizationCode();
            if (certificationOrganizationList.contains(accountOrg)) continue;
            certificationOrganizationList.add(accountOrg);
            if (certificationOrganizations.equals("")) {
                certificationOrganizations = accountOrg;
                continue;
            }
            certificationOrganizations = certificationOrganizations + ", " + accountOrg;
        }
        return certificationOrganizations;
    }

    public String getNextApprovers() {
        String nextApprovers = "";
        List actionList = KewApiServiceLocator.getActionListService().getAllActionItems(this.getDocumentHeader().getDocumentNumber());
        for (ActionItem actionItem : actionList) {
            String principalId;
            if (!actionItem.getActionRequestCd().equals("A") || (principalId = actionItem.getPrincipalId()) == null) continue;
            Person person = KimApiServiceLocator.getPersonService().getPerson(actionItem.getPrincipalId());
            if (StringUtils.isBlank((CharSequence)nextApprovers)) {
                nextApprovers = person.getName();
                continue;
            }
            nextApprovers = nextApprovers + "; " + person.getName();
        }
        return nextApprovers;
    }

    public String getEmployeeName() {
        return ((FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class)).getPersonNameByEmployeeId(this.emplid);
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof OutstandingCertificationsByOrganization) {
            ArrayList<String> keyFields = new ArrayList<String>();
            keyFields.add("documentNumber");
            ObjectUtil.equals((Object)((Object)this), (Object)arg0, keyFields);
        }
        return false;
    }
}

