/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.web.struts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleService;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ec.EffortConstants;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetailLineOverride;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.document.authorization.EffortCertificationDocumentAuthorizer;
import org.kuali.kfs.module.ec.document.validation.event.AddDetailLineEvent;
import org.kuali.kfs.module.ec.document.validation.event.CheckDetailLineAmountEvent;
import org.kuali.kfs.module.ec.document.validation.impl.EffortCertificationDocumentRuleUtil;
import org.kuali.kfs.module.ec.document.web.struts.CertificationReportForm;
import org.kuali.kfs.module.ec.document.web.struts.EffortCertificationAction;
import org.kuali.kfs.module.ec.document.web.struts.EffortCertificationForm;
import org.kuali.kfs.module.ec.service.EffortCertificationDocumentService;
import org.kuali.kfs.module.ec.util.DetailLineGroup;
import org.kuali.kfs.sys.DynamicCollectionComparator;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.BusinessObject;

public class CertificationReportAction
extends EffortCertificationAction {
    protected static Logger LOG = Logger.getLogger(CertificationReportAction.class);

    public ActionForward recalculate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int lineToRecalculateIndex = this.getLineToDelete(request);
        EffortCertificationForm effortForm = (EffortCertificationForm)form;
        EffortCertificationDocument effortDocument = (EffortCertificationDocument)effortForm.getDocument();
        List<EffortCertificationDetail> detailLines = effortDocument.getEffortCertificationDetailLines();
        EffortCertificationDetail lineToRecalculate = detailLines.get(lineToRecalculateIndex);
        EffortCertificationDocumentRuleUtil.applyDefaultValues(lineToRecalculate);
        String errorPathPrefix = "document.effortCertificationDetailLines";
        boolean isValid = this.invokeRules((KualiDocumentEvent)new CheckDetailLineAmountEvent("", errorPathPrefix, effortDocument, lineToRecalculate));
        if (isValid) {
            KualiDecimal totalPayrollAmount = effortDocument.getTotalOriginalPayrollAmount();
            lineToRecalculate.recalculatePayrollAmount(totalPayrollAmount);
        }
        return mapping.findForward("basic");
    }

    public ActionForward add(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isValid;
        CertificationReportForm certificationReportForm = (CertificationReportForm)form;
        EffortCertificationDocument effortDocument = (EffortCertificationDocument)certificationReportForm.getDocument();
        List<EffortCertificationDetail> detailLines = effortDocument.getEffortCertificationDetailLines();
        EffortCertificationDetail newDetailLine = certificationReportForm.getNewDetailLine();
        newDetailLine.refreshNonUpdateableReferences();
        newDetailLine.setPositionNumber(effortDocument.getDefaultPositionNumber());
        newDetailLine.setFinancialObjectCode(effortDocument.getDefaultObjectCode());
        newDetailLine.setNewLineIndicator(true);
        EffortCertificationDetail workingDetailLine = new EffortCertificationDetail();
        ObjectUtil.buildObject((Object)((Object)workingDetailLine), (Object)((Object)newDetailLine));
        EffortCertificationDocumentRuleUtil.applyDefaultValues(workingDetailLine);
        if (newDetailLine.isAccountExpiredOverride()) {
            this.updateDetailLineOverrideCode(workingDetailLine);
            this.updateDetailLineOverrideCode(newDetailLine);
        }
        if (isValid = this.invokeRules((KualiDocumentEvent)new AddDetailLineEvent("", "newDetailLine", effortDocument, workingDetailLine))) {
            if (EffortCertificationDocumentRuleUtil.hasA21SubAccount(workingDetailLine)) {
                EffortCertificationDocumentRuleUtil.updateSourceAccountInformation(workingDetailLine);
            }
            this.resetPersistedFields(workingDetailLine);
            detailLines.add(workingDetailLine);
            certificationReportForm.setNewDetailLine(certificationReportForm.createNewDetailLine());
        } else {
            EffortCertificationDetailLineOverride.processForOutput(newDetailLine);
        }
        this.processDetailLineOverrides(detailLines);
        return mapping.findForward("basic");
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int lineToDeleteIndex = this.getLineToDelete(request);
        EffortCertificationForm effortForm = (EffortCertificationForm)form;
        EffortCertificationDocument effortDocument = (EffortCertificationDocument)effortForm.getDocument();
        List<EffortCertificationDetail> detailLines = effortDocument.getEffortCertificationDetailLines();
        detailLines.remove(lineToDeleteIndex);
        return mapping.findForward("basic");
    }

    public ActionForward revert(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int lineToRevertIndex = this.getLineToDelete(request);
        EffortCertificationForm effortForm = (EffortCertificationForm)form;
        EffortCertificationDocument effortDocument = (EffortCertificationDocument)effortForm.getDocument();
        List<EffortCertificationDetail> detailLines = effortDocument.getEffortCertificationDetailLines();
        this.revertDetaiLine(detailLines, lineToRevertIndex);
        return mapping.findForward("basic");
    }

    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.loadDocument(kualiDocumentFormBase);
        CertificationReportForm certificationReportForm = (CertificationReportForm)kualiDocumentFormBase;
        if (this.isSummarizeDetailLinesRendered(certificationReportForm)) {
            this.refreshDetailLineGroupMap(certificationReportForm);
        }
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.refresh(mapping, form, request, response);
        CertificationReportForm certificationReportForm = (CertificationReportForm)form;
        for (EffortCertificationDetail detailLine : certificationReportForm.getDetailLines()) {
            detailLine.refreshNonUpdateableReferences();
            EffortCertificationDocumentRuleUtil.applyDefaultValues(detailLine);
        }
        return actionForward;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CertificationReportForm certificationReportForm = (CertificationReportForm)form;
        if (this.isSummarizeDetailLinesRendered(certificationReportForm)) {
            this.updateDetailLinesFromSummaryLines(certificationReportForm);
        }
        ActionForward actionForward = super.execute(mapping, form, request, response);
        this.refresh(mapping, form, request, response);
        return actionForward;
    }

    public ActionForward sortDetailLineByColumn(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CertificationReportForm certificationReportForm = (CertificationReportForm)form;
        String methodToCallAttribute = (String)request.getAttribute("methodToCallAttribute");
        String sortMethodName = "sortDetailLineByColumn.";
        String sortColumn = StringUtils.substringBetween((String)methodToCallAttribute, (String)sortMethodName, (String)".");
        this.toggleSortOrder(certificationReportForm);
        this.sortDetailLine(certificationReportForm, certificationReportForm.getDetailLines(), sortColumn);
        if (this.isSummarizeDetailLinesRendered(certificationReportForm)) {
            this.sortDetailLine(certificationReportForm, certificationReportForm.getSummarizedDetailLines(), sortColumn);
        }
        return mapping.findForward("basic");
    }

    public ActionForward recalculateSummarizedDetailLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CertificationReportForm certificationReportForm = (CertificationReportForm)form;
        EffortCertificationDocument effortDocument = (EffortCertificationDocument)certificationReportForm.getDocument();
        KualiDecimal totalPayrollAmount = effortDocument.getTotalOriginalPayrollAmount();
        List<EffortCertificationDetail> summarizedDetailLines = certificationReportForm.getSummarizedDetailLines();
        int lineToRecalculateIndex = this.getSelectedLine(request);
        EffortCertificationDetail lineToRecalculate = summarizedDetailLines.get(lineToRecalculateIndex);
        EffortCertificationDocumentRuleUtil.applyDefaultValues(lineToRecalculate);
        String errorPathPrefix = "document.summarizedDetailLines[" + lineToRecalculateIndex + "]";
        boolean isValid = this.invokeRules((KualiDocumentEvent)new CheckDetailLineAmountEvent("", errorPathPrefix, effortDocument, lineToRecalculate));
        if (isValid) {
            lineToRecalculate.recalculatePayrollAmount(totalPayrollAmount);
            String groupId = lineToRecalculate.getGroupId();
            List<EffortCertificationDetail> detailLines = certificationReportForm.getDetailLines();
            List<EffortCertificationDetail> detailLinesToRecalculate = this.findDetailLinesInGroup(detailLines, groupId);
            for (EffortCertificationDetail line : detailLinesToRecalculate) {
                ObjectUtil.buildObject((Object)((Object)line), (Object)((Object)lineToRecalculate), EffortConstants.DETAIL_LINES_GROUPING_FILEDS);
            }
            Map<String, DetailLineGroup> detailLineGroupMap = DetailLineGroup.groupDetailLines(certificationReportForm.getDetailLines());
            DetailLineGroup detailLineGroup = detailLineGroupMap.get(DetailLineGroup.getKeysAsString(lineToRecalculate));
            this.updateDetailLineGroup(detailLineGroup, lineToRecalculate, totalPayrollAmount);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addSummarizedDetailLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = this.add(mapping, form, request, response);
        if (GlobalVariables.getMessageMap().getErrorCount() >= 0) {
            CertificationReportForm certificationReportForm = (CertificationReportForm)form;
            this.refreshDetailLineGroupMap(certificationReportForm);
        }
        return actionForward;
    }

    public ActionForward deleteSummarizedDetailLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CertificationReportForm certificationReportForm = (CertificationReportForm)form;
        List<EffortCertificationDetail> summarizedDetailLines = certificationReportForm.getSummarizedDetailLines();
        int lineToRecalculateIndex = this.getSelectedLine(request);
        EffortCertificationDetail lineToDelete = summarizedDetailLines.get(lineToRecalculateIndex);
        summarizedDetailLines.remove((Object)lineToDelete);
        String groupId = lineToDelete.getGroupId();
        List<EffortCertificationDetail> detailLines = certificationReportForm.getDetailLines();
        List<EffortCertificationDetail> detailLinesToDelete = this.findDetailLinesInGroup(detailLines, groupId);
        detailLines.removeAll(detailLinesToDelete);
        return mapping.findForward("basic");
    }

    public ActionForward revertSummarizedDetailLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CertificationReportForm certificationReportForm = (CertificationReportForm)form;
        List<EffortCertificationDetail> summarizedDetailLines = certificationReportForm.getSummarizedDetailLines();
        int lineToRevertIndex = this.getSelectedLine(request);
        EffortCertificationDetail lineToRevert = summarizedDetailLines.get(lineToRevertIndex);
        Map<String, DetailLineGroup> detailLineGroupMap = DetailLineGroup.groupDetailLines(certificationReportForm.getDetailLines());
        DetailLineGroup detailLineGroup = detailLineGroupMap.get(DetailLineGroup.getKeysAsString(lineToRevert));
        List<EffortCertificationDetail> detailLinesInGroup = detailLineGroup.getDetailLines();
        List<EffortCertificationDetail> detailLines = certificationReportForm.getDetailLines();
        for (EffortCertificationDetail detailLine : detailLinesInGroup) {
            this.revertDetaiLine(detailLines, detailLine);
        }
        this.refreshDetailLineGroupMap(certificationReportForm);
        return mapping.findForward("basic");
    }

    protected List<EffortCertificationDetail> findDetailLinesInGroup(List<EffortCertificationDetail> detailLines, String groupId) {
        ArrayList<EffortCertificationDetail> detailLinesInGroup = new ArrayList<EffortCertificationDetail>();
        for (EffortCertificationDetail line : detailLines) {
            if (!StringUtils.equals((CharSequence)groupId, (CharSequence)line.getGroupId())) continue;
            detailLinesInGroup.add(line);
        }
        return detailLinesInGroup;
    }

    protected boolean isSummarizeDetailLinesRendered(CertificationReportForm certificationReportForm) {
        this.populateAuthorizationFields((KualiDocumentFormBase)certificationReportForm);
        return certificationReportForm.getEditingMode().containsKey("summaryTabEntry");
    }

    protected void recalculateAllDetailLines(CertificationReportForm certificationReportForm) {
        Map<String, DetailLineGroup> detailLineGroupMap = DetailLineGroup.groupDetailLines(certificationReportForm.getDetailLines());
        EffortCertificationDocument effortDocument = (EffortCertificationDocument)certificationReportForm.getDocument();
        KualiDecimal totalPayrollAmount = effortDocument.getTotalOriginalPayrollAmount();
        List<EffortCertificationDetail> summarizedDetailLines = certificationReportForm.getSummarizedDetailLines();
        for (EffortCertificationDetail detailLine : summarizedDetailLines) {
            detailLine.recalculatePayrollAmount(totalPayrollAmount);
            DetailLineGroup detailLineGroup = detailLineGroupMap.get(DetailLineGroup.getKeysAsString(detailLine));
            this.updateDetailLineGroup(detailLineGroup, detailLine, totalPayrollAmount);
        }
    }

    protected void updateDetailLinesFromSummaryLines(CertificationReportForm certificationReportForm) {
        EffortCertificationDocument effortDocument = (EffortCertificationDocument)certificationReportForm.getDocument();
        List<EffortCertificationDetail> detailLines = certificationReportForm.getDetailLines();
        List<EffortCertificationDetail> summarizedDetailLines = certificationReportForm.getSummarizedDetailLines();
        boolean isValid = true;
        int index = 0;
        for (EffortCertificationDetail detailLine : summarizedDetailLines) {
            EffortCertificationDocumentRuleUtil.applyDefaultValues(detailLine);
            String errorPathPrefix = "document.summarizedDetailLines[" + index + "]";
            isValid &= this.invokeRules((KualiDocumentEvent)new CheckDetailLineAmountEvent("", errorPathPrefix, effortDocument, detailLine));
            ++index;
        }
        if (!isValid) {
            return;
        }
        for (EffortCertificationDetail detailLine : summarizedDetailLines) {
            if (!detailLine.isNewLineIndicator()) continue;
            if (detailLine.isAccountExpiredOverride()) {
                detailLine.refreshReferenceObject("account");
                this.updateDetailLineOverrideCode(detailLine);
            }
            List<EffortCertificationDetail> detailLinesToUpdate = this.findDetailLinesInGroup(detailLines, detailLine.getGroupId());
            for (EffortCertificationDetail line : detailLinesToUpdate) {
                ObjectUtil.buildObject((Object)((Object)line), (Object)((Object)detailLine), EffortConstants.DETAIL_LINES_GROUPING_FILEDS);
                line.setAccountExpiredOverride(detailLine.isAccountExpiredOverride());
                line.setAccountExpiredOverrideNeeded(detailLine.isAccountExpiredOverrideNeeded());
                line.setOverrideCode(detailLine.getOverrideCode());
            }
        }
        Map<String, DetailLineGroup> detailLineGroupMap = DetailLineGroup.groupDetailLines(detailLines);
        KualiDecimal totalPayrollAmount = effortDocument.getTotalOriginalPayrollAmount();
        for (EffortCertificationDetail detailLine : summarizedDetailLines) {
            detailLine.setGroupId(DetailLineGroup.getKeysAsString(detailLine));
            DetailLineGroup detailLineGroup = detailLineGroupMap.get(DetailLineGroup.getKeysAsString(detailLine));
            this.updateDetailLineGroup(detailLineGroup, detailLine, totalPayrollAmount);
        }
        this.processDetailLineOverrides(detailLines);
        this.processDetailLineOverrides(summarizedDetailLines);
    }

    protected void updateDetailLineGroup(DetailLineGroup detailLineGroup, EffortCertificationDetail detailLine, KualiDecimal totalPayrollAmount) {
        EffortCertificationDetail summaryLine = detailLineGroup.getSummaryDetailLine();
        summaryLine.setEffortCertificationUpdatedOverallPercent(detailLine.getEffortCertificationUpdatedOverallPercent());
        summaryLine.setEffortCertificationPayrollAmount(detailLine.getEffortCertificationPayrollAmount());
        detailLineGroup.updateDetailLineEffortPercent();
        detailLineGroup.updateDetailLinePayrollAmount();
    }

    protected void toggleSortOrder(CertificationReportForm certificationReportForm) {
        if (DynamicCollectionComparator.SortOrder.ASC.name().equals(certificationReportForm.getSortOrder())) {
            certificationReportForm.setSortOrder(DynamicCollectionComparator.SortOrder.DESC.name());
        } else {
            certificationReportForm.setSortOrder(DynamicCollectionComparator.SortOrder.ASC.name());
        }
    }

    protected void sortDetailLine(CertificationReportForm certificationReportForm, List<EffortCertificationDetail> detailLines, String ... sortColumn) {
        String sortOrder = certificationReportForm.getSortOrder();
        DynamicCollectionComparator.sort(detailLines, (DynamicCollectionComparator.SortOrder)DynamicCollectionComparator.SortOrder.valueOf((String)sortOrder), (String[])sortColumn);
    }

    protected Map<String, DetailLineGroup> refreshDetailLineGroupMap(CertificationReportForm certificationReportForm) {
        LOG.debug((Object)"refreshDetailLineGroupMap() started");
        List<EffortCertificationDetail> summarizedDetailLines = certificationReportForm.getSummarizedDetailLines();
        if (summarizedDetailLines == null) {
            EffortCertificationDocument effortCertificationDocument = (EffortCertificationDocument)certificationReportForm.getDocument();
            effortCertificationDocument.setSummarizedDetailLines(new ArrayList<EffortCertificationDetail>());
        }
        summarizedDetailLines.clear();
        Map<String, DetailLineGroup> detailLineGroupMap = DetailLineGroup.groupDetailLines(certificationReportForm.getDetailLines());
        for (String key : detailLineGroupMap.keySet()) {
            EffortCertificationDetail sumaryline = detailLineGroupMap.get(key).getSummaryDetailLine();
            summarizedDetailLines.add(sumaryline);
        }
        return detailLineGroupMap;
    }

    protected void revertDetaiLine(List<EffortCertificationDetail> detailLines, EffortCertificationDetail lineToRevert) {
        int lineToRevertIndex = detailLines.lastIndexOf((Object)lineToRevert);
        this.revertDetaiLine(detailLines, lineToRevertIndex);
    }

    protected void revertDetaiLine(List<EffortCertificationDetail> detailLines, int lineToRevertIndex) {
        EffortCertificationDetail lineToRevert = detailLines.get(lineToRevertIndex);
        BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        EffortCertificationDetail revertedLine = (EffortCertificationDetail)businessObjectService.retrieve((PersistableBusinessObject)lineToRevert);
        this.resetPersistedFields(revertedLine);
        detailLines.remove(lineToRevertIndex);
        detailLines.add(lineToRevertIndex, revertedLine);
    }

    protected void resetPersistedFields(EffortCertificationDetail detailLine) {
        int persistedEffortPercent = detailLine.getEffortCertificationUpdatedOverallPercent();
        detailLine.setPersistedEffortPercent(new Integer(persistedEffortPercent));
        BigDecimal persistedPayrollAmount = detailLine.getEffortCertificationPayrollAmount().bigDecimalValue();
        detailLine.setPersistedPayrollAmount(new KualiDecimal(persistedPayrollAmount));
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        EffortCertificationDocument effortDocument = (EffortCertificationDocument)kualiDocumentFormBase.getDocument();
        EffortCertificationDocumentService effortCertificationDocumentService = (EffortCertificationDocumentService)SpringContext.getBean(EffortCertificationDocumentService.class);
        effortCertificationDocumentService.addRouteLooping(effortDocument);
        ActionForward actionForward = super.approve(mapping, (ActionForm)kualiDocumentFormBase, request, response);
        return actionForward;
    }

    public ActionForward insertBONote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        kualiDocumentFormBase.getNewNote().setNewCollectionRecord(true);
        return super.insertBONote(mapping, form, request, response);
    }

    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        super.populateAuthorizationFields(formBase);
        CertificationReportForm certificationReportForm = (CertificationReportForm)formBase;
        EffortCertificationDocumentAuthorizer certReportDocAuthorizer = (EffortCertificationDocumentAuthorizer)((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer("ECD");
        KualiDocumentFormBase kualiDocumentFormBase = formBase;
        EffortCertificationDocument effortDocument = (EffortCertificationDocument)kualiDocumentFormBase.getDocument();
        String currentPrincipalId = GlobalVariables.getUserSession().getPrincipalId();
        HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
        additionalPermissionDetails.put("editMode", "summaryTabEntry");
        List<EffortCertificationDetail> summarizedDetailLines = this.createSummarizedDetailLines(certificationReportForm);
        HashMap<String, String> additionalRoleQualifiers = new HashMap<String, String>();
        String proposalNumber = this.getPropsalNumberForProjectDirector(currentPrincipalId, summarizedDetailLines);
        if (StringUtils.isNotBlank((CharSequence)proposalNumber)) {
            additionalRoleQualifiers.put("proposal", proposalNumber);
            if (certReportDocAuthorizer.doPermissionExistsByTemplate((BusinessObject)effortDocument, "KR-NS", "Use Transactional Document", additionalPermissionDetails) && !certReportDocAuthorizer.isAuthorizedByTemplate((Object)effortDocument, "KR-NS", "Use Transactional Document", currentPrincipalId, additionalPermissionDetails, additionalRoleQualifiers)) {
                formBase.getEditingMode().put("summaryTabEntry", "true");
            }
        }
    }

    protected String getPropsalNumberForProjectDirector(String projectDirectorId, List<EffortCertificationDetail> summarizedDetailLines) {
        String proposalNumber = null;
        Object chartOfAccountsCode = null;
        Object accountNumber = null;
        for (EffortCertificationDetail line : summarizedDetailLines) {
            proposalNumber = ((ContractsAndGrantsModuleService)SpringContext.getBean(ContractsAndGrantsModuleService.class)).getProposalNumberForAccountAndProjectDirector(line.getChartOfAccountsCode(), line.getAccountNumber(), projectDirectorId);
            if (!StringUtils.isNotEmpty((CharSequence)proposalNumber)) continue;
            break;
        }
        return proposalNumber;
    }

    protected List<EffortCertificationDetail> createSummarizedDetailLines(CertificationReportForm certificationReportForm) {
        List<Object> summarizedDetailLines = new ArrayList();
        Object detailLineGroupMap = null;
        summarizedDetailLines = certificationReportForm.getSummarizedDetailLines();
        if ((ObjectUtils.isNull(summarizedDetailLines) || summarizedDetailLines.isEmpty()) && ObjectUtils.isNotNull(certificationReportForm.getDetailLines()) && !certificationReportForm.getDetailLines().isEmpty()) {
            summarizedDetailLines = certificationReportForm.getDetailLines();
        }
        return summarizedDetailLines;
    }

    protected Map<String, String> convertSummarizedDetailToChartAccountMap(List<EffortCertificationDetail> summaryDetail) {
        HashMap<String, String> chartAccountMap = new HashMap<String, String>();
        for (EffortCertificationDetail line : summaryDetail) {
            chartAccountMap.put(line.getChartOfAccountsCode(), line.getAccountNumber());
        }
        return chartAccountMap;
    }
}

