/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coreservice.framework.parameter.ParameterConstants;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.service.EffortCertificationDocumentService;
import org.kuali.kfs.module.ec.util.EffortCertificationParameterFinder;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocumentBase;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

@ParameterConstants.COMPONENT(component="EffortCertification")
public class EffortCertificationDocument
extends FinancialSystemTransactionalDocumentBase {
    private static final Logger LOG = LogManager.getLogger(EffortCertificationDocument.class);
    protected static final String DO_AWARD_SPLIT = "DoAwardSplit";
    protected static final String DO_RECREATE_SPLIT = "DoRecreateSplit";
    protected String effortCertificationReportNumber;
    protected boolean effortCertificationDocumentCode;
    protected Integer universityFiscalYear;
    protected String emplid;
    protected String organizationCode;
    protected KualiDecimal financialDocumentTotalAmount;
    protected Integer totalEffortPercent;
    protected Integer totalOriginalEffortPercent;
    protected KualiDecimal totalPayrollAmount;
    protected KualiDecimal totalOriginalPayrollAmount;
    protected EffortCertificationReportDefinition effortCertificationReportDefinition;
    protected Person employee;
    protected Organization organization;
    protected SystemOptions options;
    protected List<EffortCertificationDetail> effortCertificationDetailLines = new ArrayList<EffortCertificationDetail>();
    protected List<EffortCertificationDetail> summarizedDetailLines = new ArrayList<EffortCertificationDetail>();
    protected Person ledgerPerson;

    public String getEffortCertificationReportNumber() {
        return this.effortCertificationReportNumber;
    }

    public void setEffortCertificationReportNumber(String effortCertificationReportNumber) {
        this.effortCertificationReportNumber = effortCertificationReportNumber;
    }

    public boolean getEffortCertificationDocumentCode() {
        return this.effortCertificationDocumentCode;
    }

    public void setEffortCertificationDocumentCode(boolean effortCertificationDocumentCode) {
        this.effortCertificationDocumentCode = effortCertificationDocumentCode;
    }

    public Integer getUniversityFiscalYear() {
        return this.universityFiscalYear;
    }

    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    public String getOrganizationCode() {
        return this.organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public String getEmplid() {
        return this.emplid;
    }

    public void setEmplid(String emplid) {
        this.emplid = emplid;
    }

    public EffortCertificationReportDefinition getEffortCertificationReportDefinition() {
        return this.effortCertificationReportDefinition;
    }

    @Deprecated
    public void setEffortCertificationReportDefinition(EffortCertificationReportDefinition effortCertificationReportDefinition) {
        this.effortCertificationReportDefinition = effortCertificationReportDefinition;
    }

    public Person getEmployee() {
        if (StringUtils.isNotBlank((CharSequence)this.getEmplid())) {
            return ((PersonService)SpringContext.getBean(PersonService.class)).getPersonByEmployeeId(this.getEmplid());
        }
        return null;
    }

    public void setEmployee(Person employee) {
        this.employee = employee;
    }

    public Person getLedgerPerson() {
        if ((this.ledgerPerson == null || !StringUtils.equals((CharSequence)this.ledgerPerson.getEmployeeId(), (CharSequence)this.emplid)) && StringUtils.isNotBlank((CharSequence)this.emplid)) {
            this.ledgerPerson = ((PersonService)SpringContext.getBean(PersonService.class)).getPersonByEmployeeId(this.emplid);
        }
        return this.ledgerPerson;
    }

    public void setLedgerPerson(Person ledgerPerson) {
        this.ledgerPerson = ledgerPerson;
    }

    public SystemOptions getOptions() {
        return this.options;
    }

    public void setOptions(SystemOptions options) {
        this.options = options;
    }

    public List<EffortCertificationDetail> getEffortCertificationDetailLines() {
        return this.effortCertificationDetailLines;
    }

    @Deprecated
    public void setEffortCertificationDetailLines(List<EffortCertificationDetail> effortCertificationDetailLines) {
        this.effortCertificationDetailLines = effortCertificationDetailLines;
    }

    public static KualiDecimal getDocumentTotalAmount(EffortCertificationDocument effortCertificationDocument) {
        List<EffortCertificationDetail> detailLines = effortCertificationDocument.getEffortCertificationDetailLines();
        return EffortCertificationDetail.getTotalPayrollAmount(detailLines);
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        LOG.debug("doRouteStatusChange() start...");
        super.doRouteStatusChange(statusChangeEvent);
        WorkflowDocument workflowDocument = this.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isFinal()) {
            GlobalVariables.setUserSession((UserSession)new UserSession("kfs"));
            ((EffortCertificationDocumentService)SpringContext.getBean(EffortCertificationDocumentService.class)).generateSalaryExpenseTransferDocument(this);
        }
    }

    public Integer getTotalEffortPercent() {
        return EffortCertificationDetail.getTotalEffortPercent(this.getEffortCertificationDetailLines());
    }

    public Integer getTotalOriginalEffortPercent() {
        return EffortCertificationDetail.getTotalOriginalEffortPercent(this.getEffortCertificationDetailLines());
    }

    public KualiDecimal getTotalPayrollAmount() {
        return EffortCertificationDetail.getTotalPayrollAmount(this.getEffortCertificationDetailLines());
    }

    public KualiDecimal getTotalOriginalPayrollAmount() {
        return EffortCertificationDetail.getTotalOriginalPayrollAmount(this.getEffortCertificationDetailLines());
    }

    public List<EffortCertificationDetail> getEffortCertificationDetailWithMaxPayrollAmount() {
        ArrayList<EffortCertificationDetail> detailLines = new ArrayList<EffortCertificationDetail>();
        KualiDecimal maxAmount = null;
        for (EffortCertificationDetail line : this.getEffortCertificationDetailLines()) {
            KualiDecimal currentAmount = line.getEffortCertificationPayrollAmount();
            if (maxAmount == null) {
                maxAmount = currentAmount;
                detailLines.add(line);
                continue;
            }
            if (maxAmount.isLessThan((AbstractKualiDecimal)currentAmount)) {
                detailLines.removeAll(detailLines);
                maxAmount = currentAmount;
                detailLines.add(line);
                continue;
            }
            if (!maxAmount.equals((Object)currentAmount)) continue;
            detailLines.add(line);
        }
        return detailLines;
    }

    public Integer getFederalTotalEffortPercent() {
        Integer effortFederalTotal = 0;
        List<EffortCertificationDetail> detailLineList = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : detailLineList) {
            if (!detailLine.isFederalOrFederalPassThroughIndicator()) continue;
            effortFederalTotal = effortFederalTotal + detailLine.getEffortCertificationUpdatedOverallPercent();
        }
        return effortFederalTotal;
    }

    public Integer getFederalTotalOriginalEffortPercent() {
        Integer effortOrigFederalTotal = 0;
        List<EffortCertificationDetail> detailLineList = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : detailLineList) {
            if (!detailLine.isFederalOrFederalPassThroughIndicator()) continue;
            effortOrigFederalTotal = effortOrigFederalTotal + detailLine.getEffortCertificationCalculatedOverallPercent();
        }
        return effortOrigFederalTotal;
    }

    public KualiDecimal getFederalTotalOriginalFringeBenefit() {
        KualiDecimal totalBenAmount = KualiDecimal.ZERO;
        List<EffortCertificationDetail> detailLineList = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : detailLineList) {
            if (!detailLine.isFederalOrFederalPassThroughIndicator()) continue;
            totalBenAmount = (KualiDecimal)totalBenAmount.add((AbstractKualiDecimal)detailLine.getOriginalFringeBenefitAmount());
        }
        return totalBenAmount;
    }

    public KualiDecimal getOtherTotalOriginalFringeBenefit() {
        KualiDecimal totalBenAmount = KualiDecimal.ZERO;
        List<EffortCertificationDetail> detailLineList = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : detailLineList) {
            if (detailLine.isFederalOrFederalPassThroughIndicator()) continue;
            totalBenAmount = (KualiDecimal)totalBenAmount.add((AbstractKualiDecimal)detailLine.getOriginalFringeBenefitAmount());
        }
        return totalBenAmount;
    }

    public KualiDecimal getFederalTotalFringeBenefit() {
        KualiDecimal totalBenAmount = KualiDecimal.ZERO;
        List<EffortCertificationDetail> detailLineList = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : detailLineList) {
            if (!detailLine.isFederalOrFederalPassThroughIndicator()) continue;
            totalBenAmount = (KualiDecimal)totalBenAmount.add((AbstractKualiDecimal)detailLine.getFringeBenefitAmount());
        }
        return totalBenAmount;
    }

    public KualiDecimal getOtherTotalFringeBenefit() {
        KualiDecimal totalBenAmount = KualiDecimal.ZERO;
        List<EffortCertificationDetail> detailLineList = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : detailLineList) {
            if (detailLine.isFederalOrFederalPassThroughIndicator()) continue;
            totalBenAmount = (KualiDecimal)totalBenAmount.add((AbstractKualiDecimal)detailLine.getFringeBenefitAmount());
        }
        return totalBenAmount;
    }

    public Integer getOtherTotalOriginalEffortPercent() {
        Integer effortOrigOtherTotal = 0;
        List<EffortCertificationDetail> detailLineList = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : detailLineList) {
            if (detailLine.isFederalOrFederalPassThroughIndicator()) continue;
            effortOrigOtherTotal = effortOrigOtherTotal + detailLine.getEffortCertificationCalculatedOverallPercent();
        }
        return effortOrigOtherTotal;
    }

    public Integer getOtherTotalEffortPercent() {
        Integer effortOtherTotal = 0;
        List<EffortCertificationDetail> detailLineList = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : detailLineList) {
            if (detailLine.isFederalOrFederalPassThroughIndicator()) continue;
            effortOtherTotal = effortOtherTotal + detailLine.getEffortCertificationUpdatedOverallPercent();
        }
        return effortOtherTotal;
    }

    public KualiDecimal getFederalTotalPayrollAmount() {
        KualiDecimal salaryFederalTotal = KualiDecimal.ZERO;
        List<EffortCertificationDetail> detailLineList = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : detailLineList) {
            if (!detailLine.isFederalOrFederalPassThroughIndicator()) continue;
            salaryFederalTotal = (KualiDecimal)salaryFederalTotal.add((AbstractKualiDecimal)detailLine.getEffortCertificationPayrollAmount());
        }
        return salaryFederalTotal;
    }

    public KualiDecimal getFederalTotalOriginalPayrollAmount() {
        KualiDecimal salaryOrigFederalTotal = KualiDecimal.ZERO;
        List<EffortCertificationDetail> detailLineList = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : detailLineList) {
            if (!detailLine.isFederalOrFederalPassThroughIndicator()) continue;
            salaryOrigFederalTotal = (KualiDecimal)salaryOrigFederalTotal.add((AbstractKualiDecimal)detailLine.getEffortCertificationOriginalPayrollAmount());
        }
        return salaryOrigFederalTotal;
    }

    public KualiDecimal getOtherTotalOriginalPayrollAmount() {
        KualiDecimal salaryOrigOtherTotal = KualiDecimal.ZERO;
        List<EffortCertificationDetail> detailLineList = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : detailLineList) {
            if (detailLine.isFederalOrFederalPassThroughIndicator()) continue;
            salaryOrigOtherTotal = (KualiDecimal)salaryOrigOtherTotal.add((AbstractKualiDecimal)detailLine.getEffortCertificationOriginalPayrollAmount());
        }
        return salaryOrigOtherTotal;
    }

    public KualiDecimal getOtherTotalPayrollAmount() {
        KualiDecimal salaryOtherTotal = KualiDecimal.ZERO;
        List<EffortCertificationDetail> detailLineList = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : detailLineList) {
            if (detailLine.isFederalOrFederalPassThroughIndicator()) continue;
            salaryOtherTotal = (KualiDecimal)salaryOtherTotal.add((AbstractKualiDecimal)detailLine.getEffortCertificationPayrollAmount());
        }
        return salaryOtherTotal;
    }

    public KualiDecimal getTotalFringeBenefit() {
        return EffortCertificationDetail.getTotalFringeBenefit(this.effortCertificationDetailLines);
    }

    public KualiDecimal getTotalOriginalFringeBenefit() {
        return EffortCertificationDetail.getTotalOriginalFringeBenefit(this.effortCertificationDetailLines);
    }

    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        for (EffortCertificationDetail detailLine : this.getEffortCertificationDetailLines()) {
            detailLine.setPersistedPayrollAmount(new KualiDecimal(detailLine.getEffortCertificationPayrollAmount().bigDecimalValue()));
            int effortPercent = detailLine.getEffortCertificationUpdatedOverallPercent();
            detailLine.setPersistedEffortPercent(new Integer(effortPercent));
        }
        for (EffortCertificationDetail detailLine : this.getEffortCertificationDetailLines()) {
            detailLine.recalculateOriginalFringeBenefit();
        }
    }

    public boolean isEffortDistributionChanged() {
        for (EffortCertificationDetail detail : this.getEffortCertificationDetailLines()) {
            if (detail.getEffortCertificationCalculatedOverallPercent().equals(detail.getEffortCertificationUpdatedOverallPercent())) continue;
            return true;
        }
        return false;
    }

    public String getDefaultPositionNumber() {
        return this.getMaxEffortLine().getPositionNumber();
    }

    public String getDefaultObjectCode() {
        return this.getMaxEffortLine().getFinancialObjectCode();
    }

    protected EffortCertificationDetail getMaxEffortLine() {
        Integer maxEffort = 0;
        EffortCertificationDetail maxLine = null;
        List<EffortCertificationDetail> detailLines = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : detailLines) {
            if (detailLine.getEffortCertificationUpdatedOverallPercent() <= maxEffort) continue;
            maxEffort = detailLine.getEffortCertificationUpdatedOverallPercent();
            maxLine = detailLine;
        }
        return maxLine;
    }

    public void populateDocumentForRouting() {
        if (ObjectUtils.isNotNull((Object)this.getTotalPayrollAmount())) {
            this.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(this.getTotalPayrollAmount());
        } else {
            this.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(new KualiDecimal(0));
        }
        super.populateDocumentForRouting();
    }

    public List<String> getObjectCodeList() {
        ArrayList<String> uniqueObjectCodeList = new ArrayList<String>();
        List<EffortCertificationDetail> allObjectCodesList = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detail : allObjectCodesList) {
            if (uniqueObjectCodeList.contains(detail.getFinancialObjectCode())) continue;
            uniqueObjectCodeList.add(detail.getFinancialObjectCode());
        }
        return uniqueObjectCodeList;
    }

    public List<String> getPositionList() {
        ArrayList<String> uniquePositionList = new ArrayList<String>();
        List<EffortCertificationDetail> allPositionsList = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detail : allPositionsList) {
            if (uniquePositionList.contains(detail.getPositionNumber())) continue;
            uniquePositionList.add(detail.getPositionNumber());
        }
        return uniquePositionList;
    }

    public void setTotalOriginalPayrollAmount(KualiDecimal totalOriginalPayrollAmount) {
    }

    public List<EffortCertificationDetail> getSummarizedDetailLines() {
        return this.summarizedDetailLines;
    }

    public void setSummarizedDetailLines(List<EffortCertificationDetail> summarizedDetailLines) {
        this.summarizedDetailLines = summarizedDetailLines;
    }

    public boolean answerSplitNodeQuestion(String nodeName) throws UnsupportedOperationException {
        if (nodeName.equals(DO_AWARD_SPLIT)) {
            return this.isDoAwardSplit();
        }
        if (nodeName.equals(DO_RECREATE_SPLIT)) {
            return this.isDoRecreateSplit();
        }
        if (nodeName.equals("RequiresWorkstudyReview")) {
            return this.checkOjbectCodeForWorkstudy();
        }
        throw new UnsupportedOperationException("Cannot answer split question for this node you call \"" + nodeName + "\"");
    }

    protected boolean checkOjbectCodeForWorkstudy() {
        Collection workstudyRouteObjectcodes = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(KfsParameterConstants.FINANCIAL_SYSTEM_DOCUMENT.class, "WORKSTUDY_ROUTE_OBJECT_CODES");
        List<EffortCertificationDetail> effortCertificationDetails = this.getEffortCertificationDetailLines();
        for (EffortCertificationDetail effortCertificationDetail : effortCertificationDetails) {
            if (!workstudyRouteObjectcodes.contains(effortCertificationDetail.getFinancialObjectCode())) continue;
            return true;
        }
        return false;
    }

    public List<EffortCertificationDetail> getDetailLinesForPDRouting() {
        boolean federalOnlyRouting = EffortCertificationParameterFinder.getFederalOnlyRouteIndicator();
        if (!federalOnlyRouting) {
            return this.effortCertificationDetailLines;
        }
        ArrayList<EffortCertificationDetail> federalDetailLines = new ArrayList<EffortCertificationDetail>();
        for (EffortCertificationDetail detail : this.effortCertificationDetailLines) {
            if (!detail.isFederalOrFederalPassThroughIndicator()) continue;
            federalDetailLines.add(detail);
        }
        return federalDetailLines;
    }

    protected boolean isDoAwardSplit() {
        return this.isEffortDistributionChanged();
    }

    protected boolean isDoRecreateSplit() {
        return this.getEffortCertificationDocumentCode();
    }
}

