/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.validation.impl;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.A21SubAccount;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public class EffortCertificationDocumentRuleUtil {
    public static void applyDefaultValues(EffortCertificationDetail detailLine) {
        if (StringUtils.isBlank((CharSequence)detailLine.getSubAccountNumber())) {
            detailLine.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
        }
        if (StringUtils.isBlank((CharSequence)detailLine.getCostShareSourceSubAccountNumber())) {
            detailLine.setCostShareSourceSubAccountNumber(KFSConstants.getDashSubAccountNumber());
        }
        if (StringUtils.isBlank((CharSequence)detailLine.getSourceChartOfAccountsCode())) {
            detailLine.setSourceChartOfAccountsCode("--");
        }
        if (StringUtils.isBlank((CharSequence)detailLine.getSourceAccountNumber())) {
            detailLine.setSourceAccountNumber("-------");
        }
        if (ObjectUtils.isNull((Object)detailLine.getEffortCertificationPayrollAmount())) {
            detailLine.setEffortCertificationPayrollAmount(KualiDecimal.ZERO);
        }
        if (ObjectUtils.isNull((Object)detailLine.getEffortCertificationOriginalPayrollAmount())) {
            detailLine.setEffortCertificationOriginalPayrollAmount(KualiDecimal.ZERO);
        }
        if (ObjectUtils.isNull((Object)detailLine.getEffortCertificationCalculatedOverallPercent())) {
            detailLine.setEffortCertificationCalculatedOverallPercent(0);
        }
        if (ObjectUtils.isNull((Object)detailLine.getEffortCertificationUpdatedOverallPercent())) {
            detailLine.setEffortCertificationUpdatedOverallPercent(0);
        }
        if (ObjectUtils.isNull((Object)detailLine.getUniversityFiscalYear())) {
            UniversityDateService universityDateService = (UniversityDateService)SpringContext.getBean(UniversityDateService.class);
            if (detailLine.getUniversityFiscalYear() == null) {
                detailLine.setUniversityFiscalYear(universityDateService.getCurrentFiscalYear());
            }
        }
    }

    public static boolean canExpiredAccountBeUsed(EffortCertificationDetail detailLine) {
        Account account = detailLine.getAccount();
        boolean canExpiredAccountUsed = true;
        if (ObjectUtils.isNotNull((Object)account) && account.isExpired()) {
            String overrideCode = detailLine.getOverrideCode();
            canExpiredAccountUsed = Arrays.asList("EXPIRED_ACCOUNT", "EXPIRED_ACCOUNT_AND_NON_FRINGE_ACCOUNT_USED").contains(overrideCode);
        }
        return canExpiredAccountUsed;
    }

    public static boolean hasA21SubAccount(EffortCertificationDetail detailLine) {
        String subAccountNumber = detailLine.getSubAccountNumber();
        if (KFSConstants.getDashSubAccountNumber().equals(subAccountNumber)) {
            return false;
        }
        return ObjectUtils.isNotNull((Object)detailLine.getSubAccount().getA21SubAccount());
    }

    public static boolean hasClosedAccount(EffortCertificationDetail detailLine) {
        return !detailLine.getAccount().isActive();
    }

    public static boolean hasContractGrantAccount(EffortCertificationDetail detailLine) {
        return detailLine.getAccount().isForContractsAndGrants();
    }

    public static boolean hasCostShareSubAccount(EffortCertificationDetail detailLine, List<String> designatedCostShareSubAccountTypeCodes) {
        if (!EffortCertificationDocumentRuleUtil.hasA21SubAccount(detailLine)) {
            return false;
        }
        String costShareSubAccountTypeCode = detailLine.getSubAccount().getA21SubAccount().getSubAccountTypeCode();
        return designatedCostShareSubAccountTypeCodes.contains(costShareSubAccountTypeCode);
    }

    public static boolean hasNonnegativePayrollAmount(EffortCertificationDetail detailLine) {
        KualiDecimal payrollAmount = detailLine.getEffortCertificationPayrollAmount();
        return ObjectUtils.isNotNull((Object)payrollAmount) && EffortCertificationDocumentRuleUtil.isPayrollAmountNonnegative(payrollAmount);
    }

    public static boolean hasSameExistingLine(EffortCertificationDocument document, EffortCertificationDetail detailLine, List<String> comparableFields) {
        List<EffortCertificationDetail> detailLines = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail line : detailLines) {
            if (detailLine == line || !ObjectUtil.equals((Object)((Object)line), (Object)((Object)detailLine), comparableFields)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasValidEffortPercent(EffortCertificationDetail detailLine) {
        Integer effortPercent = detailLine.getEffortCertificationUpdatedOverallPercent();
        return ObjectUtils.isNotNull((Object)effortPercent) && EffortCertificationDocumentRuleUtil.isValidPercent(effortPercent);
    }

    public static boolean hasValidFormat(EffortCertificationDetail detailLine) {
        int originalErrorCount = GlobalVariables.getMessageMap().getErrorCount();
        ((DictionaryValidationService)SpringContext.getBean(DictionaryValidationService.class)).validateBusinessObject((BusinessObject)detailLine);
        int currentErrorCount = GlobalVariables.getMessageMap().getErrorCount();
        return currentErrorCount == originalErrorCount;
    }

    public static boolean isPayrollAmountChangedFromOriginal(EffortCertificationDetail detailLine) {
        KualiDecimal payrollAmount = detailLine.getEffortCertificationPayrollAmount();
        KualiDecimal originalPayrollAmount = detailLine.getEffortCertificationOriginalPayrollAmount();
        KualiDecimal difference = (KualiDecimal)originalPayrollAmount.subtract((AbstractKualiDecimal)payrollAmount);
        return difference.isNonZero();
    }

    public static boolean isPayrollAmountChangedFromOriginal(EffortCertificationDocument document) {
        List<EffortCertificationDetail> detailLines = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail line : detailLines) {
            if (!EffortCertificationDocumentRuleUtil.isPayrollAmountChangedFromOriginal(line)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPayrollAmountChangedFromPersisted(EffortCertificationDetail detailLine) {
        KualiDecimal persistedAmount = detailLine.getPersistedPayrollAmount();
        KualiDecimal difference = KualiDecimal.ZERO;
        if (ObjectUtils.isNotNull((Object)persistedAmount)) {
            KualiDecimal payrollAmount = detailLine.getEffortCertificationPayrollAmount();
            difference = (KualiDecimal)persistedAmount.subtract((AbstractKualiDecimal)payrollAmount);
        }
        return difference.isNonZero();
    }

    public static boolean isPayrollAmountChangedFromPersisted(EffortCertificationDocument document) {
        List<EffortCertificationDetail> detailLines = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail line : detailLines) {
            if (!EffortCertificationDocumentRuleUtil.isPayrollAmountChangedFromPersisted(line)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEffortPercentChangedFromPersisted(EffortCertificationDetail detailLine) {
        Integer effortPercent;
        Integer persistedAmount = detailLine.getPersistedEffortPercent();
        return !persistedAmount.equals(effortPercent = detailLine.getEffortCertificationUpdatedOverallPercent());
    }

    public static boolean isEffortPercentChangedFromPersisted(EffortCertificationDocument document) {
        List<EffortCertificationDetail> detailLines = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail line : detailLines) {
            if (!EffortCertificationDocumentRuleUtil.isEffortPercentChangedFromPersisted(line)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPayrollAmountNonnegative(KualiDecimal payrollAmount) {
        return payrollAmount.isGreaterEqual((AbstractKualiDecimal)KualiDecimal.ZERO);
    }

    public static boolean isOriginalEffortPercentSameAsCurrentEffortPercent(Integer originalEffortPercent, Integer effortPercent) {
        return originalEffortPercent.equals(effortPercent);
    }

    public static boolean isPayrollAmountOverChanged(EffortCertificationDetail detailLine, KualiDecimal originalTotalAmount, double limitOfLinePayrollAmountChange) {
        Integer effortPercent;
        KualiDecimal payrollAmount = detailLine.getEffortCertificationPayrollAmount();
        KualiDecimal originalPayrollAmount = detailLine.getEffortCertificationOriginalPayrollAmount();
        KualiDecimal difference = KualiDecimal.ZERO;
        Integer originalEffortPercent = detailLine.getEffortCertificationCalculatedOverallPercent();
        if (EffortCertificationDocumentRuleUtil.isOriginalEffortPercentSameAsCurrentEffortPercent(originalEffortPercent, effortPercent = detailLine.getEffortCertificationUpdatedOverallPercent())) {
            difference = (KualiDecimal)((KualiDecimal)((KualiDecimal)originalPayrollAmount.subtract((AbstractKualiDecimal)payrollAmount)).multiply((AbstractKualiDecimal)KFSConstants.CurrencyTypeAmounts.HUNDRED_DOLLAR_AMOUNT)).abs();
            return ((KualiDecimal)difference.divide((AbstractKualiDecimal)originalTotalAmount)).doubleValue() > limitOfLinePayrollAmountChange * (double)KFSConstants.CurrencyTypeAmounts.HUNDRED_DOLLAR_AMOUNT.intValue();
        }
        return false;
    }

    public static boolean isPayrollAmountOverChanged(EffortCertificationDocument document, double limitOfLinePayrollAmountChange) {
        List<EffortCertificationDetail> detailLines = document.getEffortCertificationDetailLines();
        KualiDecimal originalTotalAmount = document.getTotalOriginalPayrollAmount();
        for (EffortCertificationDetail line : detailLines) {
            if (!EffortCertificationDocumentRuleUtil.isPayrollAmountOverChanged(line, originalTotalAmount, limitOfLinePayrollAmountChange)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTotalEffortPercentageAs100(EffortCertificationDocument document) {
        return document.getTotalEffortPercent() == 100;
    }

    public static boolean isTotalPayrollAmountOverChanged(EffortCertificationDocument document, double limitOfTotalPayrollAmountChange) {
        KualiDecimal totalPayrollAmount = document.getTotalPayrollAmount();
        KualiDecimal totalOriginalPayrollAmount = document.getTotalOriginalPayrollAmount();
        KualiDecimal difference = (KualiDecimal)((KualiDecimal)totalOriginalPayrollAmount.subtract((AbstractKualiDecimal)totalPayrollAmount)).abs();
        return difference.doubleValue() > limitOfTotalPayrollAmountChange;
    }

    public static boolean isValidPercent(Integer percent) {
        return percent >= 0 && percent <= 100;
    }

    public static void updateSourceAccountInformation(EffortCertificationDetail detailLine) {
        A21SubAccount a21SubAccount = detailLine.getSubAccount().getA21SubAccount();
        if (ObjectUtils.isNotNull((Object)a21SubAccount)) {
            detailLine.setSourceChartOfAccountsCode(a21SubAccount.getCostShareChartOfAccountCode());
            detailLine.setSourceAccountNumber(a21SubAccount.getCostShareSourceAccountNumber());
            detailLine.setCostShareSourceSubAccountNumber(a21SubAccount.getCostShareSourceSubAccountNumber());
        }
    }

    public static boolean hasDetailLine(EffortCertificationDocument document) {
        List<EffortCertificationDetail> detailLines = document.getEffortCertificationDetailLines();
        return detailLines != null && !detailLines.isEmpty();
    }
}

