/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.validation.impl;

import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportPosition;

public class EffortCertificationReportDefinitionRule
extends MaintenanceDocumentRuleBase {
    private static final Logger LOG = LogManager.getLogger(EffortCertificationReportDefinitionRule.class);

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        Collection<EffortCertificationReportPosition> reportPositions;
        LOG.debug("processCustomRouteDocumentBusinessRules() start");
        if (GlobalVariables.getMessageMap().getErrorCount() > 0) {
            return false;
        }
        boolean isValid = true;
        EffortCertificationReportDefinition reportDefintion = (EffortCertificationReportDefinition)document.getNewMaintainableObject().getBusinessObject();
        Integer beginPeriodCode = Integer.parseInt(reportDefintion.getEffortCertificationReportBeginPeriodCode());
        Integer endPeriodCode = Integer.parseInt(reportDefintion.getEffortCertificationReportEndPeriodCode());
        if (reportDefintion.getEffortCertificationReportBeginFiscalYear() > reportDefintion.getEffortCertificationReportEndFiscalYear() || reportDefintion.getEffortCertificationReportBeginFiscalYear().equals(reportDefintion.getEffortCertificationReportEndFiscalYear()) && Integer.parseInt(reportDefintion.getEffortCertificationReportBeginPeriodCode()) >= Integer.parseInt(reportDefintion.getEffortCertificationReportEndPeriodCode())) {
            this.putFieldError("effortCertificationReportEndFiscalYear", "error.efffort.effortCertificationReport.endFiscalYear");
            isValid = false;
        }
        if ((reportPositions = reportDefintion.getEffortCertificationReportPositions()) == null || reportPositions.isEmpty()) {
            this.putFieldError("effortCertificationReportPositions", "error.effort.notHavePositionGroup");
            isValid = false;
        }
        if (ObjectUtils.isNull((Object)reportDefintion.getReportBeginPeriod())) {
            this.putFieldError("effortCertificationReportBeginFiscalYear", "error.rptdefn.begin.period.invalid");
            isValid = false;
        }
        if (ObjectUtils.isNull((Object)reportDefintion.getReportEndPeriod())) {
            this.putFieldError("effortCertificationReportEndFiscalYear", "error.rptdefn.end.period.invalid");
            isValid = false;
        }
        if (ObjectUtils.isNull((Object)reportDefintion.getExpenseTransferFiscalPeriod())) {
            this.putFieldError("expenseTransferFiscalYear", "error.rptdefn.transfer.period.invalid");
            isValid = false;
        }
        return isValid;
    }
}

