/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.A21SubAccount;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ec.EffortConstants;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetailBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.service.EffortCertificationDetailBuildService;
import org.kuali.kfs.module.ec.util.LedgerBalanceConsolidationHelper;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class EffortCertificationDetailBuildServiceImpl
implements EffortCertificationDetailBuildService {
    private static final Logger LOG = LogManager.getLogger(EffortCertificationDetailBuildServiceImpl.class);

    @Override
    public EffortCertificationDetailBuild generateDetailBuild(Integer postingYear, LaborLedgerBalance ledgerBalance, EffortCertificationReportDefinition reportDefinition) {
        EffortCertificationDetailBuild detailLine = new EffortCertificationDetailBuild();
        detailLine.setUniversityFiscalYear(postingYear);
        detailLine.setAccountNumber(ledgerBalance.getAccountNumber());
        detailLine.setChartOfAccountsCode(ledgerBalance.getChartOfAccountsCode());
        detailLine.setPositionNumber(ledgerBalance.getPositionNumber());
        detailLine.setFinancialObjectCode(ledgerBalance.getFinancialObjectCode());
        Map<Integer, Set<String>> reportPeriods = reportDefinition.getReportPeriods();
        KualiDecimal payrollAmount = LedgerBalanceConsolidationHelper.calculateTotalAmountWithinReportPeriod(ledgerBalance, reportPeriods);
        detailLine.setEffortCertificationPayrollAmount(payrollAmount);
        detailLine.setEffortCertificationOriginalPayrollAmount(payrollAmount);
        detailLine.setEffortCertificationCalculatedOverallPercent(0);
        detailLine.setEffortCertificationUpdatedOverallPercent(0);
        this.populateCostShareRelatedFields(detailLine, ledgerBalance);
        return detailLine;
    }

    protected void populateCostShareRelatedFields(EffortCertificationDetailBuild detailLine, LaborLedgerBalance ledgerBalance) {
        String subAccountTypeCode;
        List<String> expenseSubAccountTypeCodes = EffortConstants.ELIGIBLE_EXPENSE_SUB_ACCOUNT_TYPE_CODES;
        List<String> costShareSubAccountTypeCodes = EffortConstants.ELIGIBLE_COST_SHARE_SUB_ACCOUNT_TYPE_CODES;
        A21SubAccount A21SubAccount2 = this.getA21SubAccount(ledgerBalance);
        String string = subAccountTypeCode = ObjectUtils.isNull((Object)A21SubAccount2) ? null : A21SubAccount2.getSubAccountTypeCode();
        if (ObjectUtils.isNull((Object)subAccountTypeCode) || expenseSubAccountTypeCodes.contains(subAccountTypeCode)) {
            detailLine.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
            detailLine.setSourceChartOfAccountsCode("--");
            detailLine.setSourceAccountNumber("-------");
            detailLine.setCostShareSourceSubAccountNumber(null);
        } else if (costShareSubAccountTypeCodes.contains(subAccountTypeCode)) {
            detailLine.setSubAccountNumber(ledgerBalance.getSubAccountNumber());
            detailLine.setSourceChartOfAccountsCode(A21SubAccount2.getCostShareChartOfAccountCode());
            detailLine.setSourceAccountNumber(A21SubAccount2.getCostShareSourceAccountNumber());
            detailLine.setCostShareSourceSubAccountNumber(A21SubAccount2.getCostShareSourceSubAccountNumber());
        } else {
            detailLine.setSubAccountNumber(ledgerBalance.getSubAccountNumber());
            detailLine.setSourceChartOfAccountsCode("--");
            detailLine.setSourceAccountNumber("-------");
            detailLine.setCostShareSourceSubAccountNumber(null);
        }
    }

    protected A21SubAccount getA21SubAccount(LaborLedgerBalance ledgerBalance) {
        A21SubAccount a21SubAccount = null;
        try {
            if (ObjectUtils.isNotNull((Object)ledgerBalance.getSubAccount())) {
                a21SubAccount = ledgerBalance.getSubAccount().getA21SubAccount();
            }
        }
        catch (NullPointerException npe) {
            LOG.debug((Object)npe);
        }
        return a21SubAccount;
    }
}

