/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.validation.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.integration.ld.LaborModuleService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.document.validation.impl.LedgerBalanceFieldValidator;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.module.ld.businessobject.LedgerBalanceForEffortCertification;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class LedgerBalanceFieldValidatorTest
extends KualiTestBase {
    private Properties properties;
    private Properties message;
    private String balanceFieldNames;
    private String deliminator;
    Integer postingYear;
    private BusinessObjectService businessObjectService;
    private PersistenceService persistenceService;
    private LaborModuleService laborModuleService;
    private Class<? extends LaborLedgerBalance> ledgerBalanceClass;

    public LedgerBalanceFieldValidatorTest() {
        String messageFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/ledgerBalanceFieldValidator.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.message = TestDataPreparator.loadPropertiesFromClassPath((String)messageFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.balanceFieldNames = this.properties.getProperty("balanceFieldNames");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.persistenceService = (PersistenceService)SpringContext.getBean(PersistenceService.class);
        this.laborModuleService = (LaborModuleService)SpringContext.getBean(LaborModuleService.class);
        KualiModuleService kualiModuleService = (KualiModuleService)SpringContext.getBean(KualiModuleService.class);
        this.ledgerBalanceClass = LedgerBalanceForEffortCertification.class;
        TestDataPreparator.doCleanUpWithoutReference(this.ledgerBalanceClass, (Properties)this.properties, (String)"dataCleanup", (String)this.balanceFieldNames, (String)this.deliminator);
    }

    public void testHasValidAccount_valid() throws Exception {
        String testTarget = "hasValidAccount.valid.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.hasValidAccount((LaborLedgerBalance)ledgerBalance);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasValidAccount.valid");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage, (validationMessage == null ? 1 : 0) != 0);
    }

    public void testHasValidAccount_invalid() throws Exception {
        String testTarget = "hasValidAccount.invalid.";
    }

    public void testIsInFundGroups_Contain() throws Exception {
        String testTarget = "isInFundGroups.contain.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "fundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.isInFundGroups((LaborLedgerBalance)ledgerBalance, (List)fundGroupCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isInFundGroups.contain");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage, (validationMessage == null ? 1 : 0) != 0);
    }

    public void testIsInFundGroups_NotContain() throws Exception {
        String testTarget = "isInFundGroups.notContain.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "fundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.isInFundGroups((LaborLedgerBalance)ledgerBalance, (List)fundGroupCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isInFundGroups.notContain");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage.toString(), (validationMessage != null ? 1 : 0) != 0);
    }

    public void testIsInSubFundGroups_Contain() throws Exception {
        String testTarget = "isInSubFundGroups.contain.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "subFundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.isInSubFundGroups((LaborLedgerBalance)ledgerBalance, (List)fundGroupCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isInSubFundGroups.contain");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage, (validationMessage == null ? 1 : 0) != 0);
    }

    public void testIsInSubFundGroups_NotContain() throws Exception {
        String testTarget = "isInSubFundGroups.notContain.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "subFundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.isInSubFundGroups((LaborLedgerBalance)ledgerBalance, (List)fundGroupCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isInSubFundGroups.notContain");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage.toString(), (validationMessage != null ? 1 : 0) != 0);
    }

    public void testIsNonZeroAmountBalanceWithinReportPeriod_IsNonZeroAmount() throws Exception {
        String testTarget = "isNonZeroAmountBalanceWithinReportPeriod.isNonZeroAmount.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.isNonZeroAmountBalanceWithinReportPeriod((LaborLedgerBalance)ledgerBalance, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isNonZeroAmountBalanceWithinReportPeriod.isNonZeroAmount");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage, (validationMessage == null ? 1 : 0) != 0);
    }

    public void testIsNonZeroAmountBalanceWithinReportPeriod_IsZeroAmount() throws Exception {
        String testTarget = "isNonZeroAmountBalanceWithinReportPeriod.isZeroAmount.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance(testTarget);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.isNonZeroAmountBalanceWithinReportPeriod((LaborLedgerBalance)ledgerBalance, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isNonZeroAmountBalanceWithinReportPeriod.isZeroAmount");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage.toString(), (validationMessage != null ? 1 : 0) != 0);
    }

    public void testIsTotalAmountPositive_IsPositive() throws Exception {
        String testTarget = "isTotalAmountPositive.isPositive.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.isTotalAmountPositive(ledgerBalances, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isTotalAmountPositive.isPositive");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage.toString(), (validationMessage == null ? 1 : 0) != 0);
    }

    public void testIsTotalAmountPositive_IsZero() throws Exception {
        String testTarget = "isTotalAmountPositive.isZero.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.isTotalAmountPositive(ledgerBalances, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isTotalAmountPositive.isZero");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage.toString(), (validationMessage != null ? 1 : 0) != 0);
    }

    public void testIsTotalAmountPositive_IsNegative() throws Exception {
        String testTarget = "isTotalAmountPositive.isNegative.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.isTotalAmountPositive(ledgerBalances, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isTotalAmountPositive.isNegative");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage.toString(), (validationMessage != null ? 1 : 0) != 0);
    }

    public void testHasGrantAccount_ByFundGroup_Contain() throws Exception {
        String testTarget = "hasGrantAccount.byFundGroup.contain.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "fundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.hasGrantAccount(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasGrantAccount.byFundGroup.contain");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage.toString(), (validationMessage == null ? 1 : 0) != 0);
    }

    public void testHasGrantAccount_ByFundGroup_NotContain() throws Exception {
        String testTarget = "hasGrantAccount.byFundGroup.notContain.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "fundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.hasGrantAccount(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasGrantAccount.byFundGroup.notContain");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage.toString(), (validationMessage != null ? 1 : 0) != 0);
    }

    public void testHasGrantAccount_BySubFundGroup_Contain() throws Exception {
        String testTarget = "hasGrantAccount.bySubFundGroup.contain.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "subFundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.hasGrantAccount(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasGrantAccount.bySubFundGroup.contain");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage.toString(), (validationMessage == null ? 1 : 0) != 0);
    }

    public void testHasGrantAccount_BySubFundGroup_NotContain() throws Exception {
        String testTarget = "hasGrantAccount.bySubFundGroup.notContain.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "subFundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.hasGrantAccount(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasGrantAccount.bySubFundGroup.notContain");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage.toString(), (validationMessage != null ? 1 : 0) != 0);
    }

    public void testIsFromSingleOrganization_Single() throws Exception {
        String testTarget = "isFromSingleOrganization.single.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.isFromSingleOrganization(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isFromSingleOrganization.single");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage.toString(), (validationMessage == null ? 1 : 0) != 0);
    }

    public void testIsFromSingleOrganization_Multiple() throws Exception {
        String testTarget = "isFromSingleOrganization.multiple.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        Message validationMessage = LedgerBalanceFieldValidator.isFromSingleOrganization(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isFromSingleOrganization.multiple");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage, (validationMessage != null ? 1 : 0) != 0);
    }

    public void testHasFederalFunds_FederalFunds() throws Exception {
        String testTarget = "hasFederalFunds.federalFunds.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        List federalAgencyTypeCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "federalAgencyTypeCodes"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.hasFederalFunds(ledgerBalances, (Collection)federalAgencyTypeCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasFederalFunds.federalFunds");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage.toString(), (validationMessage == null ? 1 : 0) != 0);
    }

    public void testHasFederalFunds_PassThrough() throws Exception {
        String testTarget = "hasFederalFunds.passThrough.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        List federalAgencyTypeCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "federalAgencyTypeCodes"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.hasFederalFunds(ledgerBalances, (Collection)federalAgencyTypeCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasFederalFunds.passThrough");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage.toString(), (validationMessage == null ? 1 : 0) != 0);
    }

    public void testHasFederalFunds_NoFederalFunds() throws Exception {
        String testTarget = "hasFederalFunds.noFederalFunds.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        List federalAgencyTypeCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "federalAgencyTypeCodes"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.hasFederalFunds(ledgerBalances, (Collection)federalAgencyTypeCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasFederalFunds.noFederalFunds");
        LedgerBalanceFieldValidatorTest.assertTrue((String)errorMessage.toString(), (validationMessage != null ? 1 : 0) != 0);
    }

    private LaborLedgerBalance buildLedgerBalance(String testTarget) {
        LaborLedgerBalance ledgerBalance = (LaborLedgerBalance)TestDataPreparator.buildTestDataObject(this.ledgerBalanceClass, (Properties)this.properties, (String)(testTarget + "inputBalance"), (String)this.balanceFieldNames, (String)this.deliminator);
        this.businessObjectService.save((PersistableBusinessObject)ledgerBalance);
        this.persistenceService.retrieveNonKeyFields((Object)ledgerBalance);
        ledgerBalance.refreshNonUpdateableReferences();
        return ledgerBalance;
    }

    private List<LaborLedgerBalance> buildLedgerBalances(String testTarget) {
        int numberOfTestData = Integer.valueOf(this.properties.getProperty(testTarget + "numOfData"));
        List ledgerBalances = TestDataPreparator.buildTestDataList(this.ledgerBalanceClass, (Properties)this.properties, (String)(testTarget + "inputBalance"), (String)this.balanceFieldNames, (String)this.deliminator, (int)numberOfTestData);
        this.businessObjectService.save(ledgerBalances);
        for (LaborLedgerBalance balance : ledgerBalances) {
            this.persistenceService.retrieveNonKeyFields((Object)balance);
            balance.refreshNonUpdateableReferences();
        }
        return ledgerBalances;
    }

    private EffortCertificationReportDefinition buildReportDefinition(String testTarget) {
        EffortCertificationReportDefinition reportDefinition = new EffortCertificationReportDefinition();
        String reprtDefinitionFieldNames = this.properties.getProperty("reportDefinitionFieldNames");
        ObjectUtil.populateBusinessObject((Object)reportDefinition, (Properties)this.properties, (String)(testTarget + "reportDefinitionFieldValues"), (String)reprtDefinitionFieldNames, (String)this.deliminator);
        return reportDefinition;
    }
}

