/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.util;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.kuali.kfs.module.ec.util.AccountingPeriodMonth;

public class AccountingPeriodMonthTest {
    private static final Integer YEAR_2008 = 2008;
    private static final Integer YEAR_2010 = 2010;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void findAccountingPeriod_MONTH1() {
        AccountingPeriodMonth month1 = AccountingPeriodMonth.findAccountingPeriod((String)AccountingPeriodMonth.MONTH1.periodCode);
        Assert.assertEquals((Object)AccountingPeriodMonth.MONTH1, (Object)month1);
    }

    @Test
    public void findAccountingPeriod_MONTH12() {
        AccountingPeriodMonth month12 = AccountingPeriodMonth.findAccountingPeriod((String)AccountingPeriodMonth.MONTH12.periodCode);
        Assert.assertEquals((Object)AccountingPeriodMonth.MONTH12, (Object)month12);
    }

    @Test
    public void findAccountingPeriod_MONTH6() {
        AccountingPeriodMonth month6 = AccountingPeriodMonth.findAccountingPeriod((String)AccountingPeriodMonth.MONTH6.periodCode);
        Assert.assertEquals((Object)AccountingPeriodMonth.MONTH6, (Object)month6);
        Assert.assertNotNull((Object)month6);
        Assert.assertEquals((long)-5L, (long)AccountingPeriodMonth.MONTH1.compareTo((Enum)month6));
        Assert.assertEquals((long)6L, (long)AccountingPeriodMonth.MONTH12.compareTo((Enum)month6));
    }

    @Test
    public void findAccountingPeriod_UNKNOWN_ReturnsNull() {
        AccountingPeriodMonth unknownMonth = AccountingPeriodMonth.findAccountingPeriod((String)"UNKNOWN");
        Assert.assertNull((Object)unknownMonth);
    }

    @Test
    public void findAccountingPeriod_EmptyMonth_ReturnsNull() {
        AccountingPeriodMonth emptyMonth = AccountingPeriodMonth.findAccountingPeriod((String)"");
        Assert.assertNull((Object)emptyMonth);
    }

    @Test
    public void findAccountingPeriodsBetween_WithinSameYear_Month1_Month12() {
        Map periods = AccountingPeriodMonth.findAccountingPeriodsBetween((Integer)YEAR_2008, (String)AccountingPeriodMonth.MONTH1.periodCode, (Integer)YEAR_2008, (String)AccountingPeriodMonth.MONTH12.periodCode);
        this.assertAccountingPeriodMonthEqual((Set)periods.get(YEAR_2008), AccountingPeriodMonth.MONTH1, AccountingPeriodMonth.MONTH12);
    }

    @Test
    public void findAccountingPeriodsBetween_WithinSameYear_Month1_Month3() {
        Map periods = AccountingPeriodMonth.findAccountingPeriodsBetween((Integer)YEAR_2008, (String)AccountingPeriodMonth.MONTH1.periodCode, (Integer)YEAR_2008, (String)AccountingPeriodMonth.MONTH12.periodCode);
        this.assertAccountingPeriodMonthEqual((Set)periods.get(YEAR_2008), AccountingPeriodMonth.MONTH1, AccountingPeriodMonth.MONTH12);
    }

    @Test
    public void findAccountingPeriodsBetween_WithinSameYear_Month4_Month8() {
        Map periods = AccountingPeriodMonth.findAccountingPeriodsBetween((Integer)YEAR_2008, (String)AccountingPeriodMonth.MONTH4.periodCode, (Integer)YEAR_2008, (String)AccountingPeriodMonth.MONTH8.periodCode);
        this.assertAccountingPeriodMonthEqual((Set)periods.get(YEAR_2008), AccountingPeriodMonth.MONTH4, AccountingPeriodMonth.MONTH8);
    }

    @Test
    public void findAccountingPeriodsBetween_WithinSameYear_Month9_Month12() {
        Map periods = AccountingPeriodMonth.findAccountingPeriodsBetween((Integer)YEAR_2008, (String)AccountingPeriodMonth.MONTH9.periodCode, (Integer)YEAR_2008, (String)AccountingPeriodMonth.MONTH12.periodCode);
        this.assertAccountingPeriodMonthEqual((Set)periods.get(YEAR_2008), AccountingPeriodMonth.MONTH9, AccountingPeriodMonth.MONTH12);
    }

    @Test
    public void findAccountingPeriodsBetween_WithinSameYear_Month9_Month5_ThrowsIAE() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The begin period " + AccountingPeriodMonth.MONTH9 + " should be no later than the end period " + AccountingPeriodMonth.MONTH5);
        Map periods = AccountingPeriodMonth.findAccountingPeriodsBetween((Integer)YEAR_2008, (String)AccountingPeriodMonth.MONTH9.periodCode, (Integer)YEAR_2008, (String)AccountingPeriodMonth.MONTH5.periodCode);
        this.assertAccountingPeriodMonthEqual((Set)periods.get(YEAR_2008), AccountingPeriodMonth.MONTH9, AccountingPeriodMonth.MONTH5);
    }

    @Test
    public void findAccountingPeriodsBetween_AcrossMultipleYears_Month1_2008_Month12_2010() {
        this.assertAccountingPeriodsAcrossYears(YEAR_2008, AccountingPeriodMonth.MONTH1, YEAR_2010, AccountingPeriodMonth.MONTH12);
    }

    @Test
    public void findAccountingPeriodsBetween_AcrossMultipleYears_Month1_2008_Month4_2010() {
        this.assertAccountingPeriodsAcrossYears(YEAR_2008, AccountingPeriodMonth.MONTH1, YEAR_2010, AccountingPeriodMonth.MONTH4);
    }

    @Test
    public void findAccountingPeriodsBetween_AcrossMultipleYears_Month5_2008_Month12_2010() {
        this.assertAccountingPeriodsAcrossYears(YEAR_2008, AccountingPeriodMonth.MONTH5, YEAR_2010, AccountingPeriodMonth.MONTH12);
    }

    @Test
    public void findAccountingPeriodsBetween_AcrossMultipleYears_Month5_2008_Month4_2010() {
        this.assertAccountingPeriodsAcrossYears(YEAR_2008, AccountingPeriodMonth.MONTH5, YEAR_2010, AccountingPeriodMonth.MONTH4);
    }

    @Test
    public void findAccountingPeriodsBetween_AcrossMultipleYears_Month5_2010_Month4_2008_ThrowsIAE() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The begin year " + YEAR_2010 + " should be no later than the end year " + YEAR_2008);
        this.assertAccountingPeriodsAcrossYears(YEAR_2010, AccountingPeriodMonth.MONTH5, YEAR_2008, AccountingPeriodMonth.MONTH4);
    }

    @Test
    public void buildPeriodCodeSetWithinRange_Month1_Month12() {
        Set periodCodes = AccountingPeriodMonth.buildPeriodCodeSetWithinRange((AccountingPeriodMonth)AccountingPeriodMonth.MONTH1, (AccountingPeriodMonth)AccountingPeriodMonth.MONTH12);
        this.assertAccountingPeriodMonthEqual(periodCodes, AccountingPeriodMonth.MONTH1, AccountingPeriodMonth.MONTH12);
    }

    @Test
    public void buildPeriodCodeSetWithinRange_Month1_Month3() {
        Set periodCodes = AccountingPeriodMonth.buildPeriodCodeSetWithinRange((AccountingPeriodMonth)AccountingPeriodMonth.MONTH1, (AccountingPeriodMonth)AccountingPeriodMonth.MONTH3);
        this.assertAccountingPeriodMonthEqual(periodCodes, AccountingPeriodMonth.MONTH1, AccountingPeriodMonth.MONTH3);
    }

    @Test
    public void buildPeriodCodeSetWithinRange_Month4_Month8() {
        Set periodCodes = AccountingPeriodMonth.buildPeriodCodeSetWithinRange((AccountingPeriodMonth)AccountingPeriodMonth.MONTH4, (AccountingPeriodMonth)AccountingPeriodMonth.MONTH8);
        this.assertAccountingPeriodMonthEqual(periodCodes, AccountingPeriodMonth.MONTH4, AccountingPeriodMonth.MONTH8);
    }

    @Test
    public void buildPeriodCodeSetWithinRange_Month9_Month12() {
        Set periodCodes = AccountingPeriodMonth.buildPeriodCodeSetWithinRange((AccountingPeriodMonth)AccountingPeriodMonth.MONTH9, (AccountingPeriodMonth)AccountingPeriodMonth.MONTH12);
        this.assertAccountingPeriodMonthEqual(periodCodes, AccountingPeriodMonth.MONTH9, AccountingPeriodMonth.MONTH12);
    }

    @Test
    public void buildPeriodCodeSetWithinRange_Month9_Month5_ThrowsIAE() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The begin period " + AccountingPeriodMonth.MONTH9 + " should be no later than the end period " + AccountingPeriodMonth.MONTH5);
        Set periodCodes = AccountingPeriodMonth.buildPeriodCodeSetWithinRange((AccountingPeriodMonth)AccountingPeriodMonth.MONTH9, (AccountingPeriodMonth)AccountingPeriodMonth.MONTH5);
        this.assertAccountingPeriodMonthEqual(periodCodes, AccountingPeriodMonth.MONTH9, AccountingPeriodMonth.MONTH5);
    }

    private void assertAccountingPeriodsAcrossYears(Integer beginYear, AccountingPeriodMonth beginPeriod, Integer endYear, AccountingPeriodMonth endPeriod) {
        Map periods = AccountingPeriodMonth.findAccountingPeriodsBetween((Integer)beginYear, (String)beginPeriod.periodCode, (Integer)endYear, (String)endPeriod.periodCode);
        Set beginPeriodCodes = (Set)periods.get(beginYear);
        this.assertAccountingPeriodMonthEqual(beginPeriodCodes, beginPeriod, AccountingPeriodMonth.MONTH13);
        for (int year = beginYear + 1; year <= endYear - 1; ++year) {
            Set periodCodes = (Set)periods.get(year);
            this.assertAccountingPeriodMonthEqual(periodCodes, AccountingPeriodMonth.MONTH1, AccountingPeriodMonth.MONTH13);
        }
        Set endPeriodCodes = (Set)periods.get(endYear);
        this.assertAccountingPeriodMonthEqual(endPeriodCodes, AccountingPeriodMonth.MONTH1, endPeriod);
    }

    private void assertAccountingPeriodMonthEqual(Set<String> periodCodes, AccountingPeriodMonth beginPeriod, AccountingPeriodMonth endPeriod) {
        EnumSet<AccountingPeriodMonth> accountingPeriodMonth = EnumSet.range(beginPeriod, endPeriod);
        Assert.assertEquals((long)periodCodes.size(), (long)accountingPeriodMonth.size());
        for (String code : periodCodes) {
            AccountingPeriodMonth month = AccountingPeriodMonth.findAccountingPeriod((String)code);
            Assert.assertTrue((boolean)accountingPeriodMonth.contains(month));
        }
    }
}

