/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec.businessobject.service.impl;

import org.apache.commons.lang3.tuple.Pair;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.KFSPropertyConstants;
import org.kuali.kfs.sys.businessobject.service.impl.NoDbSortSearchService;
import org.kuali.rice.core.api.config.property.ConfigContext;

import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import java.util.Collection;
import java.util.stream.Collectors;

public class EffortCertificationSearchService extends NoDbSortSearchService {

    public Pair<Collection<? extends BusinessObjectBase>, Integer> getSearchResults(
            Class<? extends BusinessObjectBase> businessObjectClass, MultivaluedMap<String, String> fieldValues,
            int skip, int limit, String sortField, boolean sortAscending) {
        MultivaluedMap<String, String> potentiallyUpdatedFieldValues = new MultivaluedHashMap<>();
        potentiallyUpdatedFieldValues.putAll(fieldValues);

        if ("Y".equals(fieldValues.getFirst("outstanding"))) {
            potentiallyUpdatedFieldValues.add(KFSPropertyConstants.DOCUMENT_HEADER + "." +
                            KFSPropertyConstants.FINANCIAL_DOCUMENT_STATUS_CODE,
                    "!" + KFSConstants.DocumentStatusCodes.APPROVED);
        } else if ("N".equals(fieldValues.getFirst("outstanding"))) {
            potentiallyUpdatedFieldValues.add(KFSPropertyConstants.DOCUMENT_HEADER + "." +
                            KFSPropertyConstants.FINANCIAL_DOCUMENT_STATUS_CODE,
                    KFSConstants.DocumentStatusCodes.APPROVED);
        }

        Pair<Collection<? extends BusinessObjectBase>, Integer> fullSet = super.getSearchResults(businessObjectClass,
                potentiallyUpdatedFieldValues, skip, limit, sortField, sortAscending);
        // there's something weird about how the data is stored; if you add some criteria (like org) you start getting
        // duplicate results.
        Collection<? extends BusinessObjectBase> potentiallyDuplicateRows = fullSet.getLeft();
        Collection<? extends BusinessObjectBase> noDups = potentiallyDuplicateRows.stream().distinct().collect(
                Collectors.toList());

        return Pair.of(noDups, noDups.size());
    }

    @Override
    public String urlForProperty(BusinessObjectBase businessObject, String propertyName) {
        EffortCertificationDocument ecDoc = (EffortCertificationDocument) businessObject;
        String context = ConfigContext.getCurrentContextConfig().getProperty("app.context.name");
        String url = "/" + context + "/effortEffortCertification.do?methodToCall=docHandler&docId=";
        url = url + ecDoc.getDocumentNumber();
        url = url + "&command=displayDocSearchView&mode=standalone";
        return url;
    }
}
