/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.batch.service;

import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ec.batch.service.EffortCertificationCreateService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetailBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDocumentBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class EffortCertificationCreateServiceIntegTest
extends KualiIntegTestBase {
    private final Properties properties;
    private final Properties message;
    private final String detailFieldNames;
    private final String documentFieldNames;
    private final String reportDefinitionFieldNames;
    private final String documentHeaderFieldNames;
    private final String deliminator;
    private EffortCertificationCreateService cut;

    public EffortCertificationCreateServiceIntegTest() {
        String messageFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/effortCertificationCreateService.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.message = TestDataPreparator.loadPropertiesFromClassPath((String)messageFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.detailFieldNames = this.properties.getProperty("detailFieldNames");
        this.documentFieldNames = this.properties.getProperty("documentFieldNames");
        this.reportDefinitionFieldNames = this.properties.getProperty("reportDefinitionFieldNames");
        this.documentHeaderFieldNames = this.properties.getProperty("documentHeaderFieldNames");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.cut = (EffortCertificationCreateService)SpringContext.getBean(EffortCertificationCreateService.class);
    }

    public void testInputParameters_ValidParameters() throws Exception {
        String testTarget = "inputParameters.validParameters.";
        int fiscalYear = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocument.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition("");
        TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
        EffortCertificationDocumentBuild documentBuild = this.buildDocumentBuild(testTarget);
        TestDataPreparator.persistDataObject((PersistableBusinessObject)documentBuild);
        try {
            this.cut.create(Integer.valueOf(fiscalYear), reportNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
            EffortCertificationCreateServiceIntegTest.fail((String)(this.message.getProperty("error.validParameters") + " - Reported Errors: " + GlobalVariables.getMessageMap()));
        }
    }

    public void testInputParameters_EmptyFiscalYear() {
        String testTarget = "inputParameters.emptyFiscalYear.";
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        try {
            this.cut.create(null, reportNumber);
            EffortCertificationCreateServiceIntegTest.fail((String)this.message.getProperty("error.emptyFiscalYear"));
        }
        catch (IllegalArgumentException iae) {
            EffortCertificationCreateServiceIntegTest.assertEquals((String)"Fiscal Year is Required.", (String)iae.getMessage());
        }
    }

    public void testInputParameters_EmptyReportNumber() {
        String testTarget = "inputParameters.emptyReportNumber.";
        int fiscalYear = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        try {
            this.cut.create(Integer.valueOf(fiscalYear), reportNumber);
            EffortCertificationCreateServiceIntegTest.fail((String)this.message.getProperty("error.emptyReportNumber"));
        }
        catch (IllegalArgumentException iae) {
            EffortCertificationCreateServiceIntegTest.assertEquals((String)"Report Number is Required.", (String)iae.getMessage());
        }
    }

    public void testInputParameters_UndefinedReportDefinition() {
        String testTarget = "inputParameters.undefinedReportDefinition.";
        int fiscalYear = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        try {
            this.cut.create(Integer.valueOf(fiscalYear), reportNumber);
            EffortCertificationCreateServiceIntegTest.fail((String)this.message.getProperty("error.undefinedReportDefinition"));
        }
        catch (IllegalArgumentException iae) {
            EffortCertificationCreateServiceIntegTest.assertEquals((String)("The specified report number and fiscal year was not found in the report definition table.[" + fiscalYear + ", " + reportNumber + "]"), (String)iae.getMessage());
        }
    }

    public void testInputParameters_InactiveReportDefinition() {
        String testTarget = "inputParameters.inactiveReportDefinition.";
        int fiscalYear = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition(testTarget);
        TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
        try {
            this.cut.create(Integer.valueOf(fiscalYear), reportNumber);
            EffortCertificationCreateServiceIntegTest.fail((String)this.message.getProperty("error.inactiveReportDefinition"));
        }
        catch (IllegalArgumentException iae) {
            EffortCertificationCreateServiceIntegTest.assertEquals((String)("The report definition associated with the specified report number and fiscal year is inactive.[" + fiscalYear + ", " + reportNumber + "]"), (String)iae.getMessage());
        }
    }

    public void testInputParameters_NotOpenedReportDefinition() {
        String testTarget = "inputParameters.notOpenedReportDefinition.";
        int fiscalYear = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition(testTarget);
        TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
        try {
            this.cut.create(Integer.valueOf(fiscalYear), reportNumber);
            EffortCertificationCreateServiceIntegTest.fail((String)this.message.getProperty("error.notOpenedReportDefinition"));
        }
        catch (IllegalArgumentException iae) {
            EffortCertificationCreateServiceIntegTest.assertEquals((String)("The period of the specified report definition is not opened.[" + fiscalYear + ", " + reportNumber + "]"), (String)iae.getMessage());
        }
    }

    public void testInputParameters_ClosedReportDefinition() {
        String testTarget = "inputParameters.closedReportDefinition.";
        int fiscalYear = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition(testTarget);
        TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
        try {
            this.cut.create(Integer.valueOf(fiscalYear), reportNumber);
            EffortCertificationCreateServiceIntegTest.fail((String)this.message.getProperty("error.closedReportDefinition"));
        }
        catch (IllegalArgumentException iae) {
            EffortCertificationCreateServiceIntegTest.assertEquals((String)("The period of the specified report definition is not opened.[" + fiscalYear + ", " + reportNumber + "]"), (String)iae.getMessage());
        }
    }

    public void testInputParameters_DocumentBuildNotExist() throws Exception {
        String testTarget = "inputParameters.documentBuildNotExist.";
        int fiscalYear = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocument.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition("");
        TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
        try {
            this.cut.create(Integer.valueOf(fiscalYear), reportNumber);
            EffortCertificationCreateServiceIntegTest.fail((String)this.message.getProperty("error.documentBuildNotExist"));
        }
        catch (IllegalArgumentException iae) {
            EffortCertificationCreateServiceIntegTest.assertEquals((String)("Data for report number " + reportNumber + ", fiscal year " + fiscalYear + " not found in detail build table."), (String)iae.getMessage());
        }
    }

    public void testInputParameters_DocumentExist() throws Exception {
        String testTarget = "inputParameters.documentExist.";
        int fiscalYear = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocument.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition("");
        TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
        FinancialSystemDocumentHeader documentHeader = (FinancialSystemDocumentHeader)TestDataPreparator.buildTestDataObject(FinancialSystemDocumentHeader.class, (Properties)this.properties, (String)(testTarget + "documentHeader"), (String)this.documentHeaderFieldNames, (String)this.deliminator);
        documentHeader = (FinancialSystemDocumentHeader)TestDataPreparator.persistDataObject((PersistableBusinessObject)documentHeader);
        EffortCertificationDocument document = this.buildDocument(testTarget);
        document.setDocumentHeader((DocumentHeader)documentHeader);
        TestDataPreparator.persistDataObject((PersistableBusinessObject)document);
        try {
            this.cut.create(Integer.valueOf(fiscalYear), reportNumber);
            EffortCertificationCreateServiceIntegTest.fail((String)this.message.getProperty("error.documentExist"));
        }
        catch (IllegalArgumentException iae) {
            EffortCertificationCreateServiceIntegTest.assertEquals((String)("Data for report number " + reportNumber + ", fiscal year " + fiscalYear + " already exists in detail table."), (String)iae.getMessage());
        }
    }

    public void testCreate() throws Exception {
        String testTarget = "create.";
        int fiscalYear = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocument.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition("");
        TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
        EffortCertificationDocumentBuild documentBuild = this.buildDocumentBuild(testTarget);
        TestDataPreparator.persistDataObject((PersistableBusinessObject)documentBuild);
        try {
            this.cut.create(Integer.valueOf(fiscalYear), reportNumber);
        }
        catch (ValidationException e) {
            EffortCertificationCreateServiceIntegTest.fail((String)(e.getMessage() + ", " + GlobalVariables.getMessageMap()));
        }
        List documentList = TestDataPreparator.findMatching(EffortCertificationDocument.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDocuments = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        List expectedDocuments = TestDataPreparator.buildExpectedValueList(EffortCertificationDocument.class, (Properties)this.properties, (String)(testTarget + "expectedDocument"), (String)this.documentFieldNames, (String)this.deliminator, (int)numberOfExpectedDocuments);
        EffortCertificationCreateServiceIntegTest.assertEquals((int)numberOfExpectedDocuments, (int)documentList.size());
        List documentKeyFields = ObjectUtil.split((String)this.documentFieldNames, (String)this.deliminator);
        documentKeyFields.remove("documentNumber");
        EffortCertificationCreateServiceIntegTest.assertTrue((boolean)TestDataPreparator.hasSameElements((List)expectedDocuments, (List)documentList, (List)documentKeyFields));
    }

    public void testRoute() throws Exception {
        String testTarget = "route.";
        int fiscalYear = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "fiscalYear")));
        String reportNumber = this.properties.getProperty(testTarget + "reportNumber");
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocument.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition("");
        TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
        EffortCertificationDocumentBuild documentBuild = this.buildDocumentBuild(testTarget);
        TestDataPreparator.persistDataObject((PersistableBusinessObject)documentBuild);
        try {
            this.cut.create(Integer.valueOf(fiscalYear), reportNumber);
        }
        catch (ValidationException e) {
            EffortCertificationCreateServiceIntegTest.fail((String)(e.getMessage() + ", " + GlobalVariables.getMessageMap()));
        }
        List documentList = TestDataPreparator.findMatching(EffortCertificationDocument.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        for (EffortCertificationDocument document : documentList) {
            EffortCertificationCreateServiceIntegTest.assertEquals((String)document.getFinancialSystemDocumentHeader().getFinancialDocumentStatusCode(), (String)"R");
        }
    }

    private EffortCertificationReportDefinition buildReportDefinition(String testTarget) {
        return (EffortCertificationReportDefinition)TestDataPreparator.buildTestDataObject(EffortCertificationReportDefinition.class, (Properties)this.properties, (String)(testTarget + "reportDefinitionFieldValues"), (String)this.reportDefinitionFieldNames, (String)this.deliminator);
    }

    private EffortCertificationDocument buildDocument(String testTarget) {
        return (EffortCertificationDocument)TestDataPreparator.buildTestDataObject(EffortCertificationDocument.class, (Properties)this.properties, (String)(testTarget + "document"), (String)this.documentFieldNames, (String)this.deliminator);
    }

    private EffortCertificationDocumentBuild buildDocumentBuild(String testTarget) {
        EffortCertificationDocumentBuild documentBuild = (EffortCertificationDocumentBuild)TestDataPreparator.buildTestDataObject(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "documentBuild"), (String)this.documentFieldNames, (String)this.deliminator);
        List<EffortCertificationDetailBuild> detailBuild = this.buildDetailLineBuild(testTarget);
        documentBuild.setEffortCertificationDetailLinesBuild(detailBuild);
        return documentBuild;
    }

    private List<EffortCertificationDetailBuild> buildDetailLineBuild(String testTarget) {
        int numberOfDetailBuild = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfDetailBuilds")));
        return TestDataPreparator.buildTestDataList(EffortCertificationDetailBuild.class, (Properties)this.properties, (String)(testTarget + "detailBuild"), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfDetailBuild);
    }
}

