/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document;

import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class EffortCertificationDocumentTest {
    private Properties properties;
    private String detailFieldNames;
    private String documentFieldNames;
    private String deliminator;

    @Before
    public void setUp() {
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/effortCertificationDocument.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.detailFieldNames = this.properties.getProperty("detailFieldNames");
        this.documentFieldNames = this.properties.getProperty("documentFieldNames");
    }

    @Test
    public void testGetEffortCertificationDetailWithMaxPayrollAmount_MultipleResults() {
        String testTarget = "getEffortCertificationDetailWithMaxPayrollAmount.multipleResults.";
        EffortCertificationDocument document = this.buildDocument(testTarget);
        List detailLineWithMaxPayrollAmount = document.getEffortCertificationDetailWithMaxPayrollAmount();
        int numberOfExpectedDetail = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfExpectedDetail")));
        Assert.assertEquals((long)numberOfExpectedDetail, (long)detailLineWithMaxPayrollAmount.size());
    }

    @Test
    public void testGetEffortCertificationDetailWithMaxPayrollAmount_SingleResult() {
        String testTarget = "getEffortCertificationDetailWithMaxPayrollAmount.singleResult.";
        EffortCertificationDocument document = this.buildDocument(testTarget);
        List detailLineWithMaxPayrollAmount = document.getEffortCertificationDetailWithMaxPayrollAmount();
        int numberOfExpectedDetail = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfExpectedDetail")));
        Assert.assertEquals((long)numberOfExpectedDetail, (long)detailLineWithMaxPayrollAmount.size());
    }

    private EffortCertificationDocument buildDocument(String testTarget) {
        EffortCertificationDocument document;
        try (MockedStatic kradServiceLocatorWebStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            DocumentHeaderService documentHeaderServiceMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
            Class<FinancialSystemDocumentHeader> documentHeaderBaseClass = FinancialSystemDocumentHeader.class;
            Mockito.when((Object)documentHeaderServiceMock.getDocumentHeaderBaseClass()).thenReturn(documentHeaderBaseClass);
            kradServiceLocatorWebStaticMock.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            document = (EffortCertificationDocument)TestDataPreparator.buildTestDataObject(EffortCertificationDocument.class, (Properties)this.properties, (String)(testTarget + "document"), (String)this.documentFieldNames, (String)this.deliminator);
        }
        List<EffortCertificationDetail> detailLines = this.buildDetailLine(testTarget);
        document.setEffortCertificationDetailLines(detailLines);
        return document;
    }

    private List<EffortCertificationDetail> buildDetailLine(String testTarget) {
        List effortCertificationDetails;
        int numberOfDetail = Integer.parseInt(this.properties.getProperty(testTarget + "numOfDetail"));
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            effortCertificationDetails = TestDataPreparator.buildTestDataList(EffortCertificationDetail.class, (Properties)this.properties, (String)(testTarget + "detail"), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfDetail);
        }
        return effortCertificationDetails;
    }
}

