/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.DocumentTestUtils;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.UniversityDateService;

@ConfigureContext(session=UserNameFixture.khuntley)
public class EffortCertificationRoutingIntegTest
extends KualiIntegTestBase {
    private Set<String> databaseNodes;

    private Document getDocumentParameterFixture() throws Exception {
        return DocumentTestUtils.createDocument((DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)), EffortCertificationDocument.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        super.setUp();
        String documentType = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(EffortCertificationDocument.class);
        DataSource mySource = (DataSource)SpringContext.getBean(DataSource.class);
        Connection dbCon = null;
        ResultSet dbAnswer = null;
        this.databaseNodes = new HashSet<String>();
        try {
            dbCon = mySource.getConnection();
            Statement dbAsk = dbCon.createStatement();
            String query = "select nd.nm from KREW_RTE_NODE_T nd, KREW_DOC_TYP_T doc where nd.rte_mthd_nm is not null and doc.doc_typ_id = nd.doc_typ_id and doc.doc_typ_nm = '" + documentType + "' and doc.cur_ind = 1 and exists (select * from KREW_RTE_NODE_LNK_T where to_rte_node_id=nd.rte_node_id) ";
            dbAnswer = dbAsk.executeQuery(query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                dbCon.close();
            }
            catch (SQLException sqle2) {
                sqle2.printStackTrace();
            }
        }
        while (dbAnswer.next()) {
            this.databaseNodes.add(dbAnswer.getString(1));
        }
    }

    private EffortCertificationDocument buildDocument() throws Exception {
        EffortCertificationDocument document = (EffortCertificationDocument)this.getDocumentParameterFixture();
        document.setEmplid("0000000060");
        document.setEffortCertificationReportNumber("A03");
        document.setUniversityFiscalYear(Integer.valueOf(2009));
        document.setEffortCertificationDocumentCode(true);
        ArrayList<EffortCertificationDetail> effortCertificationDetailLines = new ArrayList<EffortCertificationDetail>();
        EffortCertificationDetail testDetailLine = new EffortCertificationDetail();
        testDetailLine.setAccountNumber("4831401");
        testDetailLine.setChartOfAccountsCode("BL");
        testDetailLine.setEffortCertificationCalculatedOverallPercent(Integer.valueOf(40));
        testDetailLine.setEffortCertificationUpdatedOverallPercent(Integer.valueOf(50));
        testDetailLine.setPositionNumber("1");
        testDetailLine.setFinancialObjectCode("4000");
        testDetailLine.setSourceChartOfAccountsCode("BL");
        testDetailLine.setSourceAccountNumber("4831401");
        Integer testDate = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear();
        testDetailLine.setUniversityFiscalYear(testDate);
        testDetailLine.setEffortCertificationOriginalPayrollAmount(new KualiDecimal(100.0));
        Note testNote = new Note();
        testNote.setNoteText("This is a nice note.");
        testNote.setAuthorUniversalIdentifier(document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        ((NoteService)SpringContext.getBean(NoteService.class)).createNote(testNote, (PersistableBusinessObject)document.getDocumentHeader(), document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId());
        effortCertificationDetailLines.add(testDetailLine);
        testDetailLine = new EffortCertificationDetail();
        testDetailLine.setAccountNumber("4631483");
        testDetailLine.setChartOfAccountsCode("BL");
        testDetailLine.setEffortCertificationCalculatedOverallPercent(Integer.valueOf(60));
        testDetailLine.setEffortCertificationUpdatedOverallPercent(Integer.valueOf(50));
        testDetailLine.setPositionNumber("1");
        testDetailLine.setFinancialObjectCode("4000");
        testDetailLine.setSourceChartOfAccountsCode("BL");
        testDetailLine.setSourceAccountNumber("4631483");
        testDetailLine.setUniversityFiscalYear(testDate);
        testDetailLine.setEffortCertificationOriginalPayrollAmount(new KualiDecimal(100.0));
        effortCertificationDetailLines.add(testDetailLine);
        document.setEffortCertificationDetailLines(effortCertificationDetailLines);
        document.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(new KualiDecimal(200.0));
        ((DocumentService)SpringContext.getBean(DocumentService.class)).saveDocument((Document)document);
        return (EffortCertificationDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(document.getDocumentNumber());
    }

    public final void testRouting() throws Exception {
        EffortCertificationDocument document = this.buildDocument();
        System.out.println("EffortCertificationDocument doc# " + document.getDocumentNumber());
        WorkflowDocument testDoc = document.getDocumentHeader().getWorkflowDocument();
        testDoc.blanketApprove("Approved by unit test");
        EffortCertificationRoutingIntegTest.assertTrue((String)"Document didn't route!", (testDoc.isProcessed() || testDoc.isFinal() ? 1 : 0) != 0);
        System.out.println("Document Routed");
    }
}

