/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.service;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.module.ec.EffortCertificationTestConstants;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.dataaccess.EffortCertificationReportDefinitionDao;
import org.kuali.kfs.module.ec.dataaccess.impl.EffortCertificationReportDefinitionDaoOjb;
import org.kuali.kfs.module.ec.document.service.EffortCertificationAutomaticReportPeriodUpdateService;
import org.kuali.kfs.module.ec.fixture.EffortCertificationReportDefinitionFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@ConfigureContext
public class EffortCertificationAutomaticReportPeriodUpdateServiceIntegTest
extends KualiIntegTestBase {
    private EffortCertificationAutomaticReportPeriodUpdateService reportDefinitionService;
    @Mock
    private EffortCertificationReportDefinitionDaoOjb mockDao;
    private List<EffortCertificationReportDefinition> testReportDefinitions;

    public void setUp() throws Exception {
        super.setUp();
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.reportDefinitionService = (EffortCertificationAutomaticReportPeriodUpdateService)SpringContext.getBean(EffortCertificationAutomaticReportPeriodUpdateService.class);
        this.reportDefinitionService.setEffortCertificationReportDefinitionDao((EffortCertificationReportDefinitionDao)this.mockDao);
    }

    public void testIsAnOverlappingReportDefinition_overlappingPeriods1() {
        EffortCertificationReportDefinition control = EffortCertificationReportDefinitionFixture.CONTROL_1.createEffortCertificationReportDefinition();
        EffortCertificationReportDefinition test = EffortCertificationReportDefinitionFixture.TEST_1_OVERLAP.createEffortCertificationReportDefinition();
        control.setUniversityFiscalYear(EffortCertificationTestConstants.EffortCertificationUniversityFiscalYear.YEAR_1999.getUniversityFiscalYear());
        this.testReportDefinitions = new ArrayList<EffortCertificationReportDefinition>();
        this.testReportDefinitions.add(control);
        Mockito.when((Object)this.mockDao.getAll()).thenReturn(this.testReportDefinitions);
        Mockito.when((Object)this.mockDao.getAllOtherActiveByType((EffortCertificationReportDefinition)ArgumentMatchers.any())).thenReturn(this.testReportDefinitions);
        EffortCertificationAutomaticReportPeriodUpdateServiceIntegTest.assertTrue((String)"report definition 'test' is expected to overlap with report definition 'control'", (boolean)this.reportDefinitionService.isAnOverlappingReportDefinition(test));
    }

    public void testIsAnOverlappingReportDefinition_overlappingPeriods2() {
        EffortCertificationReportDefinition control = EffortCertificationReportDefinitionFixture.CONTROL_3.createEffortCertificationReportDefinition();
        EffortCertificationReportDefinition test = EffortCertificationReportDefinitionFixture.TEST_3_NO_OVERLAP.createEffortCertificationReportDefinition();
        control.setUniversityFiscalYear(EffortCertificationTestConstants.EffortCertificationUniversityFiscalYear.YEAR_1999.getUniversityFiscalYear());
        this.testReportDefinitions = new ArrayList<EffortCertificationReportDefinition>();
        this.testReportDefinitions.add(control);
        Mockito.when((Object)this.mockDao.getAll()).thenReturn(this.testReportDefinitions);
        EffortCertificationAutomaticReportPeriodUpdateServiceIntegTest.assertFalse((String)"report definition 'test' is not expected to overlap with report definition 'control'", (boolean)this.reportDefinitionService.isAnOverlappingReportDefinition(test));
    }

    public void testIsAnOverlappingReportDefinition_noOverlappingDates() {
        EffortCertificationReportDefinition control = EffortCertificationReportDefinitionFixture.CONTROL_2.createEffortCertificationReportDefinition();
        EffortCertificationReportDefinition test = EffortCertificationReportDefinitionFixture.TEST_2_NO_OVERLAP.createEffortCertificationReportDefinition();
        control.setUniversityFiscalYear(EffortCertificationTestConstants.EffortCertificationUniversityFiscalYear.YEAR_1999.getUniversityFiscalYear());
        this.testReportDefinitions = new ArrayList<EffortCertificationReportDefinition>();
        this.testReportDefinitions.add(control);
        Mockito.when((Object)this.mockDao.getAll()).thenReturn(this.testReportDefinitions);
        EffortCertificationAutomaticReportPeriodUpdateServiceIntegTest.assertFalse((String)"report definition 'test' is not expected to overlap with report definition 'control'", (boolean)this.reportDefinitionService.isAnOverlappingReportDefinition(test));
    }

    public void testIsAnOverlappingReportDefinition_boundry1() {
        EffortCertificationReportDefinition control = EffortCertificationReportDefinitionFixture.CONTROL_4.createEffortCertificationReportDefinition();
        EffortCertificationReportDefinition test = EffortCertificationReportDefinitionFixture.TEST_4_NO_OVERLAP.createEffortCertificationReportDefinition();
        control.setUniversityFiscalYear(EffortCertificationTestConstants.EffortCertificationUniversityFiscalYear.YEAR_1999.getUniversityFiscalYear());
        this.testReportDefinitions = new ArrayList<EffortCertificationReportDefinition>();
        this.testReportDefinitions.add(control);
        Mockito.when((Object)this.mockDao.getAll()).thenReturn(this.testReportDefinitions);
        EffortCertificationAutomaticReportPeriodUpdateServiceIntegTest.assertFalse((String)"report definition 'test' is not expected to overlap with report definition 'control'", (boolean)this.reportDefinitionService.isAnOverlappingReportDefinition(test));
    }

    public void testIsAnOverlappingReportDefinition_boundry2() {
        EffortCertificationReportDefinition control = EffortCertificationReportDefinitionFixture.CONTROL_5.createEffortCertificationReportDefinition();
        EffortCertificationReportDefinition test = EffortCertificationReportDefinitionFixture.TEST_5_NO_OVERLAP.createEffortCertificationReportDefinition();
        control.setUniversityFiscalYear(EffortCertificationTestConstants.EffortCertificationUniversityFiscalYear.YEAR_1999.getUniversityFiscalYear());
        this.testReportDefinitions = new ArrayList<EffortCertificationReportDefinition>();
        this.testReportDefinitions.add(control);
        Mockito.when((Object)this.mockDao.getAll()).thenReturn(this.testReportDefinitions);
        EffortCertificationAutomaticReportPeriodUpdateServiceIntegTest.assertFalse((String)"report definition 'test' is not expected to overlap with report definition 'control'", (boolean)this.reportDefinitionService.isAnOverlappingReportDefinition(test));
    }

    public void testIsAnOverlappingReportDefinition_boundry3() {
        EffortCertificationReportDefinition control = EffortCertificationReportDefinitionFixture.CONTROL_6.createEffortCertificationReportDefinition();
        EffortCertificationReportDefinition test = EffortCertificationReportDefinitionFixture.TEST_6_NO_OVERLAP.createEffortCertificationReportDefinition();
        control.setUniversityFiscalYear(EffortCertificationTestConstants.EffortCertificationUniversityFiscalYear.YEAR_1999.getUniversityFiscalYear());
        this.testReportDefinitions = new ArrayList<EffortCertificationReportDefinition>();
        this.testReportDefinitions.add(control);
        Mockito.when((Object)this.mockDao.getAll()).thenReturn(this.testReportDefinitions);
        EffortCertificationAutomaticReportPeriodUpdateServiceIntegTest.assertFalse((String)"report definition 'test' is not expected to overlap with report definition 'control'", (boolean)this.reportDefinitionService.isAnOverlappingReportDefinition(test));
    }

    public void testIsAnOverlappingReportDefinition_overlappingDates1() {
        EffortCertificationReportDefinition control = EffortCertificationReportDefinitionFixture.CONTROL_7.createEffortCertificationReportDefinition();
        EffortCertificationReportDefinition test = EffortCertificationReportDefinitionFixture.TEST_7_OVERLAP.createEffortCertificationReportDefinition();
        control.setUniversityFiscalYear(EffortCertificationTestConstants.EffortCertificationUniversityFiscalYear.YEAR_1999.getUniversityFiscalYear());
        this.testReportDefinitions = new ArrayList<EffortCertificationReportDefinition>();
        this.testReportDefinitions.add(control);
        Mockito.when((Object)this.mockDao.getAll()).thenReturn(this.testReportDefinitions);
        Mockito.when((Object)this.mockDao.getAllOtherActiveByType((EffortCertificationReportDefinition)ArgumentMatchers.any())).thenReturn(this.testReportDefinitions);
        EffortCertificationAutomaticReportPeriodUpdateServiceIntegTest.assertTrue((String)"report definition 'test' is expected to overlap with report definition 'control'", (boolean)this.reportDefinitionService.isAnOverlappingReportDefinition(test));
    }

    public void testIsAnOverlappingReportDefinition_dateBoundry() {
        EffortCertificationReportDefinition control = EffortCertificationReportDefinitionFixture.CONTROL_8.createEffortCertificationReportDefinition();
        EffortCertificationReportDefinition test = EffortCertificationReportDefinitionFixture.TEST_8_NO_OVERLAP.createEffortCertificationReportDefinition();
        control.setUniversityFiscalYear(EffortCertificationTestConstants.EffortCertificationUniversityFiscalYear.YEAR_1999.getUniversityFiscalYear());
        this.testReportDefinitions = new ArrayList<EffortCertificationReportDefinition>();
        this.testReportDefinitions.add(control);
        Mockito.when((Object)this.mockDao.getAll()).thenReturn(this.testReportDefinitions);
        EffortCertificationAutomaticReportPeriodUpdateServiceIntegTest.assertFalse((String)"report definition 'test' is not expected to overlap with report definition 'control'", (boolean)this.reportDefinitionService.isAnOverlappingReportDefinition(test));
    }

    public void testIsAnOverlappingReportDefinition_multipleRecords() {
        EffortCertificationReportDefinition control1 = EffortCertificationReportDefinitionFixture.CONTROL_9_1.createEffortCertificationReportDefinition();
        EffortCertificationReportDefinition control2 = EffortCertificationReportDefinitionFixture.CONTROL_9_2.createEffortCertificationReportDefinition();
        EffortCertificationReportDefinition control3 = EffortCertificationReportDefinitionFixture.CONTROL_9_3.createEffortCertificationReportDefinition();
        EffortCertificationReportDefinition test = EffortCertificationReportDefinitionFixture.TEST_9_OVERLAP.createEffortCertificationReportDefinition();
        this.testReportDefinitions = new ArrayList<EffortCertificationReportDefinition>();
        control1.setUniversityFiscalYear(EffortCertificationTestConstants.EffortCertificationUniversityFiscalYear.YEAR_1999.getUniversityFiscalYear());
        this.testReportDefinitions.add(control1);
        control2.setUniversityFiscalYear(EffortCertificationTestConstants.EffortCertificationUniversityFiscalYear.YEAR_2000.getUniversityFiscalYear());
        this.testReportDefinitions.add(control2);
        control3.setUniversityFiscalYear(EffortCertificationTestConstants.EffortCertificationUniversityFiscalYear.YEAR_2001.getUniversityFiscalYear());
        this.testReportDefinitions.add(control3);
        Mockito.when((Object)this.mockDao.getAll()).thenReturn(this.testReportDefinitions);
        Mockito.when((Object)this.mockDao.getAllOtherActiveByType((EffortCertificationReportDefinition)ArgumentMatchers.any())).thenReturn(this.testReportDefinitions);
        EffortCertificationAutomaticReportPeriodUpdateServiceIntegTest.assertTrue((String)"report definition 'test' is expected to be an overlapping record", (boolean)this.reportDefinitionService.isAnOverlappingReportDefinition(test));
    }
}

