/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.service;

import java.util.List;
import java.util.Properties;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetailBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDocumentBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.service.EffortCertificationDocumentBuildService;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class EffortCertificationDocumentBuildServiceIntegTest
extends KualiIntegTestBase {
    private Properties properties;
    private Properties message;
    private String balanceFieldNames;
    private String detailFieldNames;
    private String documentFieldNames;
    private String deliminator;
    Integer postingYear;
    private EffortCertificationReportDefinition reportDefinition;
    private BusinessObjectService businessObjectService;
    private PersistenceService persistenceService;
    private EffortCertificationDocumentBuildService effortCertificationDocumentBuildService;
    private Class<? extends LaborLedgerBalance> ledgerBalanceClass;

    public EffortCertificationDocumentBuildServiceIntegTest() {
        String messageFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/effortCertificationDocumentBuildService.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.message = TestDataPreparator.loadPropertiesFromClassPath((String)messageFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.balanceFieldNames = this.properties.getProperty("balanceFieldNames");
        this.detailFieldNames = this.properties.getProperty("detailFieldNames");
        this.documentFieldNames = this.properties.getProperty("documentFieldNames");
        this.postingYear = Integer.valueOf(this.properties.getProperty("postingYear"));
    }

    public void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.persistenceService = (PersistenceService)SpringContext.getBean(PersistenceService.class);
        this.effortCertificationDocumentBuildService = (EffortCertificationDocumentBuildService)SpringContext.getBean(EffortCertificationDocumentBuildService.class);
        this.ledgerBalanceClass = LedgerBalance.class;
        TestDataPreparator.doCleanUpWithoutReference(this.ledgerBalanceClass, (Properties)this.properties, (String)"dataCleanup", (String)this.balanceFieldNames, (String)this.deliminator);
    }

    public void testGenerateDocumentBuild() {
        String testTarget = "generateDocumentBuild.";
        this.reportDefinition = this.buildReportDefinition();
        this.assertDocumentEquals(testTarget, false);
    }

    public void testGenerateDocumentBuildList() {
        String testTarget = "generateDocumentBuildList.";
        this.reportDefinition = this.buildReportDefinition();
        this.assertDocumentListEquals(testTarget);
    }

    public void testGenerateDocumentBuild_SaveIntoDatabase() {
        String testTarget = "generateDocumentBuild.saveIntoDatabase.";
        this.reportDefinition = this.buildReportDefinition();
        EffortCertificationReportDefinition existingReportDefinition = (EffortCertificationReportDefinition)this.businessObjectService.retrieve((PersistableBusinessObject)this.reportDefinition);
        if (existingReportDefinition == null) {
            this.businessObjectService.save((PersistableBusinessObject)this.reportDefinition);
        }
        this.assertDocumentEquals(testTarget, true);
    }

    public void testGenerateDocumentBuild_PercentageCalculation() {
        String testTarget = "generateDocumentBuild.percentageCalculation.";
        this.reportDefinition = this.buildReportDefinition();
        this.assertDocumentEquals(testTarget, false);
    }

    public void testGenerateDocumentBuild_NonCostShareSubAccountConsolidation() {
        String testTarget = "generateDocumentBuild.nonCostShareSubAccountConsolidation.";
        this.reportDefinition = this.buildReportDefinition();
        this.assertDocumentEquals(testTarget, false);
    }

    private void assertDocumentEquals(String testTarget, boolean savedIntoDatabase) {
        List documentKeyFields = ObjectUtil.split((String)this.documentFieldNames, (String)this.deliminator);
        List detailKeyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        EffortCertificationDocumentBuild documentBuild = this.effortCertificationDocumentBuildService.generateDocumentBuild(this.postingYear, this.reportDefinition, ledgerBalances);
        if (savedIntoDatabase) {
            this.businessObjectService.save((PersistableBusinessObject)documentBuild);
            this.persistenceService.retrieveNonKeyFields((Object)documentBuild);
        }
        List detailBuild = documentBuild.getEffortCertificationDetailLinesBuild();
        EffortCertificationDocumentBuild expectedDocumentBuild = (EffortCertificationDocumentBuild)TestDataPreparator.buildTestDataObject(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "expectedDocument"), (String)this.documentFieldNames, (String)this.deliminator);
        int numberOfExpectedDetails = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDetails"));
        List expectedDetailsBuild = TestDataPreparator.buildTestDataList(EffortCertificationDetailBuild.class, (Properties)this.properties, (String)(testTarget + "expectedDetail"), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfExpectedDetails);
        String errorMessage = this.message.getProperty("error.documentBuildService.unexpectedDocumentGenerated");
        EffortCertificationDocumentBuildServiceIntegTest.assertTrue((String)errorMessage, (boolean)ObjectUtil.equals((Object)documentBuild, (Object)expectedDocumentBuild, (List)documentKeyFields));
        EffortCertificationDocumentBuildServiceIntegTest.assertEquals((String)errorMessage, (int)expectedDetailsBuild.size(), (int)detailBuild.size());
        for (int i = 0; i < numberOfExpectedDetails; ++i) {
            EffortCertificationDetailBuild expected = (EffortCertificationDetailBuild)expectedDetailsBuild.get(i);
            EffortCertificationDetailBuild actual = (EffortCertificationDetailBuild)detailBuild.get(i);
            EffortCertificationDocumentBuildServiceIntegTest.assertTrue((String)errorMessage, (boolean)ObjectUtil.equals((Object)actual, (Object)expected, (List)detailKeyFields));
        }
    }

    private void assertDocumentListEquals(String testTarget) {
        List documentKeyFields = ObjectUtil.split((String)this.documentFieldNames, (String)this.deliminator);
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances(testTarget);
        List documentBuildList = this.effortCertificationDocumentBuildService.generateDocumentBuildList(this.postingYear, this.reportDefinition, ledgerBalances);
        int numberOfExpectedDocuments = Integer.parseInt(this.properties.getProperty(testTarget + "numOfExpectedDocuments"));
        List expectedDocumentBuildList = TestDataPreparator.buildExpectedValueList(EffortCertificationDocumentBuild.class, (Properties)this.properties, (String)(testTarget + "expectedDocument"), (String)this.documentFieldNames, (String)this.deliminator, (int)numberOfExpectedDocuments);
        String errorMessage = this.message.getProperty("error.documentBuildService.unexpectedDocumentGenerated");
        EffortCertificationDocumentBuildServiceIntegTest.assertEquals((String)errorMessage, (int)expectedDocumentBuildList.size(), (int)documentBuildList.size());
        for (int j = 0; j < numberOfExpectedDocuments; ++j) {
            EffortCertificationDocumentBuild expected = (EffortCertificationDocumentBuild)expectedDocumentBuildList.get(j);
            boolean contain = false;
            for (int i = 0; i < numberOfExpectedDocuments - j; ++i) {
                EffortCertificationDocumentBuild actual = (EffortCertificationDocumentBuild)documentBuildList.get(i);
                contain = ObjectUtil.equals((Object)actual, (Object)expected, (List)documentKeyFields);
                if (!contain) continue;
                documentBuildList.remove(i);
                break;
            }
            if (contain) continue;
            EffortCertificationDocumentBuildServiceIntegTest.fail((String)errorMessage);
        }
    }

    private List<LaborLedgerBalance> buildLedgerBalances(String testTarget) {
        int numberOfTestData = Integer.parseInt(this.properties.getProperty(testTarget + "numOfData"));
        List ledgerBalances = TestDataPreparator.buildTestDataList(this.ledgerBalanceClass, (Properties)this.properties, (String)(testTarget + "inputBalance"), (String)this.balanceFieldNames, (String)this.deliminator, (int)numberOfTestData);
        this.businessObjectService.save(ledgerBalances);
        for (LaborLedgerBalance balance : ledgerBalances) {
            this.persistenceService.retrieveNonKeyFields((Object)balance);
        }
        return ledgerBalances;
    }

    private EffortCertificationReportDefinition buildReportDefinition() {
        EffortCertificationReportDefinition reportDefinition = new EffortCertificationReportDefinition();
        String reprtDefinitionFieldNames = this.properties.getProperty("reportDefinitionFieldNames");
        ObjectUtil.populateBusinessObject((Object)reportDefinition, (Properties)this.properties, (String)"reportDefinitionFieldValues", (String)reprtDefinitionFieldNames, (String)this.deliminator);
        return reportDefinition;
    }
}

