/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.module.ec.util.DetailLineGroup;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class DetailLineGroupTest {
    private Properties properties;
    private String detailFieldNames;
    private String deliminator;

    DetailLineGroupTest() {
    }

    @BeforeEach
    void setUp() {
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/detailLineGroup.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.detailFieldNames = this.properties.getProperty("detailFieldNames");
    }

    @Test
    void detailLineGroupConstructor_WithOneParameter() {
        EffortCertificationDetail expectedDelegateLine;
        EffortCertificationDetail expectedSummaryLine;
        DetailLineGroup detailLineGroupMap;
        String testTarget = "constructor.withOneParameter.";
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            EffortCertificationDetail detailLine = this.buildDetailLine(testTarget, "detail");
            detailLineGroupMap = new DetailLineGroup(detailLine);
            expectedSummaryLine = this.buildDetailLine(testTarget, "expectedSummaryLine");
            expectedDelegateLine = this.buildDetailLine(testTarget, "expectedDelegateLine");
        }
        List keyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        Assertions.assertTrue((boolean)ObjectUtil.equals((Object)expectedSummaryLine, (Object)detailLineGroupMap.getSummaryDetailLine(), (List)keyFields));
        Assertions.assertTrue((boolean)ObjectUtil.equals((Object)expectedDelegateLine, (Object)detailLineGroupMap.getDelegateDetailLine(), (List)keyFields));
    }

    @Test
    void updateDelegateDetailLineEffort() {
        EffortCertificationDetail expectedDelegateLine;
        EffortCertificationDetail expectedSummaryLine;
        DetailLineGroup detailLineGroupMap;
        String testTarget = "updateDelegateDetailLineEffort.";
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            EffortCertificationDetail detailLine = this.buildDetailLine(testTarget, "detail");
            detailLineGroupMap = new DetailLineGroup(detailLine);
            String newEffortAsString = StringUtils.trim((String)this.properties.getProperty(testTarget + "newEffortPercent"));
            Integer newEffort = Integer.parseInt(newEffortAsString);
            detailLineGroupMap.getSummaryDetailLine().setEffortCertificationUpdatedOverallPercent(newEffort);
            detailLineGroupMap.updateDelegateDetailLineEffort();
            expectedSummaryLine = this.buildDetailLine(testTarget, "expectedSummaryLine");
            expectedDelegateLine = this.buildDetailLine(testTarget, "expectedDelegateLine");
        }
        List keyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        Assertions.assertTrue((boolean)ObjectUtil.equals((Object)expectedSummaryLine, (Object)detailLineGroupMap.getSummaryDetailLine(), (List)keyFields));
        Assertions.assertTrue((boolean)ObjectUtil.equals((Object)expectedDelegateLine, (Object)detailLineGroupMap.getDelegateDetailLine(), (List)keyFields));
    }

    @Test
    void groupDetailLines_SingleGroup() {
        EffortCertificationDetail expectedDelegateLine;
        EffortCertificationDetail expectedSummaryLine;
        Map detailLineGroupMap;
        String testTarget = "groupDetailLines.singleGroup.";
        int numberOfDetails = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfDetails")));
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            List<EffortCertificationDetail> detailLines = this.buildDetailLines(testTarget, "detail", numberOfDetails);
            detailLineGroupMap = DetailLineGroup.groupDetailLines(detailLines);
            int numOfExpectedGroups = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfExpectedGroups")));
            Assertions.assertEquals((int)numOfExpectedGroups, (int)detailLineGroupMap.size());
            expectedSummaryLine = this.buildDetailLine(testTarget, "expectedSummaryLine");
            expectedDelegateLine = this.buildDetailLine(testTarget, "expectedDelegateLine");
        }
        EffortCertificationDetail summaryLine = null;
        EffortCertificationDetail delegateLine = null;
        for (String key : detailLineGroupMap.keySet()) {
            summaryLine = ((DetailLineGroup)detailLineGroupMap.get(key)).getSummaryDetailLine();
            delegateLine = ((DetailLineGroup)detailLineGroupMap.get(key)).getDelegateDetailLine();
        }
        List keyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        Assertions.assertTrue((boolean)ObjectUtil.equals((Object)expectedSummaryLine, (Object)summaryLine, (List)keyFields));
        Assertions.assertTrue((boolean)ObjectUtil.equals((Object)expectedDelegateLine, delegateLine, (List)keyFields));
    }

    @Test
    void groupDetailLines_MultipleGroups() {
        List<EffortCertificationDetail> expectedDelegateLines;
        List<EffortCertificationDetail> expectedSummaryLines;
        Map detailLineGroupMap;
        String testTarget = "groupDetailLines.multipleGroups.";
        int numberOfDetails = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfDetails")));
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            List<EffortCertificationDetail> detailLines = this.buildDetailLines(testTarget, "detail", numberOfDetails);
            detailLineGroupMap = DetailLineGroup.groupDetailLines(detailLines);
            int numOfExpectedGroups = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfExpectedGroups")));
            Assertions.assertEquals((int)numOfExpectedGroups, (int)detailLineGroupMap.size());
            expectedSummaryLines = this.buildDetailLines(testTarget, "expectedSummaryLine", numOfExpectedGroups);
            expectedDelegateLines = this.buildDetailLines(testTarget, "expectedDelegateLine", numOfExpectedGroups);
        }
        ArrayList<EffortCertificationDetail> summaryLines = new ArrayList<EffortCertificationDetail>();
        ArrayList<EffortCertificationDetail> delegateLines = new ArrayList<EffortCertificationDetail>();
        for (String key : detailLineGroupMap.keySet()) {
            summaryLines.add(((DetailLineGroup)detailLineGroupMap.get(key)).getSummaryDetailLine());
            delegateLines.add(((DetailLineGroup)detailLineGroupMap.get(key)).getDelegateDetailLine());
        }
        List keyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        Assertions.assertTrue((boolean)TestDataPreparator.hasSameElements(expectedSummaryLines, summaryLines, (List)keyFields));
        Assertions.assertTrue((boolean)TestDataPreparator.hasSameElements(expectedDelegateLines, delegateLines, (List)keyFields));
    }

    private List<EffortCertificationDetail> buildDetailLines(String testTarget, String propertyKeyPrefix, int numberOfDetails) {
        return TestDataPreparator.buildTestDataList(EffortCertificationDetail.class, (Properties)this.properties, (String)(testTarget + propertyKeyPrefix), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfDetails);
    }

    private EffortCertificationDetail buildDetailLine(String testTarget, String propertyKeyPrefix) {
        return (EffortCertificationDetail)TestDataPreparator.buildTestDataObject(EffortCertificationDetail.class, (Properties)this.properties, (String)(testTarget + propertyKeyPrefix), (String)this.detailFieldNames, (String)this.deliminator);
    }
}

