/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.batch.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.integration.ld.LaborLedgerBalanceForEffortCertification;
import org.kuali.kfs.integration.ld.LaborModuleService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.module.ec.EffortConstants;
import org.kuali.kfs.module.ec.batch.service.EffortCertificationExtractService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDocumentBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.document.validation.impl.LedgerBalanceFieldValidator;
import org.kuali.kfs.module.ec.service.EffortCertificationDocumentBuildService;
import org.kuali.kfs.module.ec.service.EffortCertificationReportDefinitionService;
import org.kuali.kfs.module.ec.service.EffortCertificationReportService;
import org.kuali.kfs.module.ec.util.EffortCertificationParameterFinder;
import org.kuali.kfs.module.ec.util.ExtractProcessReportDataHolder;
import org.kuali.kfs.module.ec.util.LedgerBalanceConsolidationHelper;
import org.kuali.kfs.module.ec.util.LedgerBalanceWithMessage;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.MessageBuilder;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class EffortCertificationExtractServiceImpl
implements EffortCertificationExtractService {
    private static final Logger LOG = LogManager.getLogger();
    protected BusinessObjectService businessObjectService;
    private OptionsService optionsService;
    private DateTimeService dateTimeService;
    private UniversityDateService universityDateService;
    private LaborModuleService laborModuleService;
    private KualiModuleService kualiModuleService;
    private EffortCertificationDocumentBuildService effortCertificationDocumentBuildService;
    private EffortCertificationReportService effortCertificationReportService;
    private EffortCertificationReportDefinitionService effortCertificationReportDefinitionService;

    @Override
    public void extract() {
        Integer fiscalYear = EffortCertificationParameterFinder.getExtractReportFiscalYear();
        String reportNumber = EffortCertificationParameterFinder.getExtractReportNumber();
        this.extract(fiscalYear, reportNumber);
    }

    @Override
    public void extract(Integer fiscalYear, String reportNumber) {
        Map<String, String> fieldValues = EffortCertificationReportDefinition.buildKeyMap(fiscalYear, reportNumber);
        LOG.info("Validating and retrieving report definition ...");
        String errorMessage = this.validateReportDefinition(fiscalYear, reportNumber);
        String string = errorMessage = StringUtils.isNotEmpty((CharSequence)errorMessage) ? errorMessage : this.existEffortCertificationDocument(fieldValues);
        if (StringUtils.isNotEmpty((CharSequence)errorMessage)) {
            LOG.fatal(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        Map<String, Collection<String>> parameters = EffortCertificationExtractServiceImpl.getSystemParameters();
        parameters.put("EXPENSE_OBJECT_TYPE", this.getExpenseObjectTypeCodes(fiscalYear));
        EffortCertificationReportDefinition reportDefinition = this.effortCertificationReportDefinitionService.findReportDefinitionByPrimaryKey(fieldValues);
        ExtractProcessReportDataHolder reportDataHolder = EffortCertificationExtractServiceImpl.initializeReportData(reportDefinition);
        LOG.info("Finding employees eligible for effort certification ...");
        List<String> employees = this.findEmployeesEligibleForEffortCertification(reportDefinition);
        LOG.info("Generating document build for the eligible employees ...");
        this.effortCertificationDocumentBuildService.removeExistingDocumentBuild(fieldValues);
        this.generateDocumentBuild(reportDefinition, employees, reportDataHolder, parameters);
        LOG.info("Generating report for extract process ...");
        Date runDate = this.dateTimeService.getCurrentSqlDate();
        this.effortCertificationReportService.generateReportForExtractProcess(reportDataHolder, runDate);
    }

    @Override
    public EffortCertificationDocumentBuild extract(String emplid, EffortCertificationReportDefinition effortCertificationReportDefinition) {
        Map<String, Collection<String>> parameters = EffortCertificationExtractServiceImpl.getSystemParameters();
        parameters.put("EXPENSE_OBJECT_TYPE", this.getExpenseObjectTypeCodes(effortCertificationReportDefinition.getUniversityFiscalYear()));
        List<String> positionGroupCodes = this.effortCertificationReportDefinitionService.findPositionObjectGroupCodes(effortCertificationReportDefinition);
        Integer postingYear = this.universityDateService.getCurrentFiscalYear();
        ExtractProcessReportDataHolder reportDataHolder = EffortCertificationExtractServiceImpl.initializeReportData(effortCertificationReportDefinition);
        return this.generateDocumentBuildByEmployee(postingYear, emplid, positionGroupCodes, effortCertificationReportDefinition, reportDataHolder, parameters);
    }

    @Override
    public boolean isEmployeeEligibleForEffortCertification(String emplid, EffortCertificationReportDefinition reportDefinition) {
        Map<String, Set<String>> earnCodePayGroups = this.effortCertificationReportDefinitionService.findReportEarnCodePayGroups(reportDefinition);
        List<String> balanceTypeList = EffortConstants.ELIGIBLE_BALANCE_TYPES_FOR_EFFORT_REPORT;
        Map<Integer, Set<String>> reportPeriods = reportDefinition.getReportPeriods();
        return this.laborModuleService.isEmployeeWithPayType(emplid, reportPeriods, balanceTypeList, earnCodePayGroups);
    }

    @Override
    public List<String> findEmployeesEligibleForEffortCertification(EffortCertificationReportDefinition reportDefinition) {
        Map<String, Set<String>> earnCodePayGroups = this.effortCertificationReportDefinitionService.findReportEarnCodePayGroups(reportDefinition);
        List<String> balanceTypeList = EffortConstants.ELIGIBLE_BALANCE_TYPES_FOR_EFFORT_REPORT;
        Map<Integer, Set<String>> reportPeriods = reportDefinition.getReportPeriods();
        return this.laborModuleService.findEmployeesWithPayType(reportPeriods, balanceTypeList, earnCodePayGroups);
    }

    protected String validateReportDefinition(Integer fiscalYear, String reportNumber) {
        EffortCertificationReportDefinition reportDefinition = new EffortCertificationReportDefinition();
        reportDefinition.setUniversityFiscalYear(fiscalYear);
        reportDefinition.setEffortCertificationReportNumber(reportNumber);
        String errorMessage = this.effortCertificationReportDefinitionService.validateEffortCertificationReportDefinition(reportDefinition);
        return StringUtils.isNotEmpty((CharSequence)errorMessage) ? errorMessage : null;
    }

    protected String existEffortCertificationDocument(Map<String, String> fieldValues) {
        String fiscalYear = fieldValues.get("universityFiscalYear");
        String reportNumber = fieldValues.get("effortCertificationReportNumber");
        int countOfDocuments = this.businessObjectService.countMatching(EffortCertificationDocument.class, fieldValues);
        if (countOfDocuments > 0) {
            return MessageBuilder.buildMessageWithPlaceHolder((String)"error.effort.reportDocumentExist", (Object[])new Object[]{reportNumber, fiscalYear}).getMessage();
        }
        return null;
    }

    protected void generateDocumentBuild(EffortCertificationReportDefinition reportDefinition, List<String> employees, ExtractProcessReportDataHolder reportDataHolder, Map<String, Collection<String>> parameters) {
        List<String> positionGroupCodes = this.effortCertificationReportDefinitionService.findPositionObjectGroupCodes(reportDefinition);
        Integer postingYear = this.universityDateService.getCurrentFiscalYear();
        for (String emplid : employees) {
            EffortCertificationDocumentBuild document = this.generateDocumentBuildByEmployee(postingYear, emplid, positionGroupCodes, reportDefinition, reportDataHolder, parameters);
            if (document == null) continue;
            ArrayList<EffortCertificationDocumentBuild> documents = new ArrayList<EffortCertificationDocumentBuild>();
            documents.add(document);
            this.businessObjectService.save(documents);
            reportDataHolder.updateBasicStatistics("numOfDetailLineWritten", EffortCertificationExtractServiceImpl.getCountOfDetailLines(documents));
            reportDataHolder.updateBasicStatistics("numOfCertificationWritten", documents.size());
        }
        reportDataHolder.updateBasicStatistics("numOfEmployees", employees.size());
        reportDataHolder.updateBasicStatistics("numOfErrors", reportDataHolder.getLedgerBalancesWithMessage().size());
    }

    protected List<LaborLedgerBalance> getQualifiedLedgerBalances(String emplid, List<String> positionGroupCodes, EffortCertificationReportDefinition reportDefinition, ExtractProcessReportDataHolder reportDataHolder, Map<String, Collection<String>> parameters) {
        reportDefinition.getReportPeriods();
        Collection<LaborLedgerBalance> ledgerBalances = this.selectLedgerBalanceForEmployee(emplid, positionGroupCodes, reportDefinition, parameters);
        reportDataHolder.updateBasicStatistics("numOfBalancesRead", ledgerBalances.size());
        List<LaborLedgerBalance> validLedgerBalances = EffortCertificationExtractServiceImpl.removeUnqualifiedLedgerBalances(ledgerBalances, reportDefinition, reportDataHolder);
        reportDataHolder.updateBasicStatistics("numOfBalancesSelected", validLedgerBalances.size());
        List<LaborLedgerBalance> consolidatedLedgerBalances = EffortCertificationExtractServiceImpl.consolidateLedgerBalances(validLedgerBalances, reportDefinition);
        boolean isQualifiedEmployee = this.checkEmployeeBasedOnLedgerBalances(emplid, consolidatedLedgerBalances, reportDefinition, reportDataHolder, parameters);
        return isQualifiedEmployee ? consolidatedLedgerBalances : null;
    }

    protected static List<LaborLedgerBalance> removeUnqualifiedLedgerBalances(Collection<LaborLedgerBalance> ledgerBalances, EffortCertificationReportDefinition reportDefinition, ExtractProcessReportDataHolder reportDataHolder) {
        Map<Integer, Set<String>> reportPeriods = reportDefinition.getReportPeriods();
        List<LedgerBalanceWithMessage> ledgerBalancesWithMessage = reportDataHolder.getLedgerBalancesWithMessage();
        ArrayList<LaborLedgerBalance> validLedgerBalances = new ArrayList<LaborLedgerBalance>();
        for (LaborLedgerBalance balance : ledgerBalances) {
            Message errorAmountMessage = LedgerBalanceFieldValidator.isNonZeroAmountBalanceWithinReportPeriod(balance, reportPeriods);
            Message invalidAccountMessage = LedgerBalanceFieldValidator.hasValidAccount(balance);
            if (invalidAccountMessage != null) {
                EffortCertificationExtractServiceImpl.reportInvalidLedgerBalance(ledgerBalancesWithMessage, balance, invalidAccountMessage);
            }
            if (errorAmountMessage != null || invalidAccountMessage != null) continue;
            validLedgerBalances.add(balance);
        }
        return validLedgerBalances;
    }

    protected boolean checkEmployeeBasedOnLedgerBalances(String emplid, List<LaborLedgerBalance> ledgerBalances, EffortCertificationReportDefinition reportDefinition, ExtractProcessReportDataHolder reportDataHolder, Map<String, Collection<String>> parameters) {
        Collection<String> federalAgencyTypeCodes;
        Message federalFundsNotFoundError;
        if (ledgerBalances == null || ledgerBalances.isEmpty()) {
            return false;
        }
        Map<Integer, Set<String>> reportPeriods = reportDefinition.getReportPeriods();
        List<LedgerBalanceWithMessage> ledgerBalancesWithMessage = reportDataHolder.getLedgerBalancesWithMessage();
        Message nonPositiveTotalError = LedgerBalanceFieldValidator.isTotalAmountPositive(ledgerBalances, reportPeriods);
        if (nonPositiveTotalError != null) {
            this.reportEmployeeWithoutValidBalances(ledgerBalancesWithMessage, nonPositiveTotalError, emplid);
            return false;
        }
        Message grantAccountNotFoundError = LedgerBalanceFieldValidator.hasGrantAccount(ledgerBalances);
        if (grantAccountNotFoundError != null) {
            return false;
        }
        boolean isFederalFundsOnly = Boolean.parseBoolean(parameters.get("FEDERAL_ACCOUNT_IND").iterator().next());
        if (isFederalFundsOnly && (federalFundsNotFoundError = LedgerBalanceFieldValidator.hasFederalFunds(ledgerBalances, federalAgencyTypeCodes = parameters.get("FEDERAL_AGENCY_TYPE"))) != null) {
            this.reportEmployeeWithoutValidBalances(ledgerBalancesWithMessage, federalFundsNotFoundError, emplid);
            return false;
        }
        return true;
    }

    protected Collection<LaborLedgerBalance> selectLedgerBalanceForEmployee(String emplid, List<String> positionObjectGroupCodes, EffortCertificationReportDefinition reportDefinition, Map<String, Collection<String>> parameters) {
        Collection<String> expenseObjectTypeCodes = parameters.get("EXPENSE_OBJECT_TYPE");
        Collection<String> excludedAccountTypeCode = parameters.get("ACCOUNT_TYPES");
        List<String> emplids = Arrays.asList(emplid);
        List<String> laborObjectCodes = Arrays.asList("S");
        HashMap<String, Collection<String>> fieldValues = new HashMap<String, Collection<String>>();
        fieldValues.put("emplid", emplids);
        fieldValues.put("financialObjectTypeCode", expenseObjectTypeCodes);
        fieldValues.put("laborObject.financialObjectFringeOrSalaryCode", laborObjectCodes);
        HashMap<String, Collection<String>> excludedFieldValues = new HashMap<String, Collection<String>>();
        excludedFieldValues.put("account.accountTypeCode", excludedAccountTypeCode);
        Set<Integer> fiscalYears = reportDefinition.getReportPeriods().keySet();
        List<String> balanceTypes = EffortConstants.ELIGIBLE_BALANCE_TYPES_FOR_EFFORT_REPORT;
        return this.laborModuleService.findLedgerBalances(fieldValues, excludedFieldValues, fiscalYears, balanceTypes, positionObjectGroupCodes);
    }

    protected static List<LaborLedgerBalance> consolidateLedgerBalances(List<LaborLedgerBalance> ledgerBalances, EffortCertificationReportDefinition reportDefinition) {
        ArrayList<LaborLedgerBalance> consolidatedLedgerBalances = new ArrayList<LaborLedgerBalance>();
        Map<Integer, Set<String>> reportPeriods = reportDefinition.getReportPeriods();
        HashMap<String, LaborLedgerBalance> ledgerBalanceMap = new HashMap<String, LaborLedgerBalance>();
        LedgerBalanceConsolidationHelper.consolidateLedgerBalances(ledgerBalanceMap, ledgerBalances, EffortCertificationExtractServiceImpl.getConsolidationKeys());
        for (LaborLedgerBalance ledgerBalance : ledgerBalanceMap.values()) {
            KualiDecimal totalAmount = LedgerBalanceConsolidationHelper.calculateTotalAmountWithinReportPeriod(ledgerBalance, reportPeriods);
            if (!totalAmount.isNonZero()) continue;
            consolidatedLedgerBalances.add(ledgerBalance);
        }
        return consolidatedLedgerBalances;
    }

    protected EffortCertificationDocumentBuild generateDocumentBuildByEmployee(Integer postingYear, String emplid, List<String> positionGroupCodes, EffortCertificationReportDefinition reportDefinition, ExtractProcessReportDataHolder reportDataHolder, Map<String, Collection<String>> parameters) {
        List<LaborLedgerBalance> qualifiedLedgerBalance = this.getQualifiedLedgerBalances(emplid, positionGroupCodes, reportDefinition, reportDataHolder, parameters);
        if (qualifiedLedgerBalance == null || qualifiedLedgerBalance.isEmpty()) {
            return null;
        }
        return this.effortCertificationDocumentBuildService.generateDocumentBuild(postingYear, reportDefinition, qualifiedLedgerBalance);
    }

    protected static void reportInvalidLedgerBalance(List<LedgerBalanceWithMessage> ledgerBalancesWithMessage, LaborLedgerBalance ledgerBalance, Message message) {
        ledgerBalancesWithMessage.add(new LedgerBalanceWithMessage(ledgerBalance, message.toString()));
    }

    protected void reportEmployeeWithoutValidBalances(List<LedgerBalanceWithMessage> ledgerBalancesWithMessage, Message message, String emplid) {
        LaborLedgerBalance ledgerBalance = (LaborLedgerBalance)this.kualiModuleService.getResponsibleModuleService(LaborLedgerBalanceForEffortCertification.class).createNewObjectFromExternalizableClass(LaborLedgerBalanceForEffortCertification.class);
        ledgerBalance.setEmplid(emplid);
        EffortCertificationExtractServiceImpl.reportInvalidLedgerBalance(ledgerBalancesWithMessage, ledgerBalance, message);
    }

    protected static Map<String, Collection<String>> getSystemParameters() {
        HashMap<String, Collection<String>> parameters = new HashMap<String, Collection<String>>();
        parameters.put("ACCOUNT_TYPES", EffortCertificationParameterFinder.getAccountTypeCodes());
        parameters.put("FEDERAL_ACCOUNT_IND", EffortCertificationParameterFinder.getFederalOnlyBalanceIndicatorAsString());
        parameters.put("FEDERAL_AGENCY_TYPE", EffortCertificationParameterFinder.getFederalAgencyTypeCodes());
        return parameters;
    }

    protected List<String> getExpenseObjectTypeCodes(Integer fiscalYear) {
        ArrayList<String> expenseObjectTypeCodes = new ArrayList<String>();
        expenseObjectTypeCodes.add(this.optionsService.getOptions(fiscalYear).getFinObjTypeExpenditureexpCd());
        return expenseObjectTypeCodes;
    }

    protected static int getCountOfDetailLines(List<EffortCertificationDocumentBuild> documents) {
        int numOfDetailLines = 0;
        for (EffortCertificationDocumentBuild document : documents) {
            numOfDetailLines += document.getEffortCertificationDetailLinesBuild().size();
        }
        return numOfDetailLines;
    }

    protected static List<String> getConsolidationKeys() {
        ArrayList<String> consolidationKeys = new ArrayList<String>();
        consolidationKeys.add("universityFiscalYear");
        consolidationKeys.add("emplid");
        consolidationKeys.add("chartOfAccountsCode");
        consolidationKeys.add("accountNumber");
        consolidationKeys.add("subAccountNumber");
        consolidationKeys.add("financialObjectCode");
        consolidationKeys.add("positionNumber");
        return consolidationKeys;
    }

    protected static ExtractProcessReportDataHolder initializeReportData(EffortCertificationReportDefinition reportDefinition) {
        ExtractProcessReportDataHolder reportDataHolder = new ExtractProcessReportDataHolder(reportDefinition);
        reportDataHolder.updateBasicStatistics("numOfBalancesRead", 0);
        reportDataHolder.updateBasicStatistics("numOfBalancesSelected", 0);
        reportDataHolder.updateBasicStatistics("numOfDetailLineWritten", 0);
        reportDataHolder.updateBasicStatistics("numOfCertificationWritten", 0);
        reportDataHolder.updateBasicStatistics("numOfEmployees", 0);
        reportDataHolder.updateBasicStatistics("numOfErrors", 0);
        return reportDataHolder;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setLaborModuleService(LaborModuleService laborModuleService) {
        this.laborModuleService = laborModuleService;
    }

    public void setEffortCertificationDocumentBuildService(EffortCertificationDocumentBuildService effortCertificationDocumentBuildService) {
        this.effortCertificationDocumentBuildService = effortCertificationDocumentBuildService;
    }

    public void setEffortCertificationReportService(EffortCertificationReportService effortCertificationReportService) {
        this.effortCertificationReportService = effortCertificationReportService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public void setEffortCertificationReportDefinitionService(EffortCertificationReportDefinitionService effortCertificationReportDefinitionService) {
        this.effortCertificationReportDefinitionService = effortCertificationReportDefinitionService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }
}

