/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.businessobject;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleService;
import org.kuali.kfs.integration.ld.LaborModuleService;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.util.EffortCertificationParameterFinder;
import org.kuali.kfs.module.ec.util.PayrollAmountHolder;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.context.SpringContext;

public class EffortCertificationDetail
extends PersistableBusinessObjectBase {
    private String documentNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String positionNumber;
    private String financialObjectCode;
    private String sourceChartOfAccountsCode;
    private String sourceAccountNumber;
    private KualiDecimal effortCertificationPayrollAmount;
    private KualiDecimal effortCertificationOriginalPayrollAmount;
    private Integer effortCertificationCalculatedOverallPercent;
    private Integer effortCertificationUpdatedOverallPercent;
    private String costShareSourceSubAccountNumber;
    private Integer universityFiscalYear;
    private KualiDecimal originalFringeBenefitAmount;
    private boolean accountExpiredOverride;
    private boolean accountExpiredOverrideNeeded;
    private String overrideCode = "NONE";
    private boolean newLineIndicator;
    private KualiDecimal persistedPayrollAmount;
    private Integer persistedEffortPercent;
    private String groupId;
    private EffortCertificationDocument effortCertificationDocument;
    private ObjectCode financialObject;
    private Chart chartOfAccounts;
    private Account account;
    private Chart sourceChartOfAccounts;
    private Account sourceAccount;
    private SubAccount subAccount;
    private SystemOptions options;
    private Boolean federalOrFederalPassThroughIndicator;
    protected String effectiveDate;

    public EffortCertificationDetail() {
        if (SpringContext.isInitialized()) {
            this.subAccountNumber = KFSConstants.getDashSubAccountNumber();
        }
        this.effortCertificationPayrollAmount = KualiDecimal.ZERO;
        this.effortCertificationOriginalPayrollAmount = KualiDecimal.ZERO;
        this.effortCertificationCalculatedOverallPercent = 0;
        this.effortCertificationUpdatedOverallPercent = 0;
        this.originalFringeBenefitAmount = KualiDecimal.ZERO;
        this.effectiveDate = "";
    }

    public EffortCertificationDetail(EffortCertificationDetail effortCertificationDetail) {
        if (effortCertificationDetail != null) {
            this.chartOfAccountsCode = effortCertificationDetail.getChartOfAccountsCode();
            this.accountNumber = effortCertificationDetail.getAccountNumber();
            this.subAccountNumber = effortCertificationDetail.getSubAccountNumber();
            this.positionNumber = effortCertificationDetail.getPositionNumber();
            this.financialObjectCode = effortCertificationDetail.getFinancialObjectCode();
            this.sourceChartOfAccountsCode = effortCertificationDetail.getSourceChartOfAccountsCode();
            this.sourceAccountNumber = effortCertificationDetail.getSourceAccountNumber();
            this.effortCertificationPayrollAmount = effortCertificationDetail.getEffortCertificationPayrollAmount();
            this.effortCertificationCalculatedOverallPercent = effortCertificationDetail.getEffortCertificationCalculatedOverallPercent();
            this.effortCertificationUpdatedOverallPercent = effortCertificationDetail.getEffortCertificationUpdatedOverallPercent();
            this.universityFiscalYear = effortCertificationDetail.getUniversityFiscalYear();
            this.costShareSourceSubAccountNumber = effortCertificationDetail.getCostShareSourceSubAccountNumber();
            this.effortCertificationOriginalPayrollAmount = effortCertificationDetail.getEffortCertificationOriginalPayrollAmount();
            this.originalFringeBenefitAmount = effortCertificationDetail.getOriginalFringeBenefitAmount();
            this.effectiveDate = effortCertificationDetail.getEffectiveDate();
        }
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        Account account;
        this.accountNumber = accountNumber;
        AccountService accountService = (AccountService)SpringContext.getBean(AccountService.class);
        if (!accountService.accountsCanCrossCharts() && ObjectUtils.isNotNull((Object)(account = accountService.getUniqueAccountForAccountNumber(accountNumber)))) {
            this.setChartOfAccountsCode(account.getChartOfAccountsCode());
            this.setChartOfAccounts(account.getChartOfAccounts());
        }
    }

    public String getSubAccountNumber() {
        return this.subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getPositionNumber() {
        return this.positionNumber;
    }

    public void setPositionNumber(String positionNumber) {
        this.positionNumber = positionNumber;
    }

    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getFinancialObjectCode() {
        return this.financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getSourceChartOfAccountsCode() {
        return this.sourceChartOfAccountsCode;
    }

    public void setSourceChartOfAccountsCode(String sourceChartOfAccountsCode) {
        this.sourceChartOfAccountsCode = sourceChartOfAccountsCode;
    }

    public String getSourceAccountNumber() {
        return this.sourceAccountNumber;
    }

    public void setSourceAccountNumber(String sourceAccountNumber) {
        this.sourceAccountNumber = sourceAccountNumber;
    }

    public KualiDecimal getEffortCertificationPayrollAmount() {
        return this.effortCertificationPayrollAmount;
    }

    public void setEffortCertificationPayrollAmount(KualiDecimal effortCertificationPayrollAmount) {
        this.effortCertificationPayrollAmount = effortCertificationPayrollAmount;
    }

    public Integer getEffortCertificationCalculatedOverallPercent() {
        return this.effortCertificationCalculatedOverallPercent;
    }

    public void setEffortCertificationCalculatedOverallPercent(Integer effortCertificationCalculatedOverallPercent) {
        this.effortCertificationCalculatedOverallPercent = effortCertificationCalculatedOverallPercent;
    }

    public Integer getEffortCertificationUpdatedOverallPercent() {
        return this.effortCertificationUpdatedOverallPercent;
    }

    public void setEffortCertificationUpdatedOverallPercent(Integer effortCertificationUpdatedOverallPercent) {
        this.effortCertificationUpdatedOverallPercent = effortCertificationUpdatedOverallPercent;
    }

    public String getCostShareSourceSubAccountNumber() {
        return this.costShareSourceSubAccountNumber;
    }

    public void setCostShareSourceSubAccountNumber(String costShareSourceSubAccountNumber) {
        this.costShareSourceSubAccountNumber = costShareSourceSubAccountNumber;
    }

    public KualiDecimal getEffortCertificationOriginalPayrollAmount() {
        return this.effortCertificationOriginalPayrollAmount;
    }

    public void setEffortCertificationOriginalPayrollAmount(KualiDecimal effortCertificationOriginalPayrollAmount) {
        this.effortCertificationOriginalPayrollAmount = effortCertificationOriginalPayrollAmount;
    }

    public ObjectCode getFinancialObject() {
        return this.financialObject;
    }

    @Deprecated
    public void setFinancialObject(ObjectCode financialObject) {
        this.financialObject = financialObject;
    }

    public Chart getChartOfAccounts() {
        return this.chartOfAccounts;
    }

    @Deprecated
    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public EffortCertificationDocument getEffortCertificationDocument() {
        return this.effortCertificationDocument;
    }

    @Deprecated
    public void setEffortCertificationDocument(EffortCertificationDocument effortCertificationDocument) {
        this.effortCertificationDocument = effortCertificationDocument;
    }

    public Account getAccount() {
        if (this.account == null && StringUtils.isNotBlank((CharSequence)this.getChartOfAccountsCode()) && StringUtils.isNotBlank((CharSequence)this.getAccountNumber())) {
            this.refreshReferenceObject("account");
        }
        return this.account;
    }

    @Deprecated
    public void setAccount(Account account) {
        this.account = account;
    }

    public Chart getSourceChartOfAccounts() {
        return this.sourceChartOfAccounts;
    }

    @Deprecated
    public void setSourceChartOfAccounts(Chart sourceChartOfAccounts) {
        this.sourceChartOfAccounts = sourceChartOfAccounts;
    }

    public Account getSourceAccount() {
        return this.sourceAccount;
    }

    @Deprecated
    public void setSourceAccount(Account sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public SubAccount getSubAccount() {
        return this.subAccount;
    }

    @Deprecated
    public void setSubAccount(SubAccount subAccount) {
        this.subAccount = subAccount;
    }

    public SystemOptions getOptions() {
        return this.options;
    }

    @Deprecated
    public void setOptions(SystemOptions options) {
        this.options = options;
    }

    public boolean isNewLineIndicator() {
        return this.newLineIndicator;
    }

    public void setNewLineIndicator(boolean newLineIndicator) {
        this.newLineIndicator = newLineIndicator;
    }

    public boolean isEditable() {
        return this.getAccount() == null || this.getAccount().isActive();
    }

    public boolean isFederalOrFederalPassThroughIndicator() {
        if (this.federalOrFederalPassThroughIndicator != null) {
            return this.federalOrFederalPassThroughIndicator;
        }
        if (this.getAccount() != null) {
            Collection<String> federalAgencyTypeCodes = EffortCertificationParameterFinder.getFederalAgencyTypeCodes();
            this.federalOrFederalPassThroughIndicator = ((ContractsAndGrantsModuleService)SpringContext.getBean(ContractsAndGrantsModuleService.class)).isAwardedByFederalAgency(this.getAccount().getChartOfAccountsCode(), this.getAccount().getAccountNumber(), federalAgencyTypeCodes);
            return this.federalOrFederalPassThroughIndicator;
        }
        return false;
    }

    public void setFederalOrFederalPassThroughIndicator(boolean federalOrFederalPassThroughIndicator) {
    }

    public String getOverrideCode() {
        return this.overrideCode;
    }

    public void setOverrideCode(String overrideCode) {
        this.overrideCode = overrideCode;
    }

    public KualiDecimal getFringeBenefitAmount() {
        KualiDecimal payrollAmount = this.getEffortCertificationPayrollAmount();
        return EffortCertificationDetail.calculateFringeBenefit(this, payrollAmount);
    }

    public void setFringeBenefitAmount(KualiDecimal fringeBenefitAmount) {
    }

    public KualiDecimal getOriginalFringeBenefitAmount() {
        if (this.originalFringeBenefitAmount == null || this.originalFringeBenefitAmount.isZero()) {
            this.recalculateOriginalFringeBenefit();
        }
        return this.originalFringeBenefitAmount;
    }

    public void setOriginalFringeBenefitAmount(KualiDecimal originalFringeBenefitAmount) {
        this.originalFringeBenefitAmount = originalFringeBenefitAmount;
    }

    public Integer getUniversityFiscalYear() {
        return this.universityFiscalYear;
    }

    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    public KualiDecimal getPersistedPayrollAmount() {
        return this.persistedPayrollAmount;
    }

    public void setPersistedPayrollAmount(KualiDecimal persistedPayrollAmount) {
        this.persistedPayrollAmount = persistedPayrollAmount;
    }

    public boolean isAccountExpiredOverride() {
        return this.accountExpiredOverride;
    }

    public void setAccountExpiredOverride(boolean accountExpiredOverride) {
        this.accountExpiredOverride = accountExpiredOverride;
    }

    public boolean isAccountExpiredOverrideNeeded() {
        return this.accountExpiredOverrideNeeded;
    }

    public void setAccountExpiredOverrideNeeded(boolean accountExpiredOverrideNeeded) {
        this.accountExpiredOverrideNeeded = accountExpiredOverrideNeeded;
    }

    public static Integer getTotalEffortPercent(List<EffortCertificationDetail> effortCertificationDetailLines) {
        Integer totalEffortPercent = 0;
        for (EffortCertificationDetail detailLine : effortCertificationDetailLines) {
            totalEffortPercent = totalEffortPercent + detailLine.getEffortCertificationUpdatedOverallPercent();
        }
        return totalEffortPercent;
    }

    public static Integer getTotalPersistedEffortPercent(List<EffortCertificationDetail> effortCertificationDetailLines) {
        Integer totalEffortPercent = 0;
        for (EffortCertificationDetail detailLine : effortCertificationDetailLines) {
            totalEffortPercent = totalEffortPercent + detailLine.getPersistedEffortPercent();
        }
        return totalEffortPercent;
    }

    public static Integer getTotalOriginalEffortPercent(List<EffortCertificationDetail> effortCertificationDetailLines) {
        Integer totalOriginalEffortPercent = 0;
        for (EffortCertificationDetail detailLine : effortCertificationDetailLines) {
            totalOriginalEffortPercent = totalOriginalEffortPercent + detailLine.getEffortCertificationCalculatedOverallPercent();
        }
        return totalOriginalEffortPercent;
    }

    public static KualiDecimal getTotalPayrollAmount(List<EffortCertificationDetail> effortCertificationDetailLines) {
        KualiDecimal totalPayrollAmount = KualiDecimal.ZERO;
        for (EffortCertificationDetail detailLine : effortCertificationDetailLines) {
            totalPayrollAmount = (KualiDecimal)totalPayrollAmount.add((AbstractKualiDecimal)detailLine.getEffortCertificationPayrollAmount());
        }
        return totalPayrollAmount;
    }

    public static KualiDecimal getTotalPersistedPayrollAmount(List<EffortCertificationDetail> effortCertificationDetailLines) {
        KualiDecimal totalPayrollAmount = KualiDecimal.ZERO;
        for (EffortCertificationDetail detailLine : effortCertificationDetailLines) {
            totalPayrollAmount = (KualiDecimal)totalPayrollAmount.add((AbstractKualiDecimal)detailLine.getPersistedPayrollAmount());
        }
        return totalPayrollAmount;
    }

    public static KualiDecimal getTotalOriginalPayrollAmount(List<EffortCertificationDetail> effortCertificationDetailLines) {
        KualiDecimal totalOriginalPayrollAmount = KualiDecimal.ZERO;
        for (EffortCertificationDetail detailLine : effortCertificationDetailLines) {
            totalOriginalPayrollAmount = (KualiDecimal)totalOriginalPayrollAmount.add((AbstractKualiDecimal)detailLine.getEffortCertificationOriginalPayrollAmount());
        }
        return totalOriginalPayrollAmount;
    }

    public static KualiDecimal getTotalFringeBenefit(List<EffortCertificationDetail> effortCertificationDetailLines) {
        KualiDecimal totalFringeBenefit = KualiDecimal.ZERO;
        for (EffortCertificationDetail detailLine : effortCertificationDetailLines) {
            totalFringeBenefit = (KualiDecimal)totalFringeBenefit.add((AbstractKualiDecimal)detailLine.getFringeBenefitAmount());
        }
        return totalFringeBenefit;
    }

    public static KualiDecimal getTotalOriginalFringeBenefit(List<EffortCertificationDetail> effortCertificationDetailLines) {
        KualiDecimal totalOriginalFringeBenefit = KualiDecimal.ZERO;
        for (EffortCertificationDetail detailLine : effortCertificationDetailLines) {
            totalOriginalFringeBenefit = (KualiDecimal)totalOriginalFringeBenefit.add((AbstractKualiDecimal)detailLine.getOriginalFringeBenefitAmount());
        }
        return totalOriginalFringeBenefit;
    }

    public void recalculatePayrollAmount(KualiDecimal totalPayrollAmount) {
        Integer effortPercent = this.getEffortCertificationUpdatedOverallPercent();
        KualiDecimal payrollAmount = PayrollAmountHolder.recalculatePayrollAmount(totalPayrollAmount, effortPercent);
        this.setEffortCertificationPayrollAmount(payrollAmount);
    }

    public void recalculateOriginalFringeBenefit() {
        KualiDecimal originalPayrollAmount = this.getEffortCertificationOriginalPayrollAmount();
        KualiDecimal fringeBenefit = EffortCertificationDetail.calculateFringeBenefit(this, originalPayrollAmount);
        this.setOriginalFringeBenefitAmount(fringeBenefit);
    }

    public static KualiDecimal calculateFringeBenefit(EffortCertificationDetail detailLine, KualiDecimal payrollAmount) {
        LaborModuleService laborModuleService = (LaborModuleService)SpringContext.getBean(LaborModuleService.class);
        Integer fiscalYear = EffortCertificationParameterFinder.getCreateReportFiscalYear();
        String chartOfAccountsCode = detailLine.getChartOfAccountsCode();
        String objectCode = detailLine.getFinancialObjectCode();
        String accountNumber = detailLine.getAccountNumber();
        String subAccountNumber = detailLine.getSubAccountNumber();
        return laborModuleService.calculateFringeBenefit(fiscalYear, chartOfAccountsCode, objectCode, payrollAmount, accountNumber, subAccountNumber);
    }

    public Integer getPersistedEffortPercent() {
        return this.persistedEffortPercent;
    }

    public void setPersistedEffortPercent(Integer persistedEffortPercent) {
        this.persistedEffortPercent = persistedEffortPercent;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }
}

