/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetailBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDocumentBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.service.EffortCertificationDetailBuildService;
import org.kuali.kfs.module.ec.service.EffortCertificationDocumentBuildService;
import org.kuali.kfs.module.ec.util.LedgerBalanceConsolidationHelper;
import org.kuali.kfs.module.ec.util.PayrollAmountHolder;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class EffortCertificationDocumentBuildServiceImpl
implements EffortCertificationDocumentBuildService {
    protected EffortCertificationDetailBuildService effortCertificationDetailBuildService;
    protected BusinessObjectService businessObjectService;

    @Override
    public void removeExistingDocumentBuild(Map<String, String> fieldValues) {
        Collection documents = this.businessObjectService.findMatching(EffortCertificationDocumentBuild.class, fieldValues);
        this.businessObjectService.delete(new ArrayList(documents));
    }

    @Override
    public List<EffortCertificationDocumentBuild> generateDocumentBuildList(Integer postingYear, EffortCertificationReportDefinition reportDefinition, List<LaborLedgerBalance> ledgerBalances) {
        ArrayList<EffortCertificationDocumentBuild> documentList = new ArrayList<EffortCertificationDocumentBuild>();
        Map<String, List<LaborLedgerBalance>> ledgerBalanceGroups = this.buildLedgerBalanceGroups(ledgerBalances);
        for (String key : ledgerBalanceGroups.keySet()) {
            List<LaborLedgerBalance> balanceList = ledgerBalanceGroups.get(key);
            EffortCertificationDocumentBuild document = this.generateDocumentBuild(postingYear, reportDefinition, balanceList);
            documentList.add(document);
        }
        return documentList;
    }

    @Override
    public EffortCertificationDocumentBuild generateDocumentBuild(Integer postingYear, EffortCertificationReportDefinition reportDefinition, List<LaborLedgerBalance> ledgerBalances) {
        Map<Integer, Set<String>> reportPeriods = reportDefinition.getReportPeriods();
        KualiDecimal totalAmount = LedgerBalanceConsolidationHelper.calculateTotalAmountWithinReportPeriod(ledgerBalances, reportPeriods);
        PayrollAmountHolder payrollAmountHolder = new PayrollAmountHolder(totalAmount, KualiDecimal.ZERO, 0);
        LaborLedgerBalance headOfBalanceList = ledgerBalances.get(0);
        EffortCertificationDocumentBuild document = EffortCertificationDocumentBuildServiceImpl.populateDocument(reportDefinition, headOfBalanceList);
        List<EffortCertificationDetailBuild> detailLineList = document.getEffortCertificationDetailLinesBuild();
        for (LaborLedgerBalance balance : ledgerBalances) {
            EffortCertificationDetailBuild detailLine = this.effortCertificationDetailBuildService.generateDetailBuild(postingYear, balance, reportDefinition);
            detailLine.setEffortCertificationBuildNumber(document.getEffortCertificationBuildNumber());
            payrollAmountHolder.setPayrollAmount(detailLine.getEffortCertificationPayrollAmount());
            PayrollAmountHolder.calculatePayrollPercent(payrollAmountHolder);
            detailLine.setEffortCertificationCalculatedOverallPercent(payrollAmountHolder.getPayrollPercent());
            detailLine.setEffortCertificationUpdatedOverallPercent(payrollAmountHolder.getPayrollPercent());
            this.updateDetailLineList(detailLineList, detailLine);
        }
        return document;
    }

    protected static EffortCertificationDocumentBuild populateDocument(EffortCertificationReportDefinition reportDefinition, LaborLedgerBalance ledgerBalance) {
        EffortCertificationDocumentBuild document = new EffortCertificationDocumentBuild();
        document.setEffortCertificationBuildNumber(null);
        document.setEffortCertificationDocumentCode(false);
        document.setEffortCertificationReportNumber(reportDefinition.getEffortCertificationReportNumber());
        document.setUniversityFiscalYear(reportDefinition.getUniversityFiscalYear());
        document.setEmplid(ledgerBalance.getEmplid());
        return document;
    }

    protected Map<String, List<LaborLedgerBalance>> buildLedgerBalanceGroups(List<LaborLedgerBalance> ledgerBalances) {
        HashMap<String, List<LaborLedgerBalance>> ledgerBalanceGroups = new HashMap<String, List<LaborLedgerBalance>>();
        for (LaborLedgerBalance balance : ledgerBalances) {
            String consolidationKeys = balance.getEmplid();
            LedgerBalanceConsolidationHelper.groupLedgerBalancesByKeys(ledgerBalanceGroups, balance, consolidationKeys);
        }
        return ledgerBalanceGroups;
    }

    protected void updateDetailLineList(List<EffortCertificationDetailBuild> detailLineList, EffortCertificationDetailBuild detailLine) {
        int index = detailLineList.indexOf((Object)detailLine);
        if (index >= 0) {
            EffortCertificationDetailBuild existingDetailLine = detailLineList.get(index);
            int calculatedOverallPercent = existingDetailLine.getEffortCertificationCalculatedOverallPercent() + detailLine.getEffortCertificationCalculatedOverallPercent();
            existingDetailLine.setEffortCertificationCalculatedOverallPercent(calculatedOverallPercent);
            int updatedOverallPercent = existingDetailLine.getEffortCertificationUpdatedOverallPercent() + detailLine.getEffortCertificationUpdatedOverallPercent();
            existingDetailLine.setEffortCertificationUpdatedOverallPercent(updatedOverallPercent);
            KualiDecimal originalPayrollAmount = (KualiDecimal)existingDetailLine.getEffortCertificationOriginalPayrollAmount().add((AbstractKualiDecimal)detailLine.getEffortCertificationOriginalPayrollAmount());
            existingDetailLine.setEffortCertificationOriginalPayrollAmount(originalPayrollAmount);
            KualiDecimal payrollAmount = (KualiDecimal)existingDetailLine.getEffortCertificationPayrollAmount().add((AbstractKualiDecimal)detailLine.getEffortCertificationPayrollAmount());
            existingDetailLine.setEffortCertificationPayrollAmount(payrollAmount);
        } else {
            detailLineList.add(detailLine);
        }
    }

    public void setEffortCertificationDetailBuildService(EffortCertificationDetailBuildService effortCertificationDetailBuildService) {
        this.effortCertificationDetailBuildService = effortCertificationDetailBuildService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

