/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.core.api.util.type.AbstractKualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleService;
import org.kuali.kfs.integration.ld.LaborLedgerExpenseTransferAccountingLine;
import org.kuali.kfs.integration.ld.LaborLedgerExpenseTransferSourceAccountingLine;
import org.kuali.kfs.integration.ld.LaborLedgerExpenseTransferTargetAccountingLine;
import org.kuali.kfs.integration.ld.LaborModuleService;
import org.kuali.kfs.kew.actiontaken.ActionTaken;
import org.kuali.kfs.kew.api.WorkflowDocument;
import org.kuali.kfs.kew.api.action.ActionRequestType;
import org.kuali.kfs.kew.api.action.WorkflowAction;
import org.kuali.kfs.kim.api.identity.PersonService;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetailBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDocumentBuild;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.document.validation.impl.EffortCertificationDocumentRuleUtil;
import org.kuali.kfs.module.ec.service.EffortCertificationDocumentService;
import org.kuali.kfs.sys.MessageBuilder;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.AccountingLineOverride;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class EffortCertificationDocumentServiceImpl
implements EffortCertificationDocumentService {
    private static final Logger LOG = LogManager.getLogger();
    private LaborModuleService laborModuleService;
    private KualiModuleService kualiModuleService;
    private ContractsAndGrantsModuleService contractsAndGrantsModuleService;
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;
    private PersonService personService;

    @Override
    public void processApprovedEffortCertificationDocument(EffortCertificationDocument effortCertificationDocument) {
        WorkflowDocument workflowDocument = effortCertificationDocument.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isProcessed()) {
            GlobalVariables.setUserSession((UserSession)new UserSession("kfs"));
            this.generateSalaryExpenseTransferDocument(effortCertificationDocument);
        }
    }

    @Override
    public boolean createAndRouteEffortCertificationDocument(EffortCertificationDocumentBuild effortCertificationDocumentBuild) {
        EffortCertificationDocument effortCertificationDocument = (EffortCertificationDocument)this.documentService.getNewDocument("ECD");
        this.populateEffortCertificationDocument(effortCertificationDocument, effortCertificationDocumentBuild);
        this.documentService.routeDocument((Document)effortCertificationDocument, "", null);
        return true;
    }

    @Override
    public boolean populateEffortCertificationDocument(EffortCertificationDocument effortCertificationDocument, EffortCertificationDocumentBuild effortCertificationDocumentBuild) {
        effortCertificationDocument.setUniversityFiscalYear(effortCertificationDocumentBuild.getUniversityFiscalYear());
        effortCertificationDocument.setEmplid(effortCertificationDocumentBuild.getEmplid());
        effortCertificationDocument.setEffortCertificationReportNumber(effortCertificationDocumentBuild.getEffortCertificationReportNumber());
        effortCertificationDocument.setEffortCertificationDocumentCode(effortCertificationDocumentBuild.getEffortCertificationDocumentCode());
        List<EffortCertificationDetail> detailLines = effortCertificationDocument.getEffortCertificationDetailLines();
        detailLines.clear();
        List<EffortCertificationDetailBuild> detailLinesBuild = effortCertificationDocumentBuild.getEffortCertificationDetailLinesBuild();
        for (EffortCertificationDetailBuild detailLineBuild : detailLinesBuild) {
            detailLines.add(new EffortCertificationDetail(detailLineBuild));
        }
        DocumentHeader documentHeader = effortCertificationDocument.getDocumentHeader();
        documentHeader.setDocumentDescription(effortCertificationDocumentBuild.getEmplid());
        documentHeader.setFinancialDocumentTotalAmount(EffortCertificationDocument.getDocumentTotalAmount(effortCertificationDocument));
        return true;
    }

    @Override
    public void removeEffortCertificationDetailLines(EffortCertificationDocument effortCertificationDocument) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("documentNumber", effortCertificationDocument.getDocumentNumber());
        this.businessObjectService.deleteMatching(EffortCertificationDetail.class, fieldValues);
    }

    @Override
    public boolean generateSalaryExpenseTransferDocument(EffortCertificationDocument effortCertificationDocument) {
        List<LaborLedgerExpenseTransferAccountingLine> sourceAccountingLines = this.buildSourceAccountingLines(effortCertificationDocument);
        List<LaborLedgerExpenseTransferAccountingLine> targetAccountingLines = this.buildTargetAccountingLines(effortCertificationDocument);
        if (sourceAccountingLines.isEmpty() || targetAccountingLines.isEmpty()) {
            return true;
        }
        String description = effortCertificationDocument.getEmplid();
        String explanation = MessageBuilder.buildMessageWithPlaceHolder((String)"message.effort.create.SETDocument.explanation", (Object[])new Object[]{effortCertificationDocument.getDocumentNumber()}).toString();
        String annotation = "";
        ArrayList<String> adHocRecipients = new ArrayList<String>(this.getFiscalOfficersIfAmountChanged(effortCertificationDocument));
        this.laborModuleService.createAndBlankApproveSalaryExpenseTransferDocument(description, explanation, "", adHocRecipients, sourceAccountingLines, targetAccountingLines);
        return true;
    }

    @Override
    public void addRouteLooping(EffortCertificationDocument effortCertificationDocument) {
        WorkflowDocument workflowDocument = effortCertificationDocument.getDocumentHeader().getWorkflowDocument();
        Set<Person> priorApprovers = this.getPriorApprovers(workflowDocument);
        for (EffortCertificationDetail detailLine : effortCertificationDocument.getEffortCertificationDetailLines()) {
            Person projectDirector;
            boolean hasBeenChanged = EffortCertificationDocumentRuleUtil.isPayrollAmountChangedFromPersisted(detailLine);
            if (!hasBeenChanged) continue;
            boolean isNewLine = detailLine.isNewLineIndicator();
            LOG.info("EC Detail Line has been changed: {}", (Object)detailLine);
            Account account = detailLine.getAccount();
            Person fiscalOfficer = account.getAccountFiscalOfficerUser();
            if (fiscalOfficer != null && StringUtils.isNotBlank((CharSequence)fiscalOfficer.getPrincipalName())) {
                AdHocRoutePerson adHocRoutePerson = this.buildAdHocRouteRecipient(fiscalOfficer.getPrincipalName(), ActionRequestType.APPROVE);
                this.addAdHocRoutePerson(effortCertificationDocument.getAdHocRoutePersons(), priorApprovers, adHocRoutePerson, isNewLine);
            } else {
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = () -> ((Account)account).getChartOfAccountsCode();
                supplierArray[1] = () -> ((Account)account).getAccountNumber();
                LOG.warn("Unable to obtain a fiscal officer for the detail line's account: {}-{}", supplierArray);
            }
            if ((projectDirector = this.contractsAndGrantsModuleService.getProjectDirectorForAccount(account)) == null) continue;
            String accountProjectDirectorPersonUserId = projectDirector.getPrincipalName();
            AdHocRoutePerson adHocRoutePerson = this.buildAdHocRouteRecipient(accountProjectDirectorPersonUserId, ActionRequestType.APPROVE);
            this.addAdHocRoutePerson(effortCertificationDocument.getAdHocRoutePersons(), priorApprovers, adHocRoutePerson, isNewLine);
        }
    }

    protected void addAdHocRoutePerson(Collection<AdHocRoutePerson> adHocRoutePersonList, Set<Person> priorApprovers, AdHocRoutePerson adHocRoutePerson) {
        this.addAdHocRoutePerson(adHocRoutePersonList, priorApprovers, adHocRoutePerson, false);
    }

    protected void addAdHocRoutePerson(Collection<AdHocRoutePerson> adHocRoutePersonList, Set<Person> priorApprovers, AdHocRoutePerson adHocRoutePerson, boolean isNewLine) {
        boolean canBeAdded = false;
        if (priorApprovers == null || isNewLine) {
            canBeAdded = true;
        } else {
            for (Person approver : priorApprovers) {
                if (!StringUtils.equals((CharSequence)approver.getPrincipalName(), (CharSequence)adHocRoutePerson.getId())) continue;
                canBeAdded = true;
                break;
            }
        }
        if (canBeAdded) {
            for (AdHocRoutePerson person : adHocRoutePersonList) {
                if (!this.isSameAdHocRoutePerson(person, adHocRoutePerson)) continue;
                canBeAdded = false;
                break;
            }
        }
        if (canBeAdded) {
            adHocRoutePersonList.add(adHocRoutePerson);
        }
    }

    protected boolean isSameAdHocRoutePerson(AdHocRoutePerson person1, AdHocRoutePerson person2) {
        if (person1 == null || person2 == null) {
            return false;
        }
        boolean isSameAdHocRoutePerson = StringUtils.equals((CharSequence)person1.getId(), (CharSequence)person2.getId());
        isSameAdHocRoutePerson &= person1.getType().equals(person2.getType());
        return isSameAdHocRoutePerson &= StringUtils.equals((CharSequence)person1.getActionRequested(), (CharSequence)person2.getActionRequested());
    }

    protected Set<Person> getPriorApprovers(WorkflowDocument workflowDocument) {
        List actionsTaken = workflowDocument.getActionsTaken();
        HashSet<String> principalIds = new HashSet<String>();
        HashSet<Person> persons = new HashSet<Person>();
        for (ActionTaken actionTaken : actionsTaken) {
            String principalId;
            if (!WorkflowAction.APPROVE.getCode().equals(actionTaken.getActionTaken()) || principalIds.contains(principalId = actionTaken.getPrincipalId())) continue;
            principalIds.add(principalId);
            persons.add(this.personService.getPerson(principalId));
        }
        return persons;
    }

    protected AdHocRoutePerson buildAdHocRouteRecipient(String personUserId, ActionRequestType actionRequest) {
        AdHocRoutePerson adHocRoutePerson = new AdHocRoutePerson();
        adHocRoutePerson.setActionRequested(actionRequest.getCode());
        adHocRoutePerson.setId(personUserId);
        return adHocRoutePerson;
    }

    protected List<LaborLedgerExpenseTransferAccountingLine> buildSourceAccountingLines(EffortCertificationDocument effortCertificationDocument) {
        ArrayList<LaborLedgerExpenseTransferAccountingLine> sourceAccountingLines = new ArrayList<LaborLedgerExpenseTransferAccountingLine>();
        List<EffortCertificationDetail> effortCertificationDetailLines = effortCertificationDocument.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : effortCertificationDetailLines) {
            if (!this.getDifference(detailLine).isPositive()) continue;
            LaborLedgerExpenseTransferSourceAccountingLine sourceLine = (LaborLedgerExpenseTransferSourceAccountingLine)this.kualiModuleService.getResponsibleModuleService(LaborLedgerExpenseTransferSourceAccountingLine.class).createNewObjectFromExternalizableClass(LaborLedgerExpenseTransferSourceAccountingLine.class);
            this.addAccountingLineIntoList(sourceAccountingLines, (LaborLedgerExpenseTransferAccountingLine)sourceLine, effortCertificationDocument, detailLine);
        }
        return sourceAccountingLines;
    }

    protected List<LaborLedgerExpenseTransferAccountingLine> buildTargetAccountingLines(EffortCertificationDocument effortCertificationDocument) {
        ArrayList<LaborLedgerExpenseTransferAccountingLine> targetAccountingLines = new ArrayList<LaborLedgerExpenseTransferAccountingLine>();
        List<EffortCertificationDetail> effortCertificationDetailLines = effortCertificationDocument.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : effortCertificationDetailLines) {
            if (!this.getDifference(detailLine).isNegative()) continue;
            LaborLedgerExpenseTransferTargetAccountingLine targetLine = (LaborLedgerExpenseTransferTargetAccountingLine)this.kualiModuleService.getResponsibleModuleService(LaborLedgerExpenseTransferTargetAccountingLine.class).createNewObjectFromExternalizableClass(LaborLedgerExpenseTransferTargetAccountingLine.class);
            this.addAccountingLineIntoList(targetAccountingLines, (LaborLedgerExpenseTransferAccountingLine)targetLine, effortCertificationDocument, detailLine);
        }
        return targetAccountingLines;
    }

    protected Set<String> getFiscalOfficersIfAmountChanged(EffortCertificationDocument effortCertificationDocument) {
        HashSet<String> fiscalOfficers = new HashSet<String>();
        List<EffortCertificationDetail> effortCertificationDetailLines = effortCertificationDocument.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : effortCertificationDetailLines) {
            Account account;
            String accountFiscalOfficerPersonUserId;
            if (!this.getDifference(detailLine).isNonZero() || !StringUtils.isEmpty((CharSequence)(accountFiscalOfficerPersonUserId = (account = detailLine.getAccount()).getAccountFiscalOfficerUser().getPrincipalName()))) continue;
            fiscalOfficers.add(accountFiscalOfficerPersonUserId);
        }
        return fiscalOfficers;
    }

    protected void addAccountingLineIntoList(List<LaborLedgerExpenseTransferAccountingLine> accountingLineList, LaborLedgerExpenseTransferAccountingLine accountingLine, EffortCertificationDocument effortCertificationDocument, EffortCertificationDetail detailLine) {
        accountingLine.setSequenceNumber(Integer.valueOf(accountingLineList.size() + 1));
        this.populateAccountingLine(effortCertificationDocument, detailLine, accountingLine);
        accountingLineList.add(accountingLine);
    }

    protected void populateAccountingLine(EffortCertificationDocument effortCertificationDocument, EffortCertificationDetail detailLine, LaborLedgerExpenseTransferAccountingLine accountingLine) {
        accountingLine.setChartOfAccountsCode(detailLine.getChartOfAccountsCode());
        accountingLine.setAccountNumber(detailLine.getAccountNumber());
        accountingLine.setSubAccountNumber(detailLine.getSubAccountNumber());
        accountingLine.setPostingYear(detailLine.getUniversityFiscalYear());
        accountingLine.setFinancialObjectCode(detailLine.getFinancialObjectCode());
        accountingLine.setBalanceTypeCode("AC");
        accountingLine.setAmount((KualiDecimal)this.getDifference(detailLine).abs());
        accountingLine.setFinancialSubObjectCode(null);
        accountingLine.setProjectCode(null);
        accountingLine.setOrganizationReferenceId(null);
        accountingLine.setEmplid(effortCertificationDocument.getEmplid());
        accountingLine.setPositionNumber(detailLine.getPositionNumber());
        accountingLine.setPayrollTotalHours(BigDecimal.ZERO);
        EffortCertificationReportDefinition reportDefinition = effortCertificationDocument.getEffortCertificationReportDefinition();
        accountingLine.setPayrollEndDateFiscalYear(reportDefinition.getExpenseTransferFiscalYear());
        accountingLine.setPayrollEndDateFiscalPeriodCode(reportDefinition.getExpenseTransferFiscalPeriodCode());
        accountingLine.refreshNonUpdateableReferences();
        AccountingLineOverride override = this.laborModuleService.determineNeededOverrides(null, (AccountingLine)accountingLine);
        accountingLine.setAccountExpiredOverrideNeeded(override.hasComponent(AccountingLineOverride.COMPONENT.EXPIRED_ACCOUNT));
        accountingLine.setAccountExpiredOverride(accountingLine.getAccountExpiredOverrideNeeded());
        accountingLine.setObjectBudgetOverrideNeeded(override.hasComponent(AccountingLineOverride.COMPONENT.NON_BUDGETED_OBJECT));
        accountingLine.setObjectBudgetOverride(accountingLine.isObjectBudgetOverrideNeeded());
        if (accountingLine.getAccountExpiredOverrideNeeded() || accountingLine.isObjectBudgetOverrideNeeded()) {
            accountingLine.setOverrideCode(override.getCode());
        }
    }

    protected KualiDecimal getDifference(EffortCertificationDetail detailLine) {
        return (KualiDecimal)detailLine.getEffortCertificationOriginalPayrollAmount().subtract((AbstractKualiDecimal)detailLine.getEffortCertificationPayrollAmount());
    }

    public void setLaborModuleService(LaborModuleService laborModuleService) {
        this.laborModuleService = laborModuleService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setContractsAndGrantsModuleService(ContractsAndGrantsModuleService contractsAndGrantsModuleService) {
        this.contractsAndGrantsModuleService = contractsAndGrantsModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

