/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.validation.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationDetail;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.document.validation.impl.EffortCertificationDocumentRuleUtil;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.businessobject.DocumentHeader;
import org.kuali.kfs.sys.context.KualiIntegTestBase;

@ConfigureContext
public class EffortCertificationDocumentRuleUtilIntegTest
extends KualiIntegTestBase {
    private final Properties properties;
    private final String detailFieldNames;
    private final String documentFieldNames;
    private final String documentHeaderFieldNames;
    private final String reportDefinitionFieldNames;
    private final String deliminator;

    public EffortCertificationDocumentRuleUtilIntegTest() {
        String messageFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/effortCertificationDocumentRuleUtil.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        TestDataPreparator.loadPropertiesFromClassPath((String)messageFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.detailFieldNames = this.properties.getProperty("detailFieldNames");
        this.documentFieldNames = this.properties.getProperty("documentFieldNames");
        this.reportDefinitionFieldNames = this.properties.getProperty("reportDefinitionFieldNames");
        this.documentHeaderFieldNames = this.properties.getProperty("documentHeaderFieldNames");
    }

    public void testApplyDefaultValues() throws Exception {
        String testTarget = "applyDefaultValues.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            EffortCertificationDocumentRuleUtil.applyDefaultValues((EffortCertificationDetail)detailLine);
        }
        int numberOfExpectedDetails = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfExpectedDetails")));
        List expectedDetails = TestDataPreparator.buildTestDataList(EffortCertificationDetail.class, (Properties)this.properties, (String)(testTarget + "expectedDetail"), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfExpectedDetails);
        EffortCertificationDocumentRuleUtilIntegTest.assertEquals((int)numberOfExpectedDetails, (int)details.size());
        List detailKeyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        detailKeyFields.remove("universityFiscalYear");
        EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)TestDataPreparator.hasSameElements((List)expectedDetails, (List)details, (List)detailKeyFields));
    }

    public void testCanExpiredAccountBeUsed() throws Exception {
        String testTarget = "canExpiredAccountBeUsed.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            detailLine.refreshReferenceObject("account");
            detailLine.setOverrideCode("EXPIRED_ACCOUNT");
            EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)EffortCertificationDocumentRuleUtil.canExpiredAccountBeUsed((EffortCertificationDetail)detailLine));
        }
        for (EffortCertificationDetail detailLine : details) {
            detailLine.refreshReferenceObject("account");
            detailLine.setOverrideCode("EXPIRED_ACCOUNT_AND_NON_FRINGE_ACCOUNT_USED");
            EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)EffortCertificationDocumentRuleUtil.canExpiredAccountBeUsed((EffortCertificationDetail)detailLine));
        }
        for (EffortCertificationDetail detailLine : details) {
            detailLine.refreshReferenceObject("account");
            detailLine.setOverrideCode("NONE");
            EffortCertificationDocumentRuleUtilIntegTest.assertFalse((boolean)EffortCertificationDocumentRuleUtil.canExpiredAccountBeUsed((EffortCertificationDetail)detailLine));
        }
    }

    public void testHasA21SubAccount_Yes() throws Exception {
        String testTarget = "hasA21SubAccount.yes.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            detailLine.refreshReferenceObject("subAccount");
            EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)EffortCertificationDocumentRuleUtil.hasA21SubAccount((EffortCertificationDetail)detailLine));
        }
    }

    public void testHasA21SubAccount_No() throws Exception {
        String testTarget = "hasA21SubAccount.no.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            detailLine.refreshReferenceObject("subAccount");
            EffortCertificationDocumentRuleUtilIntegTest.assertFalse((boolean)EffortCertificationDocumentRuleUtil.hasA21SubAccount((EffortCertificationDetail)detailLine));
        }
    }

    public void testHasClosedAccount_Yes() throws Exception {
        String testTarget = "hasClosedAccount.yes.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            detailLine.refreshReferenceObject("account");
            EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)EffortCertificationDocumentRuleUtil.hasClosedAccount((EffortCertificationDetail)detailLine));
        }
    }

    public void testHasClosedAccount_No() throws Exception {
        String testTarget = "hasClosedAccount.no.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            detailLine.refreshReferenceObject("account");
            EffortCertificationDocumentRuleUtilIntegTest.assertFalse((boolean)EffortCertificationDocumentRuleUtil.hasClosedAccount((EffortCertificationDetail)detailLine));
        }
    }

    public void testHasContractGrantAccount_Yes() throws Exception {
        String testTarget = "hasContractGrantAccount.yes.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            detailLine.refreshReferenceObject("account");
            EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)EffortCertificationDocumentRuleUtil.hasContractGrantAccount((EffortCertificationDetail)detailLine));
        }
    }

    public void testHasContractGrantAccount_No() throws Exception {
        String testTarget = "hasContractGrantAccount.no.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            detailLine.refreshReferenceObject("account");
            EffortCertificationDocumentRuleUtilIntegTest.assertFalse((boolean)EffortCertificationDocumentRuleUtil.hasContractGrantAccount((EffortCertificationDetail)detailLine));
        }
    }

    public void testHasCostShareSubAccount_Yes() throws Exception {
        String testTarget = "hasCostShareSubAccount.yes.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List designatedCostShareSubAccountTypeCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "costShareSubAccountTypeCodes"), (String)this.deliminator);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            detailLine.refreshReferenceObject("subAccount");
            EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)EffortCertificationDocumentRuleUtil.hasCostShareSubAccount((EffortCertificationDetail)detailLine, (List)designatedCostShareSubAccountTypeCodes));
        }
    }

    public void testHasCostShareSubAccount_No() throws Exception {
        String testTarget = "hasCostShareSubAccount.no.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List designatedCostShareSubAccountTypeCodes = ObjectUtil.split((String)this.properties.getProperty(testTarget + "costShareSubAccountTypeCodes"), (String)this.deliminator);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            detailLine.refreshReferenceObject("subAccount");
            EffortCertificationDocumentRuleUtilIntegTest.assertFalse((boolean)EffortCertificationDocumentRuleUtil.hasCostShareSubAccount((EffortCertificationDetail)detailLine, (List)designatedCostShareSubAccountTypeCodes));
        }
    }

    public void testHasNonNegativePayrollAmount_Yes() throws Exception {
        String testTarget = "hasNonnegativePayrollAmount.yes.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)EffortCertificationDocumentRuleUtil.hasNonNegativePayrollAmount((EffortCertificationDetail)detailLine));
        }
    }

    public void testHasNonNegativePayrollAmount_No() throws Exception {
        String testTarget = "hasNonnegativePayrollAmount.no.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            EffortCertificationDocumentRuleUtilIntegTest.assertFalse((boolean)EffortCertificationDocumentRuleUtil.hasNonNegativePayrollAmount((EffortCertificationDetail)detailLine));
        }
    }

    public void testHasSameExistingLine_Yes() throws Exception {
        String testTarget = "hasSameExistingLine.yes.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        EffortCertificationDetail newDetail = this.buildDetailLine(testTarget);
        List<String> comparableFields = Arrays.asList("chartOfAccountsCode", "accountNumber", "subAccountNumber");
        EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)EffortCertificationDocumentRuleUtil.hasSameExistingLine((EffortCertificationDocument)document, (EffortCertificationDetail)newDetail, comparableFields));
    }

    public void testHasSameExistingLine_No() throws Exception {
        String testTarget = "hasSameExistingLine.no.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        EffortCertificationDetail newDetail = this.buildDetailLine(testTarget);
        List<String> comparableFields = Arrays.asList("chartOfAccountsCode", "accountNumber", "subAccountNumber");
        EffortCertificationDocumentRuleUtilIntegTest.assertFalse((boolean)EffortCertificationDocumentRuleUtil.hasSameExistingLine((EffortCertificationDocument)document, (EffortCertificationDetail)newDetail, comparableFields));
    }

    public void testHasValidEffortPercent_Yes() throws Exception {
        String testTarget = "hasValidEffortPercent.yes.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)EffortCertificationDocumentRuleUtil.hasValidEffortPercent((EffortCertificationDetail)detailLine));
        }
    }

    public void testHasValidEffortPercent_No() throws Exception {
        String testTarget = "hasValidEffortPercent.no.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            EffortCertificationDocumentRuleUtilIntegTest.assertFalse((boolean)EffortCertificationDocumentRuleUtil.hasValidEffortPercent((EffortCertificationDetail)detailLine));
        }
    }

    public void testIsPayrollAmountChanged_Line_Yes() throws Exception {
        String testTarget = "isPayrollAmountChanged.line.yes.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)EffortCertificationDocumentRuleUtil.isPayrollAmountChangedFromOriginal((EffortCertificationDetail)detailLine));
        }
    }

    public void testIsPayrollAmountChanged_Line_No() throws Exception {
        String testTarget = "isPayrollAmountChanged.line.no.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            EffortCertificationDocumentRuleUtilIntegTest.assertFalse((boolean)EffortCertificationDocumentRuleUtil.isPayrollAmountChangedFromOriginal((EffortCertificationDetail)detailLine));
        }
    }

    public void testIsPayrollAmountChanged_Document_Yes() throws Exception {
        String testTarget = "isPayrollAmountChanged.document.yes.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)EffortCertificationDocumentRuleUtil.isPayrollAmountChangedFromOriginal((EffortCertificationDocument)document));
    }

    public void testIsPayrollAmountChanged_Document_No() throws Exception {
        String testTarget = "isPayrollAmountChanged.document.no.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        EffortCertificationDocumentRuleUtilIntegTest.assertFalse((boolean)EffortCertificationDocumentRuleUtil.isPayrollAmountChangedFromOriginal((EffortCertificationDocument)document));
    }

    public void testIsPayrollAmountNonNegative_Yes() throws Exception {
        this.testHasNonNegativePayrollAmount_Yes();
    }

    public void testIsPayrollAmountNonNegative_No() throws Exception {
        this.testHasNonNegativePayrollAmount_No();
    }

    public void testIsPayrollAmountOverChanged_Line_Yes() throws Exception {
        String testTarget = "isPayrollAmountOverChanged.line.yes.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        KualiDecimal originalTotalAmount = document.getTotalOriginalPayrollAmount();
        double limitOfLinePayrollAmountChange = Double.parseDouble(StringUtils.trim((String)this.properties.getProperty(testTarget + "limitOfLinePayrollAmountChange")));
        List details = document.getEffortCertificationDetailLines();
        int countOfOverChangedLine = 0;
        for (EffortCertificationDetail detailLine : details) {
            if (!EffortCertificationDocumentRuleUtil.isPayrollAmountOverChanged((EffortCertificationDetail)detailLine, (KualiDecimal)originalTotalAmount, (double)limitOfLinePayrollAmountChange)) continue;
            ++countOfOverChangedLine;
        }
        EffortCertificationDocumentRuleUtilIntegTest.assertEquals((String)"All line amounts are over changed.", (int)details.size(), (int)countOfOverChangedLine);
    }

    public void testIsPayrollAmountOverChanged_Line_No() throws Exception {
        String testTarget = "isPayrollAmountOverChanged.line.no.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        KualiDecimal originalTotalAmount = document.getTotalOriginalPayrollAmount();
        double limitOfLinePayrollAmountChange = Double.parseDouble(StringUtils.trim((String)this.properties.getProperty(testTarget + "limitOfLinePayrollAmountChange")));
        List details = document.getEffortCertificationDetailLines();
        int countOfOverChangedLine = 0;
        for (EffortCertificationDetail detailLine : details) {
            if (!EffortCertificationDocumentRuleUtil.isPayrollAmountOverChanged((EffortCertificationDetail)detailLine, (KualiDecimal)originalTotalAmount, (double)limitOfLinePayrollAmountChange)) continue;
            ++countOfOverChangedLine;
        }
        EffortCertificationDocumentRuleUtilIntegTest.assertEquals((String)"There is no line whose amount is overchanged.", (int)0, (int)countOfOverChangedLine);
    }

    public void testIsPayrollAmountOverChanged_Document_Yes() throws Exception {
        String testTarget = "isPayrollAmountOverChanged.document.yes.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        double limitOfLinePayrollAmountChange = Double.parseDouble(StringUtils.trim((String)this.properties.getProperty(testTarget + "limitOfLinePayrollAmountChange")));
        EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)EffortCertificationDocumentRuleUtil.isPayrollAmountOverChanged((EffortCertificationDocument)document, (double)limitOfLinePayrollAmountChange));
    }

    public void testIsPayrollAmountOverChanged_Document_No() throws Exception {
        String testTarget = "isPayrollAmountOverChanged.document.no.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        double limitOfLinePayrollAmountChange = Double.parseDouble(StringUtils.trim((String)this.properties.getProperty(testTarget + "limitOfLinePayrollAmountChange")));
        EffortCertificationDocumentRuleUtilIntegTest.assertFalse((boolean)EffortCertificationDocumentRuleUtil.isPayrollAmountOverChanged((EffortCertificationDocument)document, (double)limitOfLinePayrollAmountChange));
    }

    public void testIsTotalEffortPercentageAs100_Yes() throws Exception {
        String testTarget = "isTotalEffortPercentageAs100.yes.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)EffortCertificationDocumentRuleUtil.isTotalEffortPercentageAs100((EffortCertificationDocument)document));
    }

    public void testIsTotalEffortPercentageAs100_No() throws Exception {
        String testTarget = "isTotalEffortPercentageAs100.no.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        EffortCertificationDocumentRuleUtilIntegTest.assertFalse((boolean)EffortCertificationDocumentRuleUtil.isTotalEffortPercentageAs100((EffortCertificationDocument)document));
    }

    public void testIsTotalPayrollAmountOverChanged_Yes() throws Exception {
        String testTarget = "isTotalPayrollAmountOverChanged.yes.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        double limitOfTotalPayrollAmountChange = Double.parseDouble(StringUtils.trim((String)this.properties.getProperty(testTarget + "limitOfTotalPayrollAmountChange")));
        EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)EffortCertificationDocumentRuleUtil.isTotalPayrollAmountOverChanged((EffortCertificationDocument)document, (double)limitOfTotalPayrollAmountChange));
    }

    public void testIsTotalPayrollAmountOverChanged_No() throws Exception {
        String testTarget = "isTotalPayrollAmountOverChanged.no.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        double limitOfTotalPayrollAmountChange = Double.parseDouble(StringUtils.trim((String)this.properties.getProperty(testTarget + "limitOfTotalPayrollAmountChange")));
        EffortCertificationDocumentRuleUtilIntegTest.assertFalse((boolean)EffortCertificationDocumentRuleUtil.isTotalPayrollAmountOverChanged((EffortCertificationDocument)document, (double)limitOfTotalPayrollAmountChange));
    }

    public void testIsValidPercent_Yes() throws Exception {
        this.testHasValidEffortPercent_Yes();
    }

    public void testIsValidPercent_No() throws Exception {
        this.testHasValidEffortPercent_No();
    }

    public void testUpdateSourceAccountInformation() throws Exception {
        String testTarget = "updateSourceAccountInformation.";
        EffortCertificationDocument document = this.loadEffortCertificationDocument(testTarget);
        List details = document.getEffortCertificationDetailLines();
        for (EffortCertificationDetail detailLine : details) {
            detailLine.refreshReferenceObject("subAccount");
            EffortCertificationDocumentRuleUtil.updateSourceAccountInformation((EffortCertificationDetail)detailLine);
        }
        List<EffortCertificationDetail> expectedDetails = this.buildExpectedDetailLines(testTarget);
        List detailKeyFields = ObjectUtil.split((String)this.detailFieldNames, (String)this.deliminator);
        EffortCertificationDocumentRuleUtilIntegTest.assertTrue((boolean)TestDataPreparator.hasSameElements(expectedDetails, (List)details, (List)detailKeyFields));
    }

    private EffortCertificationDocument loadEffortCertificationDocument(String testTarget) throws Exception {
        TestDataPreparator.doCleanUpWithReference(EffortCertificationDocument.class, (Properties)this.properties, (String)"documentCleanup", (String)this.documentFieldNames, (String)this.deliminator);
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition();
        TestDataPreparator.persistDataObject((PersistableBusinessObject)reportDefinition);
        DocumentHeader documentHeader = (DocumentHeader)TestDataPreparator.buildTestDataObject(DocumentHeader.class, (Properties)this.properties, (String)(testTarget + "documentHeader"), (String)this.documentHeaderFieldNames, (String)this.deliminator);
        documentHeader = (DocumentHeader)TestDataPreparator.persistDataObject((PersistableBusinessObject)documentHeader);
        EffortCertificationDocument document = this.buildDocument(testTarget);
        document.setDocumentHeader(documentHeader);
        List<EffortCertificationDetail> detailLines = this.buildDetailLines(testTarget);
        document.setEffortCertificationDetailLines(detailLines);
        document = (EffortCertificationDocument)TestDataPreparator.persistDataObject((PersistableBusinessObject)document);
        return document;
    }

    private EffortCertificationReportDefinition buildReportDefinition() {
        return (EffortCertificationReportDefinition)TestDataPreparator.buildTestDataObject(EffortCertificationReportDefinition.class, (Properties)this.properties, (String)"reportDefinitionFieldValues", (String)this.reportDefinitionFieldNames, (String)this.deliminator);
    }

    private EffortCertificationDocument buildDocument(String testTarget) {
        return (EffortCertificationDocument)TestDataPreparator.buildTestDataObject(EffortCertificationDocument.class, (Properties)this.properties, (String)(testTarget + "document"), (String)this.documentFieldNames, (String)this.deliminator);
    }

    private List<EffortCertificationDetail> buildDetailLines(String testTarget) {
        int numberOfDetails = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfDetails")));
        return TestDataPreparator.buildTestDataList(EffortCertificationDetail.class, (Properties)this.properties, (String)(testTarget + "detail"), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfDetails);
    }

    private List<EffortCertificationDetail> buildExpectedDetailLines(String testTarget) {
        int numberOfDetails = Integer.parseInt(StringUtils.trim((String)this.properties.getProperty(testTarget + "numOfExpectedDetails")));
        return TestDataPreparator.buildTestDataList(EffortCertificationDetail.class, (Properties)this.properties, (String)(testTarget + "expectedDetail"), (String)this.detailFieldNames, (String)this.deliminator, (int)numberOfDetails);
    }

    private EffortCertificationDetail buildDetailLine(String testTarget) {
        return (EffortCertificationDetail)TestDataPreparator.buildTestDataObject(EffortCertificationDetail.class, (Properties)this.properties, (String)(testTarget + "newDetail"), (String)this.detailFieldNames, (String)this.deliminator);
    }
}

