/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ec.document.validation.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.ec.businessobject.EffortCertificationReportDefinition;
import org.kuali.kfs.module.ec.document.validation.impl.LedgerBalanceFieldValidator;
import org.kuali.kfs.module.ec.testdata.EffortTestDataPropertyConstants;
import org.kuali.kfs.module.ld.businessobject.LedgerBalanceForEffortCertification;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class LedgerBalanceFieldValidatorIntegTest
extends KualiIntegTestBase {
    private final Properties properties;
    private final Properties message;
    private final String balanceFieldNames;
    private final String deliminator;
    private BusinessObjectService businessObjectService;
    private PersistenceService persistenceService;
    private Class<? extends LaborLedgerBalance> ledgerBalanceClass;

    public LedgerBalanceFieldValidatorIntegTest() {
        String messageFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = EffortTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/ledgerBalanceFieldValidator.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.message = TestDataPreparator.loadPropertiesFromClassPath((String)messageFileName);
        this.deliminator = this.properties.getProperty("deliminator");
        this.balanceFieldNames = this.properties.getProperty("balanceFieldNames");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.persistenceService = (PersistenceService)SpringContext.getBean(PersistenceService.class);
        this.ledgerBalanceClass = LedgerBalanceForEffortCertification.class;
        TestDataPreparator.doCleanUpWithoutReference(this.ledgerBalanceClass, (Properties)this.properties, (String)"dataCleanup", (String)this.balanceFieldNames, (String)this.deliminator);
    }

    public void testHasValidAccount_valid() {
        String testTarget = "hasValidAccount.valid.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance("hasValidAccount.valid.");
        Message validationMessage = LedgerBalanceFieldValidator.hasValidAccount((LaborLedgerBalance)ledgerBalance);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasValidAccount.valid");
        LedgerBalanceFieldValidatorIntegTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsInFundGroups_Contain() {
        String testTarget = "isInFundGroups.contain.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance("isInFundGroups.contain.");
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty("isInFundGroups.contain.fundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.isInFundGroups((LaborLedgerBalance)ledgerBalance, (List)fundGroupCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isInFundGroups.contain");
        LedgerBalanceFieldValidatorIntegTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsInFundGroups_NotContain() {
        String testTarget = "isInFundGroups.notContain.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance("isInFundGroups.notContain.");
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty("isInFundGroups.notContain.fundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.isInFundGroups((LaborLedgerBalance)ledgerBalance, (List)fundGroupCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isInFundGroups.notContain");
        LedgerBalanceFieldValidatorIntegTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsInSubFundGroups_Contain() {
        String testTarget = "isInSubFundGroups.contain.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance("isInSubFundGroups.contain.");
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty("isInSubFundGroups.contain.subFundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.isInSubFundGroups((LaborLedgerBalance)ledgerBalance, (List)fundGroupCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isInSubFundGroups.contain");
        LedgerBalanceFieldValidatorIntegTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsInSubFundGroups_NotContain() {
        String testTarget = "isInSubFundGroups.notContain.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance("isInSubFundGroups.notContain.");
        List fundGroupCodes = ObjectUtil.split((String)this.properties.getProperty("isInSubFundGroups.notContain.subFundGroups"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.isInSubFundGroups((LaborLedgerBalance)ledgerBalance, (List)fundGroupCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isInSubFundGroups.notContain");
        LedgerBalanceFieldValidatorIntegTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsNonZeroAmountBalanceWithinReportPeriod_IsNonZeroAmount() {
        String testTarget = "isNonZeroAmountBalanceWithinReportPeriod.isNonZeroAmount.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance("isNonZeroAmountBalanceWithinReportPeriod.isNonZeroAmount.");
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition("isNonZeroAmountBalanceWithinReportPeriod.isNonZeroAmount.");
        Message validationMessage = LedgerBalanceFieldValidator.isNonZeroAmountBalanceWithinReportPeriod((LaborLedgerBalance)ledgerBalance, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isNonZeroAmountBalanceWithinReportPeriod.isNonZeroAmount");
        LedgerBalanceFieldValidatorIntegTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsNonZeroAmountBalanceWithinReportPeriod_IsZeroAmount() {
        String testTarget = "isNonZeroAmountBalanceWithinReportPeriod.isZeroAmount.";
        LaborLedgerBalance ledgerBalance = this.buildLedgerBalance("isNonZeroAmountBalanceWithinReportPeriod.isZeroAmount.");
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition("isNonZeroAmountBalanceWithinReportPeriod.isZeroAmount.");
        Message validationMessage = LedgerBalanceFieldValidator.isNonZeroAmountBalanceWithinReportPeriod((LaborLedgerBalance)ledgerBalance, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isNonZeroAmountBalanceWithinReportPeriod.isZeroAmount");
        LedgerBalanceFieldValidatorIntegTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsTotalAmountPositive_IsPositive() {
        String testTarget = "isTotalAmountPositive.isPositive.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances("isTotalAmountPositive.isPositive.");
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition("isTotalAmountPositive.isPositive.");
        Message validationMessage = LedgerBalanceFieldValidator.isTotalAmountPositive(ledgerBalances, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isTotalAmountPositive.isPositive");
        LedgerBalanceFieldValidatorIntegTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsTotalAmountPositive_IsZero() {
        String testTarget = "isTotalAmountPositive.isZero.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances("isTotalAmountPositive.isZero.");
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition("isTotalAmountPositive.isZero.");
        Message validationMessage = LedgerBalanceFieldValidator.isTotalAmountPositive(ledgerBalances, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isTotalAmountPositive.isZero");
        LedgerBalanceFieldValidatorIntegTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsTotalAmountPositive_IsNegative() {
        String testTarget = "isTotalAmountPositive.isNegative.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances("isTotalAmountPositive.isNegative.");
        EffortCertificationReportDefinition reportDefinition = this.buildReportDefinition("isTotalAmountPositive.isNegative.");
        Message validationMessage = LedgerBalanceFieldValidator.isTotalAmountPositive(ledgerBalances, (Map)reportDefinition.getReportPeriods());
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isTotalAmountPositive.isNegative");
        LedgerBalanceFieldValidatorIntegTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testHasGrantAccount_ByFundGroup_Contain() {
        String testTarget = "hasGrantAccount.byFundGroup.contain.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances("hasGrantAccount.byFundGroup.contain.");
        Message validationMessage = LedgerBalanceFieldValidator.hasGrantAccount(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasGrantAccount.byFundGroup.contain");
        LedgerBalanceFieldValidatorIntegTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testHasGrantAccount_ByFundGroup_NotContain() {
        String testTarget = "hasGrantAccount.byFundGroup.notContain.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances("hasGrantAccount.byFundGroup.notContain.");
        Message validationMessage = LedgerBalanceFieldValidator.hasGrantAccount(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasGrantAccount.byFundGroup.notContain");
        LedgerBalanceFieldValidatorIntegTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testHasGrantAccount_BySubFundGroup_Contain() {
        String testTarget = "hasGrantAccount.bySubFundGroup.contain.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances("hasGrantAccount.bySubFundGroup.contain.");
        Message validationMessage = LedgerBalanceFieldValidator.hasGrantAccount(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasGrantAccount.bySubFundGroup.contain");
        LedgerBalanceFieldValidatorIntegTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testHasGrantAccount_BySubFundGroup_NotContain() {
        String testTarget = "hasGrantAccount.bySubFundGroup.notContain.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances("hasGrantAccount.bySubFundGroup.notContain.");
        Message validationMessage = LedgerBalanceFieldValidator.hasGrantAccount(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasGrantAccount.bySubFundGroup.notContain");
        LedgerBalanceFieldValidatorIntegTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsFromSingleOrganization_Single() {
        String testTarget = "isFromSingleOrganization.single.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances("isFromSingleOrganization.single.");
        Message validationMessage = LedgerBalanceFieldValidator.isFromSingleOrganization(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isFromSingleOrganization.single");
        LedgerBalanceFieldValidatorIntegTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testIsFromSingleOrganization_Multiple() {
        String testTarget = "isFromSingleOrganization.multiple.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances("isFromSingleOrganization.multiple.");
        Message validationMessage = LedgerBalanceFieldValidator.isFromSingleOrganization(ledgerBalances);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.isFromSingleOrganization.multiple");
        LedgerBalanceFieldValidatorIntegTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    public void testHasFederalFunds_FederalFunds() {
        String testTarget = "hasFederalFunds.federalFunds.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances("hasFederalFunds.federalFunds.");
        List federalAgencyTypeCodes = ObjectUtil.split((String)this.properties.getProperty("hasFederalFunds.federalFunds.federalAgencyTypeCodes"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.hasFederalFunds(ledgerBalances, (Collection)federalAgencyTypeCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasFederalFunds.federalFunds");
        LedgerBalanceFieldValidatorIntegTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testHasFederalFunds_PassThrough() {
        String testTarget = "hasFederalFunds.passThrough.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances("hasFederalFunds.passThrough.");
        List federalAgencyTypeCodes = ObjectUtil.split((String)this.properties.getProperty("hasFederalFunds.passThrough.federalAgencyTypeCodes"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.hasFederalFunds(ledgerBalances, (Collection)federalAgencyTypeCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasFederalFunds.passThrough");
        LedgerBalanceFieldValidatorIntegTest.assertNull((String)errorMessage, (Object)validationMessage);
    }

    public void testHasFederalFunds_NoFederalFunds() {
        String testTarget = "hasFederalFunds.noFederalFunds.";
        List<LaborLedgerBalance> ledgerBalances = this.buildLedgerBalances("hasFederalFunds.noFederalFunds.");
        List federalAgencyTypeCodes = ObjectUtil.split((String)this.properties.getProperty("hasFederalFunds.noFederalFunds.federalAgencyTypeCodes"), (String)this.deliminator);
        Message validationMessage = LedgerBalanceFieldValidator.hasFederalFunds(ledgerBalances, (Collection)federalAgencyTypeCodes);
        String errorMessage = this.message.getProperty("error.ledgerBalanceFieldValidator.hasFederalFunds.noFederalFunds");
        LedgerBalanceFieldValidatorIntegTest.assertNotNull((String)errorMessage, (Object)validationMessage);
    }

    private LaborLedgerBalance buildLedgerBalance(String testTarget) {
        LaborLedgerBalance ledgerBalance = (LaborLedgerBalance)TestDataPreparator.buildTestDataObject(this.ledgerBalanceClass, (Properties)this.properties, (String)(testTarget + "inputBalance"), (String)this.balanceFieldNames, (String)this.deliminator);
        this.businessObjectService.save((PersistableBusinessObject)ledgerBalance);
        this.persistenceService.retrieveNonKeyFields((Object)ledgerBalance);
        ledgerBalance.refreshNonUpdateableReferences();
        return ledgerBalance;
    }

    private List<LaborLedgerBalance> buildLedgerBalances(String testTarget) {
        int numberOfTestData = Integer.parseInt(this.properties.getProperty(testTarget + "numOfData"));
        List ledgerBalances = TestDataPreparator.buildTestDataList(this.ledgerBalanceClass, (Properties)this.properties, (String)(testTarget + "inputBalance"), (String)this.balanceFieldNames, (String)this.deliminator, (int)numberOfTestData);
        this.businessObjectService.save(ledgerBalances);
        for (LaborLedgerBalance balance : ledgerBalances) {
            this.persistenceService.retrieveNonKeyFields((Object)balance);
            balance.refreshNonUpdateableReferences();
        }
        return ledgerBalances;
    }

    private EffortCertificationReportDefinition buildReportDefinition(String testTarget) {
        EffortCertificationReportDefinition reportDefinition = new EffortCertificationReportDefinition();
        String reportDefinitionFieldNames = this.properties.getProperty("reportDefinitionFieldNames");
        ObjectUtil.populateBusinessObject((Object)reportDefinition, (Properties)this.properties, (String)(testTarget + "reportDefinitionFieldValues"), (String)reportDefinitionFieldNames, (String)this.deliminator);
        return reportDefinition;
    }
}

