/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec;

/**
 * Constants that represent keys to messages or errors given in the effort reporting module.
 */
public final class EffortKeyConstants {

    public static final String ERROR_ACCOUNT_CLOSED = "error.effort.accountClosed";
    public static final String ERROR_ACCOUNT_NUMBER_NOT_FOUND = "error.effort.accountNumberNotFound";
    public static final String ERROR_BATCH_JOB_NOT_SCHEDULED = "error.effort.batchJobNotScheduled";
    public static final String ERROR_CREATE_PROCESS_HAS_NOT_BEEN_COMPLETED = "error.effort.createProcessHasNotBeenCompleted";
    public static final String ERROR_EMPLOYEE_NO_ELIGIBLE_LABOR_BALANCE = "error.effort.employeeNoEligibleLaborBalance";
    public static final String ERROR_EMPLOYEE_NOT_ELIGIBLE = "error.effort.employeeNotEligibleForEffortCertification";
    public static final String ERROR_END_FISCAL_YEAR = "error.effort.effortCertificationReport.endFiscalYear";
    public static final String ERROR_FISCAL_YEAR_MISSING = "error.effort.fiscalYearMissing";
    public static final String ERROR_FISCAL_YEAR_OR_REPORT_NUMBER_INVALID = "error.effort.fiscalYearOrReportNumberInvalid";
    public static final String ERROR_FUND_GROUP_NOT_FOUND = "error.effort.fundGroupNotFound";
    public static final String ERROR_INVALID_EFFORT_PERCENT = "error.effort.invalidEffortPercent";
    public static final String ERROR_LINE_EXISTS = "error.effort.lineExists";
    public static final String ERROR_MULTIPLE_ORGANIZATIONS_FOUND = "error.effort.multipleOrganizationFound";
    public static final String ERROR_NEGATIVE_PAYROLL_AMOUNT = "error.effort.negativePayrollAmount";
    public static final String ERROR_NON_POSITIVE_PAYROLL_AMOUNT = "error.effort.nonPositivePayrollAmount";
    public static final String ERROR_NOT_HAVE_DETAIL_LINE = "error.effort.notHaveDetailLine";
    public static final String ERROR_NOT_HAVE_POSITION_GROUP = "error.effort.notHavePositionGroup";
    public static final String ERROR_NOT_PAID_BY_FEDERAL_FUNDS = "error.effort.notPaidByFederalFunds";
    public static final String ERROR_NOT_PAID_BY_GRANT_ACCOUNT = "error.effort.notPaidByGrantAccount";
    public static final String ERROR_NOTE_REQUIRED_WHEN_APPROVED_EFFORT_CERTIFICATION_EXIST =
            "error.effort.noteRequiredWhenApprovedEffortCertificationExist";
    public static final String ERROR_NOTE_REQUIRED_WHEN_EFFORT_CHANGED = "error.effort.noteRequiredWhenEffortChanged";
    public static final String ERROR_PAYROLL_AMOUNT_OVER_CHANGED = "error.effort.payrollAmountOverChanged";
    public static final String ERROR_PENDING_EFFORT_CERTIFICATION_EXIST = "error.effort.pendingEffortCertificationExist";
    public static final String ERROR_PENDING_SALARY_EXPENSE_TRANSFER_EXIST =
            "error.effort.pendingSalaryExpenseTransferExist";
    public static final String ERROR_REPORT_DEFINITION_INACTIVE = "error.effort.reportDefinitionInactive";
    public static final String ERROR_REPORT_DEFINITION_NOT_EXIST = "error.effort.reportDefinitionNotExist";
    public static final String ERROR_REPORT_DEFINITION_PERIOD_NOT_OPENED = "error.effort.reportDefinitionPeriodNotOpened";
    public static final String ERROR_REPORT_DOCUMENT_BUILD_NOT_EXIST = "error.effort.reportDocumentBuildNotExist";
    public static final String ERROR_REPORT_DOCUMENT_EXIST = "error.effort.reportDocumentExist";
    public static final String ERROR_REPORT_NUMBER_MISSING = "error.effort.reportNumberMissing";
    public static final String ERROR_TOTAL_EFFORT_PERCENTAGE_NOT_100 = "error.effort.totalEffortPercentageNot100";
    public static final String ERROR_TOTAL_PAYROLL_AMOUNT_OVER_CHANGED = "error.effort.totalPayrollAmountOverChanged";
    public static final String ERROR_ZERO_PAYROLL_AMOUNT = "error.effort.zeroPayrollAmount";
    public static final String INVALID_REPORT_BEGIN_PERIOD = "error.rptdefn.begin.period.invalid";
    public static final String INVALID_REPORT_END_PERIOD = "error.rptdefn.end.period.invalid";
    public static final String INVALID_EXPENSE_TRANSFER_PERIOD = "error.rptdefn.transfer.period.invalid";
    public static final String MESSAGE_CREATE_SET_DOCUMENT_DESCRIPTION = "message.effort.create.SETDocument.explanation";
    public static final String QUESTION_OVERLAPPING_REPORT_DEFINITION =
            "question.effort.effortCertificationReportDefinition.overlappingDefinitions";

    /**
     * Private Constructor since this is a constants class that should never be instantiated.
     */
    private EffortKeyConstants() {
    }
}
