/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec.businessobject;

import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.sys.KFSPropertyConstants;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.context.SpringContext;

import java.util.HashMap;
import java.util.Map;

public class OutstandingCertificationsByReport extends PersistableBusinessObjectBase {

    private Integer universityFiscalYear;
    private String effortCertificationReportNumber;
    private String chartOfAccountsCode;
    private String organizationCode;
    private Integer outstandingCertificationCount;

    private SystemOptions options;
    private EffortCertificationReportDefinition effortCertificationReportDefinition;
    private Chart chart;
    private Organization organization;

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(final String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getEffortCertificationReportNumber() {
        return effortCertificationReportNumber;
    }

    public void setEffortCertificationReportNumber(final String effortCertificationReportNumber) {
        this.effortCertificationReportNumber = effortCertificationReportNumber;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(final String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public Integer getOutstandingCertificationCount() {
        return outstandingCertificationCount;
    }

    public void setOutstandingCertificationCount(final Integer outstandingCertificationCount) {
        this.outstandingCertificationCount = outstandingCertificationCount;
    }

    public Integer getUniversityFiscalYear() {
        return universityFiscalYear;
    }

    public void setUniversityFiscalYear(final Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    public SystemOptions getOptions() {
        return options;
    }

    public void setOptions(final SystemOptions options) {
        this.options = options;
    }

    public EffortCertificationReportDefinition getEffortCertificationReportDefinition() {
        return effortCertificationReportDefinition;
    }

    public void setEffortCertificationReportDefinition(
            final EffortCertificationReportDefinition effortCertificationReportDefinition) {
        this.effortCertificationReportDefinition = effortCertificationReportDefinition;
    }

    public Organization getOrganization() {
        return organization;
    }

    public void setOrganization(final Organization organization) {
        this.organization = organization;
    }

    public Chart getChart() {
        final Map<String, String> objectKeys = new HashMap<>();
        objectKeys.put(KFSPropertyConstants.CHART_OF_ACCOUNTS_CODE, getChartOfAccountsCode());
        return SpringContext.getBean(BusinessObjectService.class).findByPrimaryKey(Chart.class, objectKeys);
    }

    public void setChart(final Chart chart) {
        this.chart = chart;
    }

}
