/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec.businessobject.options;

import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.document.web.struts.CertificationReportForm;
import org.kuali.kfs.core.api.util.ConcreteKeyValue;
import org.kuali.kfs.core.api.util.KeyValue;

import java.util.ArrayList;
import java.util.List;

public class PositionNumberValuesFinder extends KeyValuesBase {

    @Override
    public List<KeyValue> getKeyValues() {
        final CertificationReportForm form = (CertificationReportForm) KNSGlobalVariables.getKualiForm();
        final EffortCertificationDocument document = (EffortCertificationDocument) form.getDocument();
        final List<KeyValue> keyValues = new ArrayList<>();
        final List<String> positionNumberList = document.getPositionList();
        for (final String positionNumber : positionNumberList) {
            keyValues.add(new ConcreteKeyValue(positionNumber, positionNumber));
        }

        return keyValues;
    }

}
