/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec.document.validation.event;

import org.kuali.kfs.krad.rules.rule.BusinessRule;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEventBase;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.module.ec.document.validation.LoadDetailLineRule;

public class LoadDetailLineEvent extends KualiDocumentEventBase {

    private final EffortCertificationDocument effortCertificationDocument;

    /**
     * @param description
     * @param errorPathPrefix
     * @param effortCertificationDocument
     */
    public LoadDetailLineEvent(
            final String description, final String errorPathPrefix,
            final EffortCertificationDocument effortCertificationDocument) {
        super(description, errorPathPrefix, effortCertificationDocument);
        document = effortCertificationDocument;
        this.effortCertificationDocument = effortCertificationDocument;
    }

    @Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
        return LoadDetailLineRule.class;
    }

    @Override
    public boolean invokeRuleMethod(final BusinessRule rule) {
        return ((LoadDetailLineRule<EffortCertificationDocument>) rule)
                .processLoadDetailLineRules(effortCertificationDocument);
    }
}
