/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec.document.web.struts;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ec.EffortConstants;
import org.kuali.kfs.module.ec.EffortPropertyConstants;
import org.kuali.kfs.module.ec.document.EffortCertificationDocument;
import org.kuali.kfs.sys.KFSPropertyConstants;
import org.kuali.kfs.sys.context.SpringContext;

import java.util.ArrayList;
import java.util.List;

/**
 * To define an action form for effort certification recreate process
 */
public class CertificationRecreateForm extends EffortCertificationForm {

    protected String emplid;
    protected String personName;
    protected Integer universityFiscalYear;
    protected String effortCertificationReportNumber;

    public CertificationRecreateForm() {
        super();
    }

    protected List<String> getImportingFields() {
        final List<String> importingFields = new ArrayList<>();
        importingFields.add(KFSPropertyConstants.EMPLID);
        importingFields.add(KFSPropertyConstants.UNIVERSITY_FISCAL_YEAR);
        importingFields.add(EffortPropertyConstants.EFFORT_CERTIFICATION_REPORT_NUMBER);
        return importingFields;
    }

    /**
     * validate the importing field values
     *
     * @return true if the importing field values are valid; otherwise, add errors into error map and return false
     */
    public boolean validateImportingFieldValues(final EffortCertificationDocument document) {
        final DictionaryValidationService dictionaryValidationService =
                SpringContext.getBean(DictionaryValidationService.class);

        for (final String fieldName : getImportingFields()) {
            dictionaryValidationService.validateDocumentAttribute(document, fieldName,
                    EffortConstants.DOCUMENT_PREFIX);
        }

        return !GlobalVariables.getMessageMap().hasErrors();
    }

    /**
     * force the input data as upper case
     */
    public void forceInputAsUpperCase() {
        final String reportNumber = getEffortCertificationReportNumber();
        setEffortCertificationReportNumber(StringUtils.upperCase(reportNumber));
    }

    public String getEmplid() {
        return emplid;
    }

    public void setEmplid(final String emplid) {
        this.emplid = emplid;
    }

    public Integer getUniversityFiscalYear() {
        return universityFiscalYear;
    }

    public void setUniversityFiscalYear(final Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    public String getEffortCertificationReportNumber() {
        return effortCertificationReportNumber;
    }

    public void setEffortCertificationReportNumber(final String effortCertificationReportNumber) {
        this.effortCertificationReportNumber = effortCertificationReportNumber;
    }

    public String getName() {
        return personName;
    }

    public void setName(final String personName) {
        this.personName = personName;
    }
}

