/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ec.util;

import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.kim.api.identity.Person;

/**
 * To hold the necessary information of ledger balance for the report generation
 */
public class LedgerBalanceWithMessage {

    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String financialObjectCode;
    private String positionNumber;
    private String employeeName;
    private String emplid;
    private String message;

    public LedgerBalanceWithMessage() {
        this(KFSConstants.EMPTY_STRING, KFSConstants.EMPTY_STRING, KFSConstants.EMPTY_STRING);
    }

    /**
     * @param emplid       the given employee id
     * @param employeeName the given employee name
     * @param message      the message associated with the given ledger balance
     */
    public LedgerBalanceWithMessage(String emplid, String employeeName, String message) {
        super();
        this.chartOfAccountsCode = KFSConstants.EMPTY_STRING;
        this.accountNumber = KFSConstants.EMPTY_STRING;
        this.subAccountNumber = KFSConstants.EMPTY_STRING;
        this.financialObjectCode = KFSConstants.EMPTY_STRING;
        this.positionNumber = KFSConstants.EMPTY_STRING;
        this.emplid = emplid;
        this.employeeName = employeeName;
        this.message = message;
    }

    /**
     * @param ledgerBalance the given ledger balance
     * @param message       the message associated with the given ledger balance
     */
    public LedgerBalanceWithMessage(LaborLedgerBalance ledgerBalance, String message) {
        super();
        this.chartOfAccountsCode = ledgerBalance.getChartOfAccountsCode();
        this.accountNumber = ledgerBalance.getAccountNumber();
        this.subAccountNumber = ledgerBalance.getSubAccountNumber();
        this.financialObjectCode = ledgerBalance.getFinancialObjectCode();
        this.positionNumber = ledgerBalance.getPositionNumber();
        this.emplid = ledgerBalance.getEmplid();
        this.message = message;

        Person employee = ledgerBalance.getLedgerPerson();
        this.employeeName = employee != null ? employee.getName() : KFSConstants.EMPTY_STRING;
    }

    public String getChartOfAccountsCode() {
        return chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getSubAccountNumber() {
        return subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getFinancialObjectCode() {
        return financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getPositionNumber() {
        return positionNumber;
    }

    public void setPositionNumber(String positionNumber) {
        this.positionNumber = positionNumber;
    }

    public String getEmplid() {
        return emplid;
    }

    public void setEmplid(String emplid) {
        this.emplid = emplid;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        return "[chartOfAccountsCode=" + this.getChartOfAccountsCode() + ", " + "accountNumber=" +
                this.getAccountNumber() + ", " + "subAccountNumber=" + this.getSubAccountNumber() + ", " +
                "financialObjectCode=" + this.getFinancialObjectCode() + ", " + "positionNumber=" +
                this.getPositionNumber() + ", " + "emplid=" + this.getEmplid() + ", " + "employeeName=" +
                this.getEmployeeName() + ", " + "message=" + this.getMessage() + "]";
    }
}

