/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.AwardAccount;
import org.kuali.kfs.module.external.kc.dto.AwardAccountDTO;
import org.kuali.kfs.module.external.kc.service.ExternalizableBusinessObjectService;
import org.kuali.kfs.module.external.kc.webService.AwardAccountSoapService;
import org.kuali.kra.external.award.AwardAccountService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class AwardAccountServiceImpl
implements ExternalizableBusinessObjectService {
    protected static Logger LOG = Logger.getLogger(AwardAccountServiceImpl.class);

    protected AwardAccountService getWebService() {
        AwardAccountService awardAccountService = (AwardAccountService)GlobalResourceLoader.getService((QName)KcConstants.AwardAccount.SERVICE);
        if (awardAccountService == null) {
            LOG.warn((Object)"Couldn't get AwardAccountService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            AwardAccountSoapService soapService = null;
            try {
                soapService = new AwardAccountSoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error((Object)("Could not intialize AwardAccountSoapService: " + ex.getMessage()));
                throw new RuntimeException("Could not intialize AwardAccountSoapService: " + ex.getMessage());
            }
            awardAccountService = soapService.getAwardAccountServicePort();
        }
        return awardAccountService;
    }

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        Collection ebos = this.findMatching(primaryKeys);
        if (ebos != null && ebos.iterator().hasNext()) {
            return (ExternalizableBusinessObject)ebos.iterator().next();
        }
        return null;
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        String chartOfAccountsCode;
        String accountNumber = (String)fieldValues.get("accountNumber");
        if (StringUtils.isBlank((String)accountNumber)) {
            accountNumber = null;
        }
        if (StringUtils.isBlank((String)(chartOfAccountsCode = (String)fieldValues.get("chartOfAccountsCode")))) {
            chartOfAccountsCode = null;
        }
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        List<AwardAccountDTO> awardAccountDTOs = null;
        try {
            awardAccountDTOs = this.getWebService().getAwardAccounts(accountNumber, chartOfAccountsCode);
        }
        catch (WebServiceException ex) {
            LOG.error((Object)("Could not retrieve award accounts: " + ex.getMessage()));
        }
        if (awardAccountDTOs != null && !awardAccountDTOs.isEmpty()) {
            AwardAccount awardAccountInfo = null;
            for (AwardAccountDTO awardAccount : awardAccountDTOs) {
                if (!StringUtils.isEmpty((String)awardAccount.getErrorMessage())) continue;
                awardAccountInfo = new AwardAccount(awardAccount, accountNumber, chartOfAccountsCode, "");
                awardAccounts.add(awardAccountInfo);
            }
        }
        return awardAccounts;
    }
}

