/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.BillingFrequency;
import org.kuali.kfs.module.external.kc.businessobject.BillingFrequencyMapping;
import org.kuali.kfs.module.external.kc.dto.FrequencyDto;
import org.kuali.kfs.module.external.kc.service.BillingFrequencyService;
import org.kuali.kfs.module.external.kc.service.ExternalizableBusinessObjectService;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.webService.FrequencyWebSoapService;
import org.kuali.kra.external.frequency.FrequencyWebService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class BillingFrequencyServiceImpl
implements ExternalizableBusinessObjectService,
BillingFrequencyService {
    protected static Logger LOG = Logger.getLogger(BillingFrequencyServiceImpl.class);
    protected BusinessObjectService businessObjectService;
    protected ConfigurationService configurationService;

    protected FrequencyWebService getWebService() {
        FrequencyWebService frequencyWebService = (FrequencyWebService)GlobalResourceLoader.getService((QName)KcConstants.Frequency.SERVICE);
        if (frequencyWebService == null) {
            LOG.warn((Object)"Couldn't get FrequencyWebService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            FrequencyWebSoapService ss = null;
            try {
                ss = new FrequencyWebSoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error((Object)("Could not intialize AwardWebSoapService: " + ex.getMessage()));
                throw new RuntimeException("Could not intialize AwardWebSoapService: " + ex.getMessage());
            }
            frequencyWebService = ss.getFrequencyWebServicePort();
        }
        return frequencyWebService;
    }

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        FrequencyDto dto = this.getWebService().getFrequency((String)primaryKeys.get("frequency"));
        return this.createBillingFrequency(dto);
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        List<FrequencyDto> result = null;
        try {
            result = fieldValues.isEmpty() ? this.getWebService().findAll() : this.getWebService().findMatching((String)fieldValues.get("frequency"), (String)fieldValues.get("frequencyDescription"));
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        if (result == null) {
            return new ArrayList();
        }
        return this.createBillingFrequency(result);
    }

    @Override
    public BillingFrequency createBillingFrequency(FrequencyDto kcFrequency) {
        if (kcFrequency != null) {
            return this.createBillingFrequency(kcFrequency, this.getFrequencyMapping(kcFrequency.getFrequencyCode()));
        }
        return null;
    }

    protected List<BillingFrequency> createBillingFrequency(List<FrequencyDto> kcFrequencies) {
        ArrayList<BillingFrequency> result = new ArrayList<BillingFrequency>();
        for (FrequencyDto dto : kcFrequencies) {
            BillingFrequencyMapping mapping = this.getFrequencyMapping(dto.getFrequencyCode());
            if (mapping == null) continue;
            result.add(this.createBillingFrequency(dto, mapping));
        }
        return result;
    }

    protected BillingFrequency createBillingFrequency(FrequencyDto kcFrequency, BillingFrequencyMapping mapping) {
        BillingFrequency freq = new BillingFrequency();
        freq.setKcFrequencyCode(kcFrequency.getFrequencyCode());
        freq.setFrequencyDescription(kcFrequency.getDescription());
        if (mapping != null) {
            freq.setFrequency(mapping.getFrequency());
            freq.setGracePeriodDays(mapping.getGracePeriodDays());
            freq.setActive(mapping.isActive());
        } else {
            freq.setActive(false);
        }
        return freq;
    }

    protected BillingFrequencyMapping getFrequencyMapping(String kcFrequencyCode) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("kcFrequencyCode", kcFrequencyCode);
        Collection mappings = this.getBusinessObjectService().findMatching(BillingFrequencyMapping.class, values);
        if (mappings != null && !mappings.isEmpty()) {
            return (BillingFrequencyMapping)((Object)mappings.iterator().next());
        }
        return null;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

