/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.LetterOfCreditFundGroup;
import org.kuali.kfs.module.external.kc.dto.AwardBasisOfPaymentDTO;
import org.kuali.kfs.module.external.kc.service.ExternalizableBusinessObjectService;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.webService.AwardPaymentWebSoapService;
import org.kuali.kra.external.awardpayment.AwardPaymentWebService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class LetterOfCreditFundGroupServiceImpl
implements ExternalizableBusinessObjectService {
    protected static Logger LOG = Logger.getLogger(LetterOfCreditFundGroupServiceImpl.class);
    protected ConfigurationService configurationService;

    protected AwardPaymentWebService getWebService() {
        AwardPaymentWebService awardPaymentWebService = (AwardPaymentWebService)GlobalResourceLoader.getService((QName)KcConstants.AwardPayment.SERVICE);
        if (awardPaymentWebService == null) {
            LOG.warn((Object)"Couldn't get AwardWebService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            AwardPaymentWebSoapService ss = null;
            try {
                ss = new AwardPaymentWebSoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error((Object)("Could not intialize AwardPaymentWebSoapService: " + ex.getMessage()));
                throw new RuntimeException("Could not intialize AwardPaymentWebSoapService: " + ex.getMessage());
            }
            awardPaymentWebService = ss.getAwardPaymentWebServicePort();
        }
        return awardPaymentWebService;
    }

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        AwardBasisOfPaymentDTO dto = this.getWebService().getBasisOfPayment((String)primaryKeys.get("letterOfCreditFundGroupCode"));
        return this.fundGroupFromDTO(dto);
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        AwardBasisOfPaymentDTO criteria = new AwardBasisOfPaymentDTO();
        List<AwardBasisOfPaymentDTO> result = null;
        criteria.setBasisOfPaymentCode((String)fieldValues.get("letterOfCreditFundGroupCode"));
        criteria.setDescription((String)fieldValues.get("letterOfCreditFundGroupDescription"));
        try {
            result = this.getWebService().getMatchingBasisOfPayments(criteria);
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        ArrayList<LetterOfCreditFundGroup> basises = new ArrayList<LetterOfCreditFundGroup>();
        if (result != null) {
            for (AwardBasisOfPaymentDTO dto : result) {
                basises.add(this.fundGroupFromDTO(dto));
            }
        }
        return basises;
    }

    protected LetterOfCreditFundGroup fundGroupFromDTO(AwardBasisOfPaymentDTO basis) {
        LetterOfCreditFundGroup fundGroup = new LetterOfCreditFundGroup();
        fundGroup.setLetterOfCreditFundGroupCode(basis.getBasisOfPaymentCode());
        fundGroup.setLetterOfCreditFundGroupDescription(basis.getDescription());
        return fundGroup;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

