/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.external.kc.service.ExternalizableBusinessObjectService;
import org.kuali.kfs.module.external.kc.service.impl.KcFinancialSystemModuleConfiguration;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsModuleServiceImpl;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class KcKfsModuleServiceImpl
extends KfsModuleServiceImpl {
    protected static final Logger LOG = Logger.getLogger(KcKfsModuleServiceImpl.class);
    protected DataDictionaryService dataDictionaryService;
    protected ConfigurationService configurationService;

    public <T extends ExternalizableBusinessObject> T getExternalizableBusinessObject(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        Class implementationClass = this.getExternalizableBusinessObjectImplementation(businessObjectClass);
        return (T)this.getExternalizableBusinessObjectService(implementationClass).findByPrimaryKey(fieldValues);
    }

    public <T extends ExternalizableBusinessObject> List<T> getExternalizableBusinessObjectsList(Class<T> businessObjectClass, Map<String, Object> fieldValues) {
        Class implementationClass = this.getExternalizableBusinessObjectImplementation(businessObjectClass);
        return (List)this.getExternalizableBusinessObjectService(implementationClass).findMatching(fieldValues);
    }

    private ExternalizableBusinessObjectService getExternalizableBusinessObjectService(Class clazz) {
        String serviceName = null;
        ExternalizableBusinessObjectService eboService = null;
        Map<Class, String> externalizableBusinessObjectServices = ((KcFinancialSystemModuleConfiguration)this.getModuleConfiguration()).getExternalizableBusinessObjectServiceImplementations();
        if (ObjectUtils.isNotNull(externalizableBusinessObjectServices) && ObjectUtils.isNotNull((Object)clazz)) {
            serviceName = externalizableBusinessObjectServices.get(clazz);
            eboService = (ExternalizableBusinessObjectService)SpringContext.getService((String)serviceName);
        }
        return eboService;
    }

    public List listPrimaryKeyFieldNames(Class businessObjectInterfaceClass) {
        Class clazz = this.getExternalizableBusinessObjectImplementation(businessObjectInterfaceClass);
        BusinessObjectEntry boEntry = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(clazz.getName());
        if (boEntry == null) {
            return null;
        }
        return boEntry.getPrimaryKeys();
    }

    protected String getInquiryUrl(Class inquiryBusinessObjectClass) {
        String baseUrl = this.configurationService.getPropertyValueAsString("kc.application.url");
        String inquiryUrl = baseUrl;
        if (!inquiryUrl.endsWith("/")) {
            inquiryUrl = inquiryUrl + "/";
        }
        return inquiryUrl + "kr/" + "inquiry.do";
    }

    protected Properties getUrlParameters(String businessObjectClassAttribute, Map<String, String[]> parameters) {
        Properties urlParameters = new Properties();
        String paramNameToConvert = null;
        Map<String, String> kfsToKcInquiryUrlParameterMapping = ((KcFinancialSystemModuleConfiguration)this.getModuleConfiguration()).getKfsToKcInquiryUrlParameterMapping();
        Map<String, String> kfsToKcInquiryUrlClassMapping = ((KcFinancialSystemModuleConfiguration)this.getModuleConfiguration()).getKfsToKcInquiryUrlClassMapping();
        Iterator<String> iterator = parameters.keySet().iterator();
        while (iterator.hasNext()) {
            String paramName;
            String parameterName = paramName = iterator.next();
            String[] parameterValues = parameters.get(paramName);
            if (parameterValues.length <= 0) continue;
            paramNameToConvert = businessObjectClassAttribute + "." + paramName;
            if (kfsToKcInquiryUrlParameterMapping.containsKey(paramNameToConvert)) {
                parameterName = kfsToKcInquiryUrlParameterMapping.get(paramNameToConvert);
            }
            urlParameters.put(parameterName, parameterValues[0]);
        }
        urlParameters.put("businessObjectClassName", kfsToKcInquiryUrlClassMapping.get(businessObjectClassAttribute));
        urlParameters.put("methodToCall", "continueWithInquiry");
        return urlParameters;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

