/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.AwardAccount;
import org.kuali.kfs.module.external.kc.service.ExternalizableBusinessObjectService;
import org.kuali.kfs.module.external.kc.webService.InstitutionalUnitSoapService;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kra.external.unit.service.InstitutionalUnitService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

@NonTransactional
public class ContractsAndGrantsModuleServiceImpl
implements ContractsAndGrantsModuleService {
    private Logger LOG = Logger.getLogger(ContractsAndGrantsModuleServiceImpl.class);
    protected BusinessObjectService businessObjectService;
    protected ExternalizableBusinessObjectService awardAccountService;
    protected PersonService personService;
    protected ParameterService parameterService;

    protected List<AwardAccount> getAwardAccounts(String chartCode, String accountNumber) {
        HashMap<String, String> objectKeys = new HashMap<String, String>();
        if (chartCode != null && !chartCode.isEmpty()) {
            objectKeys.put("chartOfAccountsCode", chartCode);
        }
        objectKeys.put("accountNumber", accountNumber);
        List awardAccountDTOs = (List)this.awardAccountService.findMatching(objectKeys);
        return awardAccountDTOs;
    }

    protected InstitutionalUnitService getInstitutionalUnitWebService() {
        InstitutionalUnitService institutionalUnitService = (InstitutionalUnitService)GlobalResourceLoader.getService((QName)KcConstants.Unit.SERVICE);
        if (institutionalUnitService == null) {
            InstitutionalUnitSoapService institutionalUnitSoapService = null;
            try {
                institutionalUnitSoapService = new InstitutionalUnitSoapService();
            }
            catch (MalformedURLException ex) {
                this.LOG.error((Object)("Could not intialize InstitutionalUnitSoapService: " + ex.getMessage()));
                throw new RuntimeException("Could not intialize InstitutionalUnitSoapService: " + ex.getMessage());
            }
            institutionalUnitService = institutionalUnitSoapService.getInstitutionalUnitServicePort();
        }
        return institutionalUnitService;
    }

    public List<String> getParentUnits(String unitNumber) {
        List<String> parentUnits = this.getInstitutionalUnitWebService().getParentUnits(unitNumber);
        return parentUnits;
    }

    public Person getProjectDirectorForAccount(String chartOfAccountsCode, String accountNumber) {
        List<AwardAccount> awardAccountDTOs = this.getAwardAccounts(chartOfAccountsCode, accountNumber);
        AwardAccount awardAccount = this.determineAwardAccountForProjectDirector(awardAccountDTOs);
        if (awardAccount == null) {
            return null;
        }
        String projectDirectorId = awardAccount.getPrincipalId();
        this.LOG.debug((Object)("getProjectDirectorForAccount Web Service sent " + chartOfAccountsCode + "/" + accountNumber + " got " + projectDirectorId));
        if (projectDirectorId != null) {
            Person projectDirector = this.personService.getPerson(projectDirectorId);
            return projectDirector;
        }
        return null;
    }

    protected AwardAccount determineAwardAccountForProjectDirector(List<AwardAccount> awardAccounts) {
        AwardAccount awardAccountReturn = null;
        if (ObjectUtils.isNotNull(awardAccounts)) {
            Collections.sort(awardAccounts, new Comparator<AwardAccount>(){

                @Override
                public int compare(AwardAccount o1, AwardAccount o2) {
                    String awardId1 = String.valueOf(o1.getAward().getProposalNumber());
                    String awardId2 = String.valueOf(o2.getAward().getProposalNumber());
                    return awardId2.compareTo(awardId1);
                }
            });
        }
        if (ObjectUtils.isNotNull(awardAccounts) && !awardAccounts.isEmpty()) {
            for (AwardAccount awardAccount : awardAccounts) {
                if (!StringUtils.isNotBlank((String)awardAccount.getPrincipalId())) continue;
                awardAccountReturn = awardAccount;
                break;
            }
        }
        return awardAccountReturn;
    }

    public Person getProjectDirectorForAccount(Account account) {
        if (account != null) {
            String chartOfAccountsCode = account.getChartOfAccountsCode();
            String accountNumber = account.getAccountNumber();
            return this.getProjectDirectorForAccount(chartOfAccountsCode, accountNumber);
        }
        return null;
    }

    public boolean isAwardedByFederalAgency(String chartOfAccountsCode, String accountNumber, Collection<String> federalAgencyTypeCodes) {
        boolean _isFederalSponsor_return = false;
        Object federalSponsorTypeCodes = null;
        List<AwardAccount> awardAccounts = this.getAwardAccounts(chartOfAccountsCode, accountNumber);
        AwardAccount awardAccount = this.determineAwardAccountForFederalAgency(awardAccounts);
        if (ObjectUtils.isNotNull((Object)awardAccount)) {
            _isFederalSponsor_return = awardAccount.isFederalSponsor();
        }
        this.LOG.debug((Object)("isAwardedByFederalAgency" + accountNumber + " got " + _isFederalSponsor_return));
        return _isFederalSponsor_return;
    }

    protected AwardAccount determineAwardAccountForFederalAgency(List<AwardAccount> awardAccounts) {
        AwardAccount awardAccountReturn;
        block1: {
            AwardAccount awardAccount;
            Iterator<AwardAccount> iterator;
            awardAccountReturn = null;
            if (ObjectUtils.isNotNull(awardAccounts)) {
                Collections.sort(awardAccounts, new Comparator<AwardAccount>(){

                    @Override
                    public int compare(AwardAccount o1, AwardAccount o2) {
                        String awardId1 = String.valueOf(o1.getProposalNumber());
                        String awardId2 = String.valueOf(o2.getProposalNumber());
                        return awardId2.compareTo(awardId1);
                    }
                });
            }
            if (!ObjectUtils.isNotNull(awardAccounts) || awardAccounts.isEmpty() || !(iterator = awardAccounts.iterator()).hasNext()) break block1;
            awardAccountReturn = awardAccount = iterator.next();
        }
        return awardAccountReturn;
    }

    public List<Integer> getAllAccountReponsiblityIds() {
        int maxResponsibilityId = this.getMaxiumAccountResponsibilityId();
        ArrayList<Integer> contractsAndGrantsReponsiblityIds = new ArrayList<Integer>();
        for (int id = 1; id <= maxResponsibilityId; ++id) {
            contractsAndGrantsReponsiblityIds.add(id);
        }
        return contractsAndGrantsReponsiblityIds;
    }

    public boolean hasValidAccountReponsiblityIdIfNotNull(Account account) {
        Integer accountResponsiblityId = account.getContractsAndGrantsAccountResponsibilityId();
        if (accountResponsiblityId == null) {
            return true;
        }
        return accountResponsiblityId >= 1 && accountResponsiblityId <= this.getMaxiumAccountResponsibilityId();
    }

    public String getProposalNumberForAccountAndProjectDirector(String chartOfAccountsCode, String accountNumber, String projectDirectorId) {
        String proposalNumber = null;
        String awardProjectDirectorId = null;
        List<AwardAccount> awardAccountDTOs = this.getAwardAccounts(chartOfAccountsCode, accountNumber);
        AwardAccount awardAccount = this.determineAwardAccountForProjectDirector(awardAccountDTOs);
        if (ObjectUtils.isNotNull((Object)awardAccount)) {
            awardProjectDirectorId = awardAccount.getPrincipalId();
            this.LOG.debug((Object)("getProjectDirectorForAccount Web Service sent " + chartOfAccountsCode + "/" + accountNumber + " got " + StringUtils.trimToEmpty((String)awardProjectDirectorId)));
            if (StringUtils.equalsIgnoreCase((String)StringUtils.trimToEmpty((String)awardProjectDirectorId), (String)StringUtils.trimToEmpty((String)projectDirectorId)) && ObjectUtils.isNotNull((Object)awardAccount.getAward())) {
                proposalNumber = awardAccount.getAward().getProposalNumber();
            }
        }
        return proposalNumber;
    }

    protected int getMaxiumAccountResponsibilityId() {
        String maxResponsibilityId = this.getParameterService().getParameterValueAsString(KfsParameterConstants.CHART_ALL.class, "MAXIMUM_ACCOUNT_RESPONSIBILITY_ID");
        return Integer.valueOf(maxResponsibilityId);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ExternalizableBusinessObjectService getAwardAccountService() {
        return this.awardAccountService;
    }

    public void setAwardAccountService(ExternalizableBusinessObjectService awardAccountService) {
        this.awardAccountService = awardAccountService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

