/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.businessobject;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.module.external.kc.businessobject.Agency;
import org.kuali.kfs.module.external.kc.businessobject.AgencyAddress;
import org.kuali.kra.external.sponsor.RolodexDTO;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;

public class AgencyAddressTest {
    private AgencyAddress agencyAddress;
    private CountryService countryService;

    @Before
    public void setUp() throws Exception {
        this.countryService = (CountryService)EasyMock.createMock(CountryService.class);
    }

    @Test
    public void testNullCountryCode() {
        EasyMock.expect((Object)this.countryService.getDefaultCountry()).andReturn((Object)this.getDefaultCountry());
        EasyMock.replay((Object[])new Object[]{this.countryService});
        this.agencyAddress = new AgencyAddress();
        this.agencyAddress.setCountryService(this.countryService);
        this.agencyAddress.init(this.getAgency(), this.getRolodexDto());
        EasyMock.verify((Object[])new Object[]{this.countryService});
    }

    @Test
    public void testValidCountryCode() {
        EasyMock.expect((Object)this.countryService.getDefaultCountry()).andReturn((Object)this.getDefaultCountry());
        EasyMock.expect((Object)this.countryService.getCountryByAlternateCode("USA")).andReturn((Object)this.getDefaultCountry());
        EasyMock.replay((Object[])new Object[]{this.countryService});
        this.agencyAddress = new AgencyAddress();
        this.agencyAddress.setCountryService(this.countryService);
        RolodexDTO rolodexDto = this.getRolodexDto();
        rolodexDto.setCountryCode("USA");
        this.agencyAddress.init(this.getAgency(), rolodexDto);
        Assert.assertTrue((String)"Country code should be US.", (boolean)"US".equals(this.agencyAddress.getAgencyCountryCode()));
        EasyMock.verify((Object[])new Object[]{this.countryService});
    }

    private Country getDefaultCountry() {
        Country.Builder cb = Country.Builder.create((String)"US", (String)"USA", (String)"United States", (boolean)false, (boolean)true);
        return cb.build();
    }

    private RolodexDTO getRolodexDto() {
        RolodexDTO r = new RolodexDTO();
        r.setRolodexId(Integer.valueOf(1));
        return r;
    }

    private Agency getAgency() {
        Agency a = new Agency();
        return a;
    }
}

