/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service;

import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import junit.framework.TestCase;
import org.kuali.kfs.integration.cg.dto.AccountCreationStatusDTO;
import org.kuali.kfs.integration.cg.dto.AccountParametersDTO;
import org.kuali.kfs.module.external.kc.service.AccountCreationService;
import org.kuali.kfs.module.external.kc.service.impl.AccountCreationServiceImpl;

public class AccountCreationServiceClient
extends TestCase {
    private AccountParametersDTO accountParameters;
    private AccountCreationService accountCreationService;

    protected void setUp() throws Exception {
        this.accountCreationService = new AccountCreationServiceImpl();
        this.accountParameters = new AccountParametersDTO();
        this.accountParameters.setUnit("BL");
        this.accountParameters.setAccountNumber("1234572");
        this.accountParameters.setAccountName("KC Award");
        this.accountParameters.setHigherEdFunctionCode("IPR");
        this.accountParameters.setIndirectCostTypeCode("");
        this.accountParameters.setIndirectCostRate("");
        this.accountParameters.setExpenseGuidelineText("expenseGuidelineText");
        this.accountParameters.setIncomeGuidelineText("incomeGuidelineText");
        this.accountParameters.setPurposeText("purposeText");
        this.accountParameters.setCfdaNumber("");
        this.accountParameters.setDefaultAddressStreetAddress("1000 Main St");
        this.accountParameters.setDefaultAddressCityName("Cold Spring");
        this.accountParameters.setDefaultAddressStateCode("MD");
        this.accountParameters.setDefaultAddressZipCode("20090");
        this.accountParameters.setAdminContactAddressStreetAddress("1010 Main St");
        this.accountParameters.setAdminContactAddressCityName("Silver Spring");
        this.accountParameters.setAdminContactAddressStateCode("MD");
        this.accountParameters.setAdminContactAddressZipCode("20090");
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2012);
        cal.set(2, 11);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.accountParameters.setExpirationDate((Date)new java.sql.Date(cal.getTime().getTime()));
        cal.set(1, 2010);
        cal.set(2, 0);
        cal.set(5, 1);
        this.accountParameters.setEffectiveDate((Date)new java.sql.Date(cal.getTime().getTime()));
        this.accountParameters.setOffCampusIndicator(false);
        this.accountParameters.setPrincipalId("6162502038");
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreateAccountServiceSoap() {
        try {
            URL url = new URL("http://localhost:8080/kfs-dev/remoting/accountCreationServiceSOAP?wsdl");
            QName qName = new QName("KFS", "accountCreationServiceSOAP");
            Service service = Service.create((URL)url, (QName)qName);
            AccountCreationService accountService = (AccountCreationService)service.getPort(AccountCreationService.class);
            AccountCreationStatusDTO creationStatus = accountService.createAccount(this.accountParameters);
            System.out.println("account number: " + creationStatus.getAccountNumber());
            System.out.println("document number: " + creationStatus.getDocumentNumber());
            AccountCreationServiceClient.assertTrue((boolean)creationStatus.getStatus().equals("success"));
        }
        catch (Exception e) {
            System.out.println("error: " + e.getMessage());
        }
    }
}

