/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2017 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import org.apache.commons.collections.MapUtils;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.LetterOfCreditFundGroup;
import org.kuali.kfs.module.external.kc.service.ExternalizableBusinessObjectService;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.webService.LetterOfCreditFundWebSoapService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kra.external.locfund.LetterOfCreditFundGroupDto;
import org.kuali.kra.external.locfund.LetterOfCreditFundWebService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

import javax.xml.ws.WebServiceException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * This class was generated by Apache CXF 2.2.10
 * Thu Sep 30 05:29:28 HST 2010
 * Generated source version: 2.2.10
 */

public class LetterOfCreditFundGroupServiceImpl implements ExternalizableBusinessObjectService {
    protected static org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(LetterOfCreditFundServiceImpl.class);

    protected ConfigurationService configurationService;

    protected LetterOfCreditFundWebService getWebService() {
        // first attempt to get the service from the KSB - works when KFS & KC share a Rice instance
        LetterOfCreditFundWebService letterOfCreditFundWebService = GlobalResourceLoader.getService(KcConstants.LetterOfCreditFund.SERVICE);

        // if we couldn't get the service from the KSB, get as web service - for when KFS & KC have separate Rice instances
        if (letterOfCreditFundWebService == null) {
            LOG.warn("Couldn't get LetterOfCreditFundWebService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            LetterOfCreditFundWebSoapService ss;
            try {
                ss = new LetterOfCreditFundWebSoapService();
            } catch (MalformedURLException ex) {
                LOG.error("Could not intialize LetterOfCreditFundWebSoapService: " + ex.getMessage());
                throw new RuntimeException("Could not intialize LetterOfCreditFundWebSoapService: " + ex.getMessage());
            }
            letterOfCreditFundWebService = ss.getLetterOfCreditFundWebServicePort();
        }

        return letterOfCreditFundWebService;
    }

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        List<LetterOfCreditFundGroupDto> results = null;
        try {
            results = this.getWebService().findMatchingFundGroup((String) primaryKeys.get("groupCode"), (String) primaryKeys.get("description"));
        } catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError(KcConstants.WEBSERVICE_UNREACHABLE, getConfigurationService().getPropertyValueAsString(KFSConstants.KC_APPLICATION_URL_KEY));
        }
        if (results != null && results.size() > 0) {
            return fundFromDTO(results.get(0));
        }
        return null;
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        List<LetterOfCreditFundGroupDto> results = null;

        if (MapUtils.isEmpty(fieldValues)) {
            return findAll();
        }

        try {
            results = this.getWebService().findMatchingFundGroup((String) fieldValues.get("groupCode"),
                (String) fieldValues.get("description"));
        } catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError(KcConstants.WEBSERVICE_UNREACHABLE, getConfigurationService().getPropertyValueAsString(KFSConstants.KC_APPLICATION_URL_KEY));
        }

        List<LetterOfCreditFundGroup> fundGroups = new ArrayList<>();
        if (results != null) {
            for (LetterOfCreditFundGroupDto dto : results) {
                fundGroups.add(fundFromDTO(dto));
            }
        }
        return fundGroups;
    }

    public Collection findAll() {
        List<LetterOfCreditFundGroupDto> results = null;
        try {
            results = this.getWebService().allLocFundGroups();
        } catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError(KcConstants.WEBSERVICE_UNREACHABLE, getConfigurationService().getPropertyValueAsString(KFSConstants.KC_APPLICATION_URL_KEY));
        }

        List<LetterOfCreditFundGroup> fundGroups = new ArrayList<>();
        if (results != null) {
            for (LetterOfCreditFundGroupDto dto : results) {
                fundGroups.add(fundFromDTO(dto));
            }
        }
        return fundGroups;
    }

    protected LetterOfCreditFundGroup fundFromDTO(LetterOfCreditFundGroupDto dto) {
        LetterOfCreditFundGroup fundGroup = new LetterOfCreditFundGroup();
        fundGroup.setLetterOfCreditFundGroupCode(dto.getGroupCode());
        fundGroup.setLetterOfCreditFundGroupDescription(dto.getDescription());
        fundGroup.setActive(dto.isActive());
        return fundGroup;
    }

    public ConfigurationService getConfigurationService() {
        return configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

}
