/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.businessobject;

import java.sql.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.external.kc.businessobject.Agency;
import org.kuali.kfs.module.external.kc.businessobject.Award;
import org.kuali.kfs.module.external.kc.businessobject.Proposal;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kra.external.award.AwardAccountDTO;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class AwardAccount
implements ContractsAndGrantsBillingAwardAccount,
MutableInactivatable {
    private String proposalNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String principalId;
    private boolean active = true;
    private boolean newCollectionRecord;
    private boolean federalSponsor;
    private boolean finalBilledIndicator;
    private Date currentLastBilledDate;
    private Date previousLastBilledDate;
    private Account account;
    private Chart chartOfAccounts;
    private Person projectDirector;
    private Award award;

    public AwardAccount() {
    }

    public AwardAccount(AwardAccountDTO awardAccountDTO) {
        this.setAccountNumber(awardAccountDTO.getAccountNumber());
        this.setChartOfAccountsCode(awardAccountDTO.getChartOfAcccountsCode());
        this.setPrincipalId(awardAccountDTO.getProjectDirector());
        this.setProposalNumber(awardAccountDTO.getAwardNumber());
        this.setActive(true);
        this.setFederalSponsor(awardAccountDTO.isFederalSponsor());
        this.setFinalBilledIndicator(awardAccountDTO.isFinalBill());
        if (ObjectUtils.isNotNull((Object)awardAccountDTO.getLastBilledDate())) {
            this.setCurrentLastBilledDate(new Date(awardAccountDTO.getLastBilledDate().getTime()));
        }
        if (ObjectUtils.isNotNull((Object)awardAccountDTO.getPreviousLastBilledDate())) {
            this.setPreviousLastBilledDate(new Date(awardAccountDTO.getPreviousLastBilledDate().getTime()));
        }
        Award award = new Award();
        award.setAwardId(awardAccountDTO.getAwardId());
        award.setProposalNumber(awardAccountDTO.getAwardNumber());
        award.setAgencyNumber(awardAccountDTO.getSponsorCode());
        award.setAwardTitle(awardAccountDTO.getAwardTitle());
        award.setGrantNumber(awardAccountDTO.getGrantNumber());
        award.setCfdaNumber("");
        award.setAwardNumber(awardAccountDTO.getAwardNumber());
        Proposal proposal = new Proposal();
        proposal.setFederalPassThroughAgencyNumber(awardAccountDTO.getProposalFederalPassThroughAgencyNumber());
        proposal.setProposalNumber(awardAccountDTO.getAwardNumber());
        proposal.setAward(award);
        award.setProposal(proposal);
        Agency agency = new Agency();
        agency.setAgencyNumber(awardAccountDTO.getSponsorCode());
        agency.setReportingName(awardAccountDTO.getSponsorName());
        award.setAgency(agency);
        Agency primeAgency = new Agency();
        primeAgency.setAgencyNumber(awardAccountDTO.getPrimeSponsorCode());
        primeAgency.setReportingName(awardAccountDTO.getPrimeSponsorName());
        award.setPrimeAgency(primeAgency);
        this.setAward(award);
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public Chart getChartOfAccounts() {
        return this.chartOfAccounts;
    }

    @Deprecated
    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    public Person getProjectDirector() {
        this.projectDirector = ((PersonService)SpringContext.getBean(PersonService.class)).updatePersonIfNecessary(this.principalId, this.projectDirector);
        return this.projectDirector;
    }

    @Deprecated
    public void setProjectDirector(Person projectDirector) {
        this.projectDirector = projectDirector;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        if (this.proposalNumber != null) {
            m.put("proposalNumber", this.proposalNumber);
        }
        m.put("chartOfAccountsCode", this.chartOfAccountsCode);
        m.put("accountNumber", this.accountNumber);
        m.put("principalId", this.principalId);
        m.put("active", this.active);
        m.put("federalSponsor", this.federalSponsor);
        m.put("newCollectionRecord", this.newCollectionRecord);
        return m;
    }

    public Map<String, Object> getPrimaryKeys() {
        HashMap<String, Object> pks = new HashMap<String, Object>(2);
        pks.put("chartOfAccountsCode", this.chartOfAccountsCode);
        pks.put("accountNumber", this.accountNumber);
        return pks;
    }

    public Award getAward() {
        return this.award;
    }

    public void setAward(Award award) {
        this.award = award;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = true;
    }

    public String getProjectDirectorName() {
        if (!ObjectUtils.isNull((Object)this.getProjectDirector())) {
            return this.getProjectDirector().getName();
        }
        return null;
    }

    public void prepareForWorkflow() {
    }

    public void refresh() {
    }

    public boolean isNewCollectionRecord() {
        return false;
    }

    public void setNewCollectionRecord(boolean newCollectionRecord) {
        this.newCollectionRecord = newCollectionRecord;
    }

    public boolean isFederalSponsor() {
        return this.federalSponsor;
    }

    public void setFederalSponsor(boolean federalSponsor) {
        this.federalSponsor = federalSponsor;
    }

    public Date getCurrentLastBilledDate() {
        return this.currentLastBilledDate;
    }

    public void setCurrentLastBilledDate(Date currentLastBilledDate) {
        this.currentLastBilledDate = currentLastBilledDate;
    }

    public Date getPreviousLastBilledDate() {
        return this.previousLastBilledDate;
    }

    public void setPreviousLastBilledDate(Date previousLastBilledDate) {
        this.previousLastBilledDate = previousLastBilledDate;
    }

    public boolean isFinalBilledIndicator() {
        return this.finalBilledIndicator;
    }

    public void setFinalBilledIndicator(boolean finalBilledIndicator) {
        this.finalBilledIndicator = finalBilledIndicator;
    }
}

