/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.cg.dto.HashMapElement;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.InstrumentType;
import org.kuali.kfs.module.external.kc.service.ExternalizableBusinessObjectService;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.webService.AwardTypeWebSoapService;
import org.kuali.kra.external.awardtype.AwardTypeDTO;
import org.kuali.kra.external.awardtype.AwardTypeWebService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class AwardTypeServiceImpl
implements ExternalizableBusinessObjectService {
    protected static Logger LOG = Logger.getLogger(AwardTypeServiceImpl.class);
    protected ConfigurationService configurationService;

    protected AwardTypeWebService getWebService() {
        AwardTypeWebService awardTypeWebService = (AwardTypeWebService)GlobalResourceLoader.getService((QName)KcConstants.AwardType.SERVICE);
        if (awardTypeWebService == null) {
            LOG.warn((Object)"Couldn't get AwardWebService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            AwardTypeWebSoapService ss = null;
            try {
                ss = new AwardTypeWebSoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error((Object)("Could not intialize AwardTypeWebSoapService: " + ex.getMessage()));
                throw new RuntimeException("Could not intialize AwardTypeWebSoapService: " + ex.getMessage());
            }
            awardTypeWebService = ss.getAwardTypeWebServicePort();
        }
        return awardTypeWebService;
    }

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        AwardTypeDTO dto = this.getWebService().getAwardType((Integer)primaryKeys.get("instrumentTypeCode"));
        return this.typeFromDTO(dto);
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        ArrayList<HashMapElement> hashMapList = new ArrayList<HashMapElement>();
        List<AwardTypeDTO> result = null;
        for (Map.Entry e : fieldValues.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            HashMapElement hashMapElement = new HashMapElement();
            if (StringUtils.equals((String)key, (String)"instrumentTypeCode")) {
                hashMapElement.setKey("awardTypeCode");
                hashMapElement.setValue(val);
            } else if (StringUtils.equals((String)key, (String)"instrumentTypeDescription")) {
                hashMapElement.setKey("description");
                hashMapElement.setValue(val);
            }
            hashMapList.add(hashMapElement);
        }
        try {
            result = this.getWebService().findMatching(hashMapList);
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        if (result == null) {
            return new ArrayList();
        }
        ArrayList<InstrumentType> types = new ArrayList<InstrumentType>();
        for (AwardTypeDTO dto : result) {
            types.add(this.typeFromDTO(dto));
        }
        return types;
    }

    protected InstrumentType typeFromDTO(AwardTypeDTO awardType) {
        InstrumentType type = new InstrumentType();
        type.setInstrumentTypeCode(awardType.getAwardTypeCode().toString());
        type.setInstrumentTypeDescription(awardType.getDescription());
        return type;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

