/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.integration.cg.dto.HashMapElement;
import org.kuali.kfs.integration.cg.dto.KcObjectCode;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.external.kc.service.KcObjectCodeService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class KcObjectCodeServiceImpl
implements KcObjectCodeService {
    protected static Logger LOG = Logger.getLogger(KcObjectCodeServiceImpl.class);
    protected BusinessObjectService businessObjectService;
    protected ObjectCodeService objectCodeService;

    @Override
    public List<KcObjectCode> lookupObjectCodes(List<HashMapElement> searchCriteria) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List objCodeList = new ArrayList();
        if (searchCriteria == null || searchCriteria.size() == 0) {
            objCodeList = (List)this.businessObjectService.findAll(ObjectCode.class);
        } else {
            for (HashMapElement hashMapElement : searchCriteria) {
                hashMap.put(hashMapElement.getKey(), hashMapElement.getValue());
            }
            objCodeList = (List)this.businessObjectService.findMatching(ObjectCode.class, hashMap);
        }
        ArrayList<KcObjectCode> kcObjectCodeList = new ArrayList<KcObjectCode>();
        for (ObjectCode objectCode : objCodeList) {
            kcObjectCodeList.add(this.createKcObjectCode(objectCode));
        }
        return kcObjectCodeList;
    }

    @Override
    public KcObjectCode getObjectCode(String universityFiscalYear, String chartOfAccountsCode, String financialObjectCode) {
        Integer fiscalYear = new Integer(universityFiscalYear);
        ObjectCode objectCode = this.objectCodeService.getByPrimaryId(fiscalYear, chartOfAccountsCode, financialObjectCode);
        return this.createKcObjectCode(objectCode);
    }

    protected KcObjectCode createKcObjectCode(ObjectCode objectCode) {
        KcObjectCode kcObjectCode = new KcObjectCode();
        kcObjectCode.setObjectCodeName(objectCode.getCode());
        kcObjectCode.setDescription(objectCode.getName());
        return kcObjectCode;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ObjectCodeService getObjectCodeService() {
        return this.objectCodeService;
    }

    public void setObjectCodeService(ObjectCodeService objectCodeService) {
        this.objectCodeService = objectCodeService;
    }
}

