/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.Agency;
import org.kuali.kfs.module.external.kc.service.ExternalizableLookupableBusinessObjectService;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.webService.SponsorWebSoapService;
import org.kuali.kra.external.sponsor.SponsorCriteriaDto;
import org.kuali.kra.external.sponsor.SponsorDTO;
import org.kuali.kra.external.sponsor.SponsorWebService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class SponsorServiceImpl
implements ExternalizableLookupableBusinessObjectService {
    protected static Logger LOG = Logger.getLogger(SponsorServiceImpl.class);
    protected ConfigurationService configurationService;
    protected SponsorWebService sponsorWebService;

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        SponsorDTO dto = this.getWebService().getSponsor((String)primaryKeys.get("agencyNumber"));
        return new Agency(dto);
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        List<SponsorDTO> result = null;
        SponsorCriteriaDto criteria = new SponsorCriteriaDto();
        criteria.setSponsorCode((String)fieldValues.get("agencyNumber"));
        criteria.setCustomerNumber((String)fieldValues.get("customerNumber"));
        criteria.setSponsorName((String)fieldValues.get("reportingName"));
        criteria.setDunsPlusFourNumber((String)fieldValues.get("dunsPlusFourNumber"));
        criteria.setActive((String)fieldValues.get("active"));
        try {
            result = this.getWebService().getMatchingSponsors(criteria);
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        if (result == null) {
            return new ArrayList();
        }
        ArrayList<Agency> agencies = new ArrayList<Agency>();
        for (SponsorDTO dto : result) {
            agencies.add(new Agency(dto));
        }
        return agencies;
    }

    @Override
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        return new ArrayList(this.findMatching(fieldValues));
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected synchronized SponsorWebService getWebService() {
        if (this.sponsorWebService == null) {
            this.sponsorWebService = (SponsorWebService)GlobalResourceLoader.getService((QName)KcConstants.Sponsor.SERVICE);
            if (this.sponsorWebService == null) {
                LOG.warn((Object)"Couldn't get SponsorWebService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
                SponsorWebSoapService ss = null;
                try {
                    ss = new SponsorWebSoapService();
                }
                catch (MalformedURLException ex) {
                    LOG.error((Object)("Could not intialize SponsorWebSoapService: " + ex.getMessage()));
                    throw new RuntimeException("Could not intialize SponsorWebSoapService: " + ex.getMessage());
                }
                this.sponsorWebService = ss.getSponsorWebServicePort();
            }
        }
        return this.sponsorWebService;
    }

    public void setWebService(SponsorWebService webService) {
        this.sponsorWebService = webService;
    }
}

