/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.external.kc.businessobject.AccountAutoCreateDefaults;
import org.kuali.kfs.module.external.kc.service.AccountDefaultsService;
import org.kuali.kfs.module.external.kc.util.KcUtils;

public class AccountDefaultServiceImpl
implements AccountDefaultsService {
    private static final Logger LOG = LogManager.getLogger(AccountDefaultServiceImpl.class);
    protected BusinessObjectService businessObjectService;
    protected ContractsAndGrantsModuleService contractsAndGrantsModuleService;

    @Override
    public AccountAutoCreateDefaults getAccountDefaults(String unitNumber) {
        AccountAutoCreateDefaults defaults = null;
        if (unitNumber == null || unitNumber.isEmpty()) {
            return null;
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("kcUnit", unitNumber);
        defaults = (AccountAutoCreateDefaults)this.businessObjectService.findByPrimaryKey(AccountAutoCreateDefaults.class, criteria);
        if (defaults == null) {
            List parentUnits = null;
            try {
                parentUnits = this.contractsAndGrantsModuleService.getParentUnits(unitNumber);
            }
            catch (Exception ex) {
                LOG.error(KcUtils.getErrorMessage("error.kc.account.params.unit.notfound", null) + ": " + ex.getMessage());
                GlobalVariables.getMessageMap().putError("error.kc.account.params.unit.notfound", "kcUnit", new String[]{ex.getMessage()});
            }
            if (parentUnits != null) {
                for (String unit : parentUnits) {
                    criteria.put("kcUnit", unit);
                    defaults = (AccountAutoCreateDefaults)this.businessObjectService.findByPrimaryKey(AccountAutoCreateDefaults.class, criteria);
                    if (defaults == null) continue;
                    break;
                }
            }
        }
        return defaults;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ContractsAndGrantsModuleService getContractsAndGrantsModuleService() {
        return this.contractsAndGrantsModuleService;
    }

    public void setContractsAndGrantsModuleService(ContractsAndGrantsModuleService contractsAndGrantsModuleService) {
        this.contractsAndGrantsModuleService = contractsAndGrantsModuleService;
    }
}

