/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.integration.cg.ContractsAndGrantsCfda;
import org.kuali.kfs.integration.cg.dto.HashMapElement;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.CfdaDTO;
import org.kuali.kfs.module.external.kc.service.ExternalizableLookupableBusinessObjectService;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.webService.CfdaNumberSoapService;
import org.kuali.kra.external.Cfda.service.CfdaNumberService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class CfdaServiceImpl
implements ExternalizableLookupableBusinessObjectService {
    private static final Logger LOG = LogManager.getLogger(CfdaServiceImpl.class);
    protected ConfigurationService configurationService;

    protected CfdaNumberService getWebService() {
        CfdaNumberService cfdaNumberService = (CfdaNumberService)GlobalResourceLoader.getService((QName)KcConstants.Cfda.SERVICE);
        if (cfdaNumberService == null) {
            LOG.warn("Couldn't get CfdaNumberService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            CfdaNumberSoapService soapService = null;
            try {
                soapService = new CfdaNumberSoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error("Could not intialize CfdaNumberSoapService: " + ex.getMessage());
                throw new RuntimeException("Could not intialize CfdaNumberSoapService: " + ex.getMessage());
            }
            cfdaNumberService = soapService.getCfdaNumberServicePort();
        }
        return cfdaNumberService;
    }

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        Collection cfda = this.findMatching(primaryKeys);
        if (cfda != null && cfda.iterator().hasNext()) {
            return (ContractsAndGrantsCfda)cfda.iterator().next();
        }
        return null;
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        List<CfdaDTO> cfdas = null;
        ArrayList<HashMapElement> hashMapList = new ArrayList<HashMapElement>();
        for (Map.Entry e : fieldValues.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            if (!KcConstants.Cfda.KC_ALLOWABLE_CRITERIA_PARAMETERS.contains(key) || val.length() <= 0) continue;
            HashMapElement hashMapElement = new HashMapElement();
            hashMapElement.setKey(key);
            hashMapElement.setValue(val);
            hashMapList.add(hashMapElement);
        }
        try {
            cfdas = this.getWebService().lookupCfda(hashMapList);
        }
        catch (WebServiceException ex) {
            LOG.error("Could not retrieve cfda: " + ex.getMessage());
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        if (cfdas == null) {
            cfdas = new ArrayList<CfdaDTO>();
        }
        return cfdas;
    }

    @Override
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        return new ArrayList(this.findMatching(fieldValues));
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

