/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.service.ExternalizableLookupableBusinessObjectService;
import org.kuali.kfs.module.external.kc.webService.AwardWebSoapService;
import org.kuali.kra.external.award.AwardBillingUpdateDto;
import org.kuali.kra.external.award.AwardBillingUpdateStatusDto;
import org.kuali.kra.external.award.AwardFieldValuesDto;
import org.kuali.kra.external.award.AwardWebService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;

public class ContractsAndGrantsModuleBillingServiceImpl
implements ContractsAndGrantsModuleBillingService {
    private static final Logger LOG = LogManager.getLogger(ContractsAndGrantsModuleBillingServiceImpl.class);
    protected ExternalizableLookupableBusinessObjectService awardService;
    private ExternalizableLookupableBusinessObjectService awardAccountService;

    public List<? extends ContractsAndGrantsAward> lookupAwards(Map<String, String> fieldValues, boolean unbounded) {
        return this.getAwardService().getSearchResults(fieldValues);
    }

    public ContractsAndGrantsBillingAward updateAwardIfNecessary(String proposalNumber, ContractsAndGrantsBillingAward currentAward) {
        ContractsAndGrantsBillingAward award = currentAward;
        if (ObjectUtils.isNull((Object)proposalNumber)) {
            award = null;
        } else if (ObjectUtils.isNull((Object)currentAward) || !StringUtils.equals((CharSequence)currentAward.getProposalNumber(), (CharSequence)proposalNumber)) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("proposalNumber", proposalNumber);
            List awards = (List)this.awardService.findMatching(criteria);
            if (awards.size() > 0) {
                award = (ContractsAndGrantsBillingAward)awards.get(0);
            }
        }
        return award;
    }

    public ContractsAndGrantsBillingAwardAccount updateAwardAccountIfNecessary(String proposalNumber, String chartOfAccountsCode, String accountNumber, ContractsAndGrantsBillingAwardAccount currentAwardAccount) {
        ContractsAndGrantsBillingAwardAccount awardAccount = currentAwardAccount;
        if (StringUtils.isBlank((CharSequence)proposalNumber) || StringUtils.isBlank((CharSequence)chartOfAccountsCode) || StringUtils.isBlank((CharSequence)accountNumber)) {
            awardAccount = null;
        } else if (this.awardAccountNeedsUpdating(proposalNumber, chartOfAccountsCode, accountNumber, currentAwardAccount)) {
            HashMap<String, String> primaryKeys = new HashMap<String, String>();
            primaryKeys.put("proposalNumber", proposalNumber);
            primaryKeys.put("chartOfAccountsCode", chartOfAccountsCode);
            primaryKeys.put("accountNumber", accountNumber);
            awardAccount = (ContractsAndGrantsBillingAwardAccount)this.awardAccountService.findByPrimaryKey(primaryKeys);
        }
        return awardAccount;
    }

    private boolean awardAccountNeedsUpdating(String proposalNumber, String chartOfAccountsCode, String accountNumber, ContractsAndGrantsBillingAwardAccount currentAwardAccount) {
        if (ObjectUtils.isNull((Object)currentAwardAccount)) {
            return true;
        }
        return !StringUtils.equals((CharSequence)proposalNumber, (CharSequence)currentAwardAccount.getProposalNumber()) || !StringUtils.equals((CharSequence)chartOfAccountsCode, (CharSequence)currentAwardAccount.getChartOfAccountsCode()) || !StringUtils.equals((CharSequence)accountNumber, (CharSequence)currentAwardAccount.getAccountNumber());
    }

    public void setLastBilledDateToAwardAccount(Map<String, Object> criteria, boolean invoiceReversal, Date lastBilledDate) {
        AwardBillingUpdateDto updateDto = new AwardBillingUpdateDto();
        if (invoiceReversal) {
            updateDto.setRestorePreviousBillDate(true);
        } else {
            updateDto.setDoLastBillDateUpdate(true);
            updateDto.setLastBillDate(lastBilledDate);
        }
        this.handleBillingStatusResult(this.getAwardWebService().updateAwardBillingStatus(this.buildSearchDto(criteria), updateDto));
    }

    protected AwardFieldValuesDto buildSearchDto(Map<String, Object> criteria) {
        AwardFieldValuesDto dto = new AwardFieldValuesDto();
        dto.setAccountNumber((String)criteria.get("accountNumber"));
        dto.setChartOfAccounts((String)criteria.get("chartOfAccountsCode"));
        dto.setAwardNumber((String)criteria.get("proposalNumber"));
        return dto;
    }

    public void setLastBilledDateToAward(String proposalNumber, Date lastBilledDate) {
        AwardBillingUpdateDto updateDto = new AwardBillingUpdateDto();
        updateDto.setDoLastBillDateUpdate(true);
        updateDto.setLastBillDate(lastBilledDate);
        AwardFieldValuesDto searchDto = new AwardFieldValuesDto();
        searchDto.setAwardNumber(proposalNumber);
        this.handleBillingStatusResult(this.getAwardWebService().updateAwardBillingStatus(searchDto, updateDto));
    }

    public void setFinalBilledToAwardAccount(Map<String, Object> criteria, boolean finalBilled) {
        AwardBillingUpdateDto updateDto = new AwardBillingUpdateDto();
        updateDto.setDoFinalBilledUpdate(true);
        updateDto.setFinalBilledIndicator(finalBilled);
        this.handleBillingStatusResult(this.getAwardWebService().updateAwardBillingStatus(this.buildSearchDto(criteria), updateDto));
    }

    public AwardWebService getAwardWebService() {
        return this.getWebService();
    }

    public void setFinalBilledAndLastBilledDateToAwardAccount(Map<String, Object> mapKey, boolean finalBilled, boolean invoiceReversal, Date lastBilledDate) {
        AwardBillingUpdateDto updateDto = new AwardBillingUpdateDto();
        updateDto.setDoFinalBilledUpdate(true);
        updateDto.setFinalBilledIndicator(finalBilled);
        if (invoiceReversal) {
            updateDto.setRestorePreviousBillDate(true);
        } else {
            updateDto.setDoLastBillDateUpdate(true);
            updateDto.setLastBillDate(lastBilledDate);
        }
        this.handleBillingStatusResult(this.getAwardWebService().updateAwardBillingStatus(this.buildSearchDto(mapKey), updateDto));
    }

    protected void handleBillingStatusResult(AwardBillingUpdateStatusDto dto) {
        if (!dto.isSuccess()) {
            throw new RuntimeException(dto.getErrorMessages().get(0));
        }
    }

    public Map<String, Object> getLetterOfCreditAwardCriteria(String fundGroupCode, String fundCode) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        if (ObjectUtils.isNotNull((Object)fundGroupCode)) {
            criteria.put("locFundGroupCode", fundGroupCode);
        }
        if (ObjectUtils.isNotNull((Object)fundCode)) {
            criteria.put("locFundCode", fundCode);
        }
        return criteria;
    }

    protected AwardWebService getWebService() {
        AwardWebService awardWebService = (AwardWebService)GlobalResourceLoader.getService((QName)KcConstants.Award.SERVICE);
        if (awardWebService == null) {
            LOG.warn("Couldn't get AwardWebService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            AwardWebSoapService ss = null;
            try {
                ss = new AwardWebSoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error("Could not intialize AwardWebSoapService: " + ex.getMessage());
                throw new RuntimeException("Could not intialize AwardWebSoapService: " + ex.getMessage());
            }
            awardWebService = ss.getAwardWebServicePort();
        }
        return awardWebService;
    }

    public ExternalizableLookupableBusinessObjectService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(ExternalizableLookupableBusinessObjectService awardService) {
        this.awardService = awardService;
    }

    public ExternalizableLookupableBusinessObjectService getAwardAccountService() {
        return this.awardAccountService;
    }

    public void setAwardAccountService(ExternalizableLookupableBusinessObjectService awardAccountService) {
        this.awardAccountService = awardAccountService;
    }
}

