/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.integration.cg.dto.HashMapElement;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.UnitDTO;
import org.kuali.kfs.module.external.kc.service.ExternalizableLookupableBusinessObjectService;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.webService.InstitutionalUnitSoapService;
import org.kuali.kra.external.unit.service.InstitutionalUnitService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class UnitServiceImpl
implements ExternalizableLookupableBusinessObjectService {
    private static final Logger LOG = LogManager.getLogger(UnitServiceImpl.class);
    protected ConfigurationService configurationService;

    protected InstitutionalUnitService getWebService() {
        InstitutionalUnitService institutionalUnitService = (InstitutionalUnitService)GlobalResourceLoader.getService((QName)KcConstants.Unit.SERVICE);
        if (institutionalUnitService == null) {
            LOG.warn("Couldn't get InstitutionalUnitService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            InstitutionalUnitSoapService ss = null;
            try {
                ss = new InstitutionalUnitSoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error("Could not intialize InstitutionalUnitSoapService: " + ex.getMessage());
                throw new RuntimeException("Could not intialize InstitutionalUnitSoapService: " + ex.getMessage());
            }
            institutionalUnitService = ss.getInstitutionalUnitServicePort();
        }
        return institutionalUnitService;
    }

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        UnitDTO unitDTO = this.getWebService().getUnit((String)primaryKeys.get("unitNumber"));
        return unitDTO;
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        ArrayList<HashMapElement> hashMapList = new ArrayList<HashMapElement>();
        List<UnitDTO> lookupUnitsReturn = null;
        for (Map.Entry e : fieldValues.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            if (!KcConstants.Unit.KC_ALLOWABLE_CRITERIA_PARAMETERS.contains(key) || val.length() <= 0) continue;
            HashMapElement hashMapElement = new HashMapElement();
            hashMapElement.setKey(key);
            hashMapElement.setValue(val);
            hashMapList.add(hashMapElement);
        }
        try {
            lookupUnitsReturn = this.getWebService().lookupUnits(hashMapList);
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        if (lookupUnitsReturn == null) {
            lookupUnitsReturn = new ArrayList<UnitDTO>();
        }
        return lookupUnitsReturn;
    }

    @Override
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        return new ArrayList(this.findMatching(fieldValues));
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

