/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.businessobject;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.module.external.kc.businessobject.Agency;
import org.kuali.kfs.module.external.kc.businessobject.AgencyAddress;
import org.kuali.kra.external.sponsor.RolodexDTO;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class AgencyAddressTest {
    private AgencyAddress cut;
    @Mock
    private CountryService countrySvcMock;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void nullCountryCode() {
        Mockito.when((Object)this.countrySvcMock.getDefaultCountry()).thenReturn((Object)this.getDefaultCountry());
        this.cut = new AgencyAddress();
        this.cut.setCountryService(this.countrySvcMock);
        this.cut.init(this.getAgency(), this.getRolodexDto());
        ((CountryService)Mockito.verify((Object)this.countrySvcMock)).getDefaultCountry();
        ((CountryService)Mockito.verify((Object)this.countrySvcMock, (VerificationMode)Mockito.never())).getCountryByAlternateCode(ArgumentMatchers.anyString());
    }

    @Test
    public void validCountryCode() {
        Mockito.when((Object)this.countrySvcMock.getDefaultCountry()).thenReturn((Object)this.getDefaultCountry());
        Mockito.when((Object)this.countrySvcMock.getCountryByAlternateCode("USA")).thenReturn((Object)this.getDefaultCountry());
        this.cut = new AgencyAddress();
        this.cut.setCountryService(this.countrySvcMock);
        RolodexDTO rolodexDto = this.getRolodexDto();
        rolodexDto.setCountryCode("USA");
        this.cut.init(this.getAgency(), rolodexDto);
        Assert.assertTrue((String)"Country code should be US.", (boolean)"US".equals(this.cut.getAgencyCountryCode()));
        ((CountryService)Mockito.verify((Object)this.countrySvcMock)).getDefaultCountry();
        ((CountryService)Mockito.verify((Object)this.countrySvcMock)).getCountryByAlternateCode("USA");
    }

    private Country getDefaultCountry() {
        Country.Builder cb = Country.Builder.create((String)"US", (String)"USA", (String)"United States", (boolean)false, (boolean)true);
        return cb.build();
    }

    private RolodexDTO getRolodexDto() {
        RolodexDTO r = new RolodexDTO();
        r.setRolodexId(Integer.valueOf(1));
        return r;
    }

    private Agency getAgency() {
        Agency a = new Agency();
        return a;
    }
}

