/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.commons.collections4.MapUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.LetterOfCreditFundGroup;
import org.kuali.kfs.module.external.kc.service.ExternalizableBusinessObjectService;
import org.kuali.kfs.module.external.kc.service.impl.LetterOfCreditFundServiceImpl;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.webService.LetterOfCreditFundWebSoapService;
import org.kuali.kra.external.locfund.LetterOfCreditFundGroupDto;
import org.kuali.kra.external.locfund.LetterOfCreditFundWebService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class LetterOfCreditFundGroupServiceImpl
implements ExternalizableBusinessObjectService {
    private static final Logger LOG = LogManager.getLogger(LetterOfCreditFundServiceImpl.class);
    protected ConfigurationService configurationService;

    protected LetterOfCreditFundWebService getWebService() {
        LetterOfCreditFundWebService letterOfCreditFundWebService = (LetterOfCreditFundWebService)GlobalResourceLoader.getService((QName)KcConstants.LetterOfCreditFund.SERVICE);
        if (letterOfCreditFundWebService == null) {
            LetterOfCreditFundWebSoapService ss;
            LOG.warn("Couldn't get LetterOfCreditFundWebService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            try {
                ss = new LetterOfCreditFundWebSoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error("Could not intialize LetterOfCreditFundWebSoapService: " + ex.getMessage());
                throw new RuntimeException("Could not intialize LetterOfCreditFundWebSoapService: " + ex.getMessage());
            }
            letterOfCreditFundWebService = ss.getLetterOfCreditFundWebServicePort();
        }
        return letterOfCreditFundWebService;
    }

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        List<LetterOfCreditFundGroupDto> results = null;
        try {
            results = this.getWebService().findMatchingFundGroup((String)primaryKeys.get("groupCode"), (String)primaryKeys.get("description"));
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        if (results != null && results.size() > 0) {
            return this.fundFromDTO(results.get(0));
        }
        return null;
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        List<LetterOfCreditFundGroupDto> results = null;
        if (MapUtils.isEmpty((Map)fieldValues)) {
            return this.findAll();
        }
        try {
            results = this.getWebService().findMatchingFundGroup((String)fieldValues.get("groupCode"), (String)fieldValues.get("description"));
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        ArrayList<LetterOfCreditFundGroup> fundGroups = new ArrayList<LetterOfCreditFundGroup>();
        if (results != null) {
            for (LetterOfCreditFundGroupDto dto : results) {
                fundGroups.add(this.fundFromDTO(dto));
            }
        }
        return fundGroups;
    }

    public Collection findAll() {
        List<LetterOfCreditFundGroupDto> results = null;
        try {
            results = this.getWebService().allLocFundGroups();
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        ArrayList<LetterOfCreditFundGroup> fundGroups = new ArrayList<LetterOfCreditFundGroup>();
        if (results != null) {
            for (LetterOfCreditFundGroupDto dto : results) {
                fundGroups.add(this.fundFromDTO(dto));
            }
        }
        return fundGroups;
    }

    protected LetterOfCreditFundGroup fundFromDTO(LetterOfCreditFundGroupDto dto) {
        LetterOfCreditFundGroup fundGroup = new LetterOfCreditFundGroup();
        fundGroup.setLetterOfCreditFundGroupCode(dto.getGroupCode());
        fundGroup.setLetterOfCreditFundGroupDescription(dto.getDescription());
        fundGroup.setActive(dto.isActive());
        return fundGroup;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

