/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.service.impl;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.commons.collections4.MapUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.external.kc.KcConstants;
import org.kuali.kfs.module.external.kc.businessobject.LetterOfCreditFund;
import org.kuali.kfs.module.external.kc.service.ExternalizableBusinessObjectService;
import org.kuali.kfs.module.external.kc.util.GlobalVariablesExtractHelper;
import org.kuali.kfs.module.external.kc.webService.LetterOfCreditFundWebSoapService;
import org.kuali.kra.external.locfund.LetterOfCreditFundDto;
import org.kuali.kra.external.locfund.LetterOfCreditFundWebService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class LetterOfCreditFundServiceImpl
implements ExternalizableBusinessObjectService {
    private static final Logger LOG = LogManager.getLogger(LetterOfCreditFundServiceImpl.class);
    protected ConfigurationService configurationService;

    protected LetterOfCreditFundWebService getWebService() {
        LetterOfCreditFundWebService letterOfCreditFundWebService = (LetterOfCreditFundWebService)GlobalResourceLoader.getService((QName)KcConstants.LetterOfCreditFund.SERVICE);
        if (letterOfCreditFundWebService == null) {
            LetterOfCreditFundWebSoapService ss;
            LOG.warn("Couldn't get LetterOfCreditFundWebService from KSB, setting it up as SOAP web service - expected behavior for bundled Rice, but not when KFS & KC share a standalone Rice instance.");
            try {
                ss = new LetterOfCreditFundWebSoapService();
            }
            catch (MalformedURLException ex) {
                LOG.error("Could not intialize LetterOfCreditFundWebSoapService: " + ex.getMessage());
                throw new RuntimeException("Could not intialize LetterOfCreditFundWebSoapService: " + ex.getMessage());
            }
            letterOfCreditFundWebService = ss.getLetterOfCreditFundWebServicePort();
        }
        return letterOfCreditFundWebService;
    }

    @Override
    public ExternalizableBusinessObject findByPrimaryKey(Map primaryKeys) {
        List<LetterOfCreditFundDto> results = null;
        try {
            results = this.getWebService().findMatchingFund((String)primaryKeys.get("fundCode"), (String)primaryKeys.get("description"));
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        if (results != null && results.size() > 0) {
            return this.fundFromDTO(results.get(0));
        }
        return null;
    }

    @Override
    public Collection findMatching(Map fieldValues) {
        List<LetterOfCreditFundDto> results = null;
        if (MapUtils.isEmpty((Map)fieldValues)) {
            return this.findAll();
        }
        try {
            results = this.getWebService().findMatchingFund((String)fieldValues.get("fundCode"), (String)fieldValues.get("description"));
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        ArrayList<LetterOfCreditFund> funds = new ArrayList<LetterOfCreditFund>();
        if (results != null) {
            for (LetterOfCreditFundDto dto : results) {
                funds.add(this.fundFromDTO(dto));
            }
        }
        return funds;
    }

    public Collection findAll() {
        List<LetterOfCreditFundDto> results = null;
        try {
            results = this.getWebService().allLocFunds();
        }
        catch (WebServiceException ex) {
            GlobalVariablesExtractHelper.insertError("Access to the web service is unreachable: ", this.getConfigurationService().getPropertyValueAsString("kc.application.url"));
        }
        ArrayList<LetterOfCreditFund> funds = new ArrayList<LetterOfCreditFund>();
        if (results != null) {
            for (LetterOfCreditFundDto dto : results) {
                funds.add(this.fundFromDTO(dto));
            }
        }
        return funds;
    }

    protected LetterOfCreditFund fundFromDTO(LetterOfCreditFundDto dto) {
        LetterOfCreditFund fund = new LetterOfCreditFund();
        fund.setLetterOfCreditFundCode(dto.getFundCode());
        fund.setLetterOfCreditFundDescription(dto.getDescription());
        fund.setActive(dto.isActive());
        fund.setLetterOfCreditFundGroupCode(dto.getGroupCode());
        fund.setLetterOfCreditFundAmount(dto.getAmount());
        fund.setLetterOfCreditFundExpirationDate(dto.getExpirationDate());
        fund.setLetterOfCreditFundStartDate(dto.getStartDate());
        return fund;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

