/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.util.AutoPopulatingList;

public class GlobalVariablesExtractHelper {
    private static final Logger LOG = LogManager.getLogger(GlobalVariablesExtractHelper.class);

    public static void insertError(String message, String param) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        errorMap.putError("GLOBAL_ERRORS", "error.custom", new String[]{message + param});
    }

    public static List<String> extractGlobalVariableErrors() {
        ArrayList<String> result = new ArrayList<String>();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        Set errorKeys = errorMap.getAllPropertiesWithErrors();
        AutoPopulatingList errorMessages = null;
        for (String errorProperty : errorKeys) {
            errorMessages = errorMap.getErrorMessagesForProperty(errorProperty);
            LOG.debug("error Messages :::: " + errorMessages.toString());
            for (ErrorMessage errorMessage : errorMessages) {
                String errorKeyString = ((ConfigurationService)SpringContext.getBean(ConfigurationService.class)).getPropertyValueAsString(errorMessage.getErrorKey());
                Object[] messageParams = errorMessage.getMessageParameters();
                LOG.debug("message parameters:::  " + messageParams);
                LOG.debug("errorKeyString :::: " + errorKeyString);
                String errorString = StringUtils.isBlank((CharSequence)errorKeyString) ? errorMessage.getErrorKey() : errorKeyString;
                LOG.debug(errorString);
                if (errorString.matches("^.*\\{\\d\\}.*$")) {
                    errorString = MessageFormat.format(errorString, messageParams);
                }
                result.add(errorString);
            }
        }
        GlobalVariables.clear();
        return result;
    }

    public static String replaceTokens(String line, String ... replacements) {
        int i = 0;
        for (String err : replacements) {
            String repl = "{" + String.valueOf(i++) + "}";
            line = StringUtils.replaceOnce((String)line, (String)repl, (String)err);
        }
        return line;
    }
}

