/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.businessobject;

import java.sql.Date;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsAgencyAddress;
import org.kuali.kfs.module.external.kc.businessobject.Agency;
import org.kuali.kra.external.sponsor.RolodexDTO;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;

public class AgencyAddress
implements ContractsAndGrantsAgencyAddress {
    private String agencyNumber;
    private Long agencyAddressIdentifier;
    private String agencyAddressName;
    private String agencyLine1StreetAddress;
    private String agencyLine2StreetAddress;
    private String agencyLine3StreetAddress;
    private String agencyLine4StreetAddress;
    private String agencyCityName;
    private String agencyStateCode;
    private String agencyZipCode;
    private String agencyAddressInternationalProvinceName;
    private String agencyCountryCode;
    private String agencyInternationalMailCode;
    private String agencyContactEmailAddress;
    private String customerAddressTypeCode;
    private Date agencyAddressEndDate;
    private String agencyContractName;
    private String agencyPhoneNumber;
    private String agencyFaxNumber;
    private String agencyContactName;
    private Agency agency;
    private boolean primary;
    private CountryService countryService;

    public AgencyAddress() {
    }

    public AgencyAddress(Agency agency, RolodexDTO kcAddress) {
        this.init(agency, kcAddress);
    }

    public void init(Agency agency, RolodexDTO kcAddress) {
        this.agency = agency;
        this.agencyNumber = agency.getAgencyNumber();
        this.agencyAddressIdentifier = kcAddress.getRolodexId().longValue();
        this.agencyAddressName = agency.getFullName();
        this.agencyLine1StreetAddress = kcAddress.getAddressLine1();
        this.agencyLine2StreetAddress = kcAddress.getAddressLine2();
        this.agencyLine3StreetAddress = kcAddress.getAddressLine3();
        this.agencyCityName = kcAddress.getCity();
        Country defaultCountry = this.getCountryService().getDefaultCountry();
        if (StringUtils.isNotEmpty((CharSequence)kcAddress.getCountryCode())) {
            Country country = this.getCountryService().getCountryByAlternateCode(kcAddress.getCountryCode());
            this.agencyCountryCode = country != null ? country.getCode() : kcAddress.getCountryCode();
        }
        if (StringUtils.equals((CharSequence)this.getAgencyCountryCode(), (CharSequence)defaultCountry.getCode())) {
            this.agencyStateCode = kcAddress.getState();
            this.agencyZipCode = kcAddress.getPostalCode();
        } else {
            this.agencyAddressInternationalProvinceName = kcAddress.getState();
            this.agencyInternationalMailCode = kcAddress.getPostalCode();
        }
        this.agencyContactEmailAddress = kcAddress.getEmailAddress();
        this.agencyContactName = kcAddress.getFullName();
        this.agencyPhoneNumber = kcAddress.getPhoneNumber();
        this.agencyFaxNumber = kcAddress.getFaxNumber();
        this.customerAddressTypeCode = "P";
        this.primary = true;
    }

    public void refresh() {
    }

    public String getAgencyNumber() {
        return this.agencyNumber;
    }

    public void setAgencyNumber(String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    public Long getAgencyAddressIdentifier() {
        return this.agencyAddressIdentifier;
    }

    public void setAgencyAddressIdentifier(Long agencyAddressIdentifier) {
        this.agencyAddressIdentifier = agencyAddressIdentifier;
    }

    public String getAgencyAddressName() {
        return this.agencyAddressName;
    }

    public void setAgencyAddressName(String agencyAddressName) {
        this.agencyAddressName = agencyAddressName;
    }

    public String getAgencyLine1StreetAddress() {
        return this.agencyLine1StreetAddress;
    }

    public void setAgencyLine1StreetAddress(String agencyLine1StreetAddress) {
        this.agencyLine1StreetAddress = agencyLine1StreetAddress;
    }

    public String getAgencyLine2StreetAddress() {
        return this.agencyLine2StreetAddress;
    }

    public void setAgencyLine2StreetAddress(String agencyLine2StreetAddress) {
        this.agencyLine2StreetAddress = agencyLine2StreetAddress;
    }

    public String getAgencyLine3StreetAddress() {
        return this.agencyLine3StreetAddress;
    }

    public void setAgencyLine3StreetAddress(String agencyLine3StreetAddress) {
        this.agencyLine3StreetAddress = agencyLine3StreetAddress;
    }

    public String getAgencyCityName() {
        return this.agencyCityName;
    }

    public void setAgencyCityName(String agencyCityName) {
        this.agencyCityName = agencyCityName;
    }

    public String getAgencyStateCode() {
        return this.agencyStateCode;
    }

    public void setAgencyStateCode(String agencyStateCode) {
        this.agencyStateCode = agencyStateCode;
    }

    public String getAgencyZipCode() {
        return this.agencyZipCode;
    }

    public void setAgencyZipCode(String agencyZipCode) {
        this.agencyZipCode = agencyZipCode;
    }

    public String getAgencyAddressInternationalProvinceName() {
        return this.agencyAddressInternationalProvinceName;
    }

    public void setAgencyAddressInternationalProvinceName(String agencyAddressInternationalProvinceName) {
        this.agencyAddressInternationalProvinceName = agencyAddressInternationalProvinceName;
    }

    public String getAgencyCountryCode() {
        return this.agencyCountryCode;
    }

    public void setAgencyCountryCode(String agencyCountryCode) {
        this.agencyCountryCode = agencyCountryCode;
    }

    public String getAgencyInternationalMailCode() {
        return this.agencyInternationalMailCode;
    }

    public void setAgencyInternationalMailCode(String agencyInternationalMailCode) {
        this.agencyInternationalMailCode = agencyInternationalMailCode;
    }

    public String getAgencyContactEmailAddress() {
        return this.agencyContactEmailAddress;
    }

    public void setAgencyContactEmailAddress(String agencyContactEmailAddress) {
        this.agencyContactEmailAddress = agencyContactEmailAddress;
    }

    public String getCustomerAddressTypeCode() {
        return this.customerAddressTypeCode;
    }

    public void setCustomerAddressTypeCode(String customerAddressTypeCode) {
        this.customerAddressTypeCode = customerAddressTypeCode;
    }

    public Date getAgencyAddressEndDate() {
        return this.agencyAddressEndDate;
    }

    public void setAgencyAddressEndDate(Date agencyAddressEndDate) {
        this.agencyAddressEndDate = agencyAddressEndDate;
    }

    public String getAgencyContractName() {
        return this.agencyContractName;
    }

    public void setAgencyContractName(String agencyContractName) {
        this.agencyContractName = agencyContractName;
    }

    public String getAgencyPhoneNumber() {
        return this.agencyPhoneNumber;
    }

    public void setAgencyPhoneNumber(String agencyPhoneNumber) {
        this.agencyPhoneNumber = agencyPhoneNumber;
    }

    public String getAgencyFaxNumber() {
        return this.agencyFaxNumber;
    }

    public void setAgencyFaxNumber(String agencyFaxNumber) {
        this.agencyFaxNumber = agencyFaxNumber;
    }

    public Agency getAgency() {
        return this.agency;
    }

    public void setAgency(Agency agency) {
        this.agency = agency;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public String getAgencyLine4StreetAddress() {
        return this.agencyLine4StreetAddress;
    }

    public void setAgencyLine4StreetAddress(String agencyLine4StreetAddress) {
        this.agencyLine4StreetAddress = agencyLine4StreetAddress;
    }

    public String getAgencyContactName() {
        return this.agencyContactName;
    }

    public void setAgencyContactName(String agencyContactName) {
        this.agencyContactName = agencyContactName;
    }

    private CountryService getCountryService() {
        if (this.countryService == null) {
            this.countryService = LocationApiServiceLocator.getCountryService();
        }
        return this.countryService;
    }

    public void setCountryService(CountryService countryService) {
        this.countryService = countryService;
    }
}

