/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.businessobject;

import java.sql.Date;
import java.sql.Timestamp;
import org.kuali.kfs.integration.cg.ContractAndGrantsProposal;
import org.kuali.kfs.module.external.kc.businessobject.Award;
import org.kuali.kra.external.award.ProposalDTO;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class Proposal
implements ContractAndGrantsProposal {
    private String proposalNumber;
    private boolean proposalFederalPassThroughIndicator;
    private String grantNumber;
    private String federalPassThroughAgencyNumber;
    private boolean active;
    private Award award;
    private Date proposalBeginningDate;
    private Date proposalEndingDate;
    private KualiDecimal proposalTotalAmount;
    private KualiDecimal proposalDirectCostAmount;
    private KualiDecimal proposalIndirectCostAmount;
    private Date proposalRejectedDate;
    private Timestamp proposalLastUpdateDate;
    private Date proposalDueDate;
    private KualiDecimal proposalTotalProjectAmount;
    private Date proposalSubmissionDate;
    private String oldProposalNumber;
    private Date proposalClosingDate;
    private String proposalAwardTypeCode;
    private String agencyNumber;
    private String proposalStatusCode;
    private String cfdaNumber;
    private String proposalFellowName;
    private String proposalPurposeCode;
    private String proposalProjectTitle;

    public Proposal(ProposalDTO kcProposal) {
        this.setProposalNumber(kcProposal.getProposalNumber());
        this.setProposalBeginningDate(new Date(kcProposal.getRequestedStartDateTotal().getDate()));
        this.setProposalEndingDate(new Date(kcProposal.getRequestedEndDateTotal().getDate()));
        if (kcProposal.getProposalTotalAmount() != null) {
            this.setProposalTotalAmount(new KualiDecimal(kcProposal.getProposalTotalAmount()));
        }
        if (kcProposal.getTotalDirectCostTotal() != null) {
            this.setProposalDirectCostAmount(new KualiDecimal(kcProposal.getTotalDirectCostTotal()));
        }
        if (kcProposal.getTotalIndirectCostTotal() != null) {
            this.setProposalIndirectCostAmount(new KualiDecimal(kcProposal.getTotalIndirectCostTotal()));
        }
        this.setProposalLastUpdateDate(new Timestamp(kcProposal.getProposalLastUpdateDate().getDate()));
        this.setProposalAwardTypeCode(kcProposal.getAwardTypeCode().toString());
        this.setAgencyNumber(kcProposal.getSponsorCode());
        this.setProposalStatusCode(kcProposal.getStatusCode().toString());
        this.setCfdaNumber(kcProposal.getCfdaNumber());
        this.setProposalProjectTitle(kcProposal.getTitle());
        this.setGrantNumber(kcProposal.getSponsorAwardNumber());
    }

    public Proposal() {
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public boolean getProposalFederalPassThroughIndicator() {
        return this.proposalFederalPassThroughIndicator;
    }

    public void setProposalFederalPassThroughIndicator(boolean proposalFederalPassThroughIndicator) {
        this.proposalFederalPassThroughIndicator = proposalFederalPassThroughIndicator;
    }

    public String getGrantNumber() {
        return this.grantNumber;
    }

    public void setGrantNumber(String grantNumber) {
        this.grantNumber = grantNumber;
    }

    public String getFederalPassThroughAgencyNumber() {
        return this.federalPassThroughAgencyNumber;
    }

    public void setFederalPassThroughAgencyNumber(String federalPassThroughAgencyNumber) {
        this.federalPassThroughAgencyNumber = federalPassThroughAgencyNumber;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void prepareForWorkflow() {
    }

    public void refresh() {
    }

    public Award getAward() {
        return this.award;
    }

    public void setAward(Award award) {
        this.award = award;
    }

    public Date getProposalBeginningDate() {
        return this.proposalBeginningDate;
    }

    public void setProposalBeginningDate(Date proposalBeginningDate) {
        this.proposalBeginningDate = proposalBeginningDate;
    }

    public Date getProposalEndingDate() {
        return this.proposalEndingDate;
    }

    public void setProposalEndingDate(Date proposalEndingDate) {
        this.proposalEndingDate = proposalEndingDate;
    }

    public KualiDecimal getProposalTotalAmount() {
        return this.proposalTotalAmount;
    }

    public void setProposalTotalAmount(KualiDecimal proposalTotalAmount) {
        this.proposalTotalAmount = proposalTotalAmount;
    }

    public KualiDecimal getProposalDirectCostAmount() {
        return this.proposalDirectCostAmount;
    }

    public void setProposalDirectCostAmount(KualiDecimal proposalDirectCostAmount) {
        this.proposalDirectCostAmount = proposalDirectCostAmount;
    }

    public KualiDecimal getProposalIndirectCostAmount() {
        return this.proposalIndirectCostAmount;
    }

    public void setProposalIndirectCostAmount(KualiDecimal proposalIndirectCostAmount) {
        this.proposalIndirectCostAmount = proposalIndirectCostAmount;
    }

    public Date getProposalRejectedDate() {
        return this.proposalRejectedDate;
    }

    public void setProposalRejectedDate(Date proposalRejectedDate) {
        this.proposalRejectedDate = proposalRejectedDate;
    }

    public Timestamp getProposalLastUpdateDate() {
        return this.proposalLastUpdateDate;
    }

    public void setProposalLastUpdateDate(Timestamp proposalLastUpdateDate) {
        this.proposalLastUpdateDate = proposalLastUpdateDate;
    }

    public Date getProposalDueDate() {
        return this.proposalDueDate;
    }

    public void setProposalDueDate(Date proposalDueDate) {
        this.proposalDueDate = proposalDueDate;
    }

    public KualiDecimal getProposalTotalProjectAmount() {
        return this.proposalTotalProjectAmount;
    }

    public void setProposalTotalProjectAmount(KualiDecimal proposalTotalProjectAmount) {
        this.proposalTotalProjectAmount = proposalTotalProjectAmount;
    }

    public Date getProposalSubmissionDate() {
        return this.proposalSubmissionDate;
    }

    public void setProposalSubmissionDate(Date proposalSubmissionDate) {
        this.proposalSubmissionDate = proposalSubmissionDate;
    }

    public String getOldProposalNumber() {
        return this.oldProposalNumber;
    }

    public void setOldProposalNumber(String oldProposalNumber) {
        this.oldProposalNumber = oldProposalNumber;
    }

    public Date getProposalClosingDate() {
        return this.proposalClosingDate;
    }

    public void setProposalClosingDate(Date proposalClosingDate) {
        this.proposalClosingDate = proposalClosingDate;
    }

    public String getProposalAwardTypeCode() {
        return this.proposalAwardTypeCode;
    }

    public void setProposalAwardTypeCode(String proposalAwardTypeCode) {
        this.proposalAwardTypeCode = proposalAwardTypeCode;
    }

    public String getAgencyNumber() {
        return this.agencyNumber;
    }

    public void setAgencyNumber(String agencyNumber) {
        this.agencyNumber = agencyNumber;
    }

    public String getProposalStatusCode() {
        return this.proposalStatusCode;
    }

    public void setProposalStatusCode(String proposalStatusCode) {
        this.proposalStatusCode = proposalStatusCode;
    }

    public String getCfdaNumber() {
        return this.cfdaNumber;
    }

    public void setCfdaNumber(String cfdaNumber) {
        this.cfdaNumber = cfdaNumber;
    }

    public String getProposalFellowName() {
        return this.proposalFellowName;
    }

    public void setProposalFellowName(String proposalFellowName) {
        this.proposalFellowName = proposalFellowName;
    }

    public String getProposalPurposeCode() {
        return this.proposalPurposeCode;
    }

    public void setProposalPurposeCode(String proposalPurposeCode) {
        this.proposalPurposeCode = proposalPurposeCode;
    }

    public String getProposalProjectTitle() {
        return this.proposalProjectTitle;
    }

    public void setProposalProjectTitle(String proposalProjectTitle) {
        this.proposalProjectTitle = proposalProjectTitle;
    }
}

