/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.external.kc.document.validation.impl;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.FundGroup;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.coa.document.validation.impl.AccountRule;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.service.BalanceService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsUnit;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.external.kc.businessobject.AccountAutoCreateDefaults;
import org.kuali.kfs.module.external.kc.businessobject.IndirectCostRecoveryAutoDefAccount;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.parameter.ParameterEvaluatorService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.ExternalizableBusinessObject;

public class AccountAutoCreateDefaultsRule
extends AccountRule {
    private static final Logger LOG = LogManager.getLogger(AccountAutoCreateDefaultsRule.class);
    protected static ParameterService parameterService;
    protected static final String ACCT_PREFIX_RESTRICTION = "PREFIXES";
    protected static final String ACCT_CAPITAL_SUBFUNDGROUP = "CAPITAL_SUB_FUND_GROUPS";
    protected AccountAutoCreateDefaults oldAccountAutoCreateDefaults;
    protected AccountAutoCreateDefaults newAccountAutoCreateDefaults;

    public AccountAutoCreateDefaultsRule() {
        this.setGeneralLedgerPendingEntryService((GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class));
        this.setBalanceService((BalanceService)SpringContext.getBean(BalanceService.class));
        this.setAccountService((AccountService)SpringContext.getBean(AccountService.class));
        this.setContractsAndGrantsModuleService((ContractsAndGrantsModuleService)SpringContext.getBean(ContractsAndGrantsModuleService.class));
    }

    public void setupConvenienceObjects() {
        this.oldAccountAutoCreateDefaults = (AccountAutoCreateDefaults)((Object)super.getOldBo());
        this.newAccountAutoCreateDefaults = (AccountAutoCreateDefaults)((Object)super.getNewBo());
        this.setBoFieldPath("indirectCostRecoveryAccounts");
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomSaveDocumentBusinessRules called");
        this.processCustomRouteDocumentBusinessRules(document);
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        LOG.info("processCustomRouteDocumentBusinessRules called");
        this.setupConvenienceObjects();
        boolean success = this.checkEmptyValues(document);
        success &= this.checkGeneralRules(document);
        success &= this.checkContractsAndGrants(document);
        success &= this.checkIncomeStreamAccountRule();
        success &= this.checkRequiredKcUnit(this.newAccountAutoCreateDefaults, document.isNew());
        return success &= this.checkIndirectCostRecoveryAccountDistributions();
    }

    public boolean processCustomAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject bo) {
        boolean success = true;
        bo.refreshNonUpdateableReferences();
        if (bo instanceof IndirectCostRecoveryAutoDefAccount) {
            IndirectCostRecoveryAutoDefAccount account = (IndirectCostRecoveryAutoDefAccount)bo;
            success = this.checkIndirectCostRecoveryAccount(account);
        }
        return success;
    }

    protected boolean checkEmptyValues(MaintenanceDocument maintenanceDocument) {
        LOG.info("checkEmptyValues called");
        boolean success = this.checkForPartiallyFilledOutReferenceForeignKeys("continuationAccount");
        success &= this.checkForPartiallyFilledOutReferenceForeignKeys("incomeStreamAccount");
        return success &= this.checkForPartiallyFilledOutReferenceForeignKeys("reportsToAccount");
    }

    protected boolean checkGeneralRules(MaintenanceDocument maintenanceDocument) {
        LOG.info("checkGeneralRules called");
        Person fiscalOfficer = this.newAccountAutoCreateDefaults.getAccountFiscalOfficerUser();
        Person accountManager = this.newAccountAutoCreateDefaults.getAccountManagerUser();
        Person accountSupervisor = this.newAccountAutoCreateDefaults.getAccountSupervisoryUser();
        boolean success = this.checkFringeBenefitAccountRule();
        if (ObjectUtils.isNotNull((Object)fiscalOfficer) && StringUtils.isNotBlank((CharSequence)fiscalOfficer.getPrincipalId()) && !this.getDocumentHelperService().getDocumentAuthorizer((Document)maintenanceDocument).isAuthorized((BusinessObject)maintenanceDocument, KFSConstants.PermissionNames.SERVE_AS_FISCAL_OFFICER.namespace, KFSConstants.PermissionNames.SERVE_AS_FISCAL_OFFICER.name, fiscalOfficer.getPrincipalId())) {
            super.putFieldError("accountFiscalOfficerUser.principalName", "error.user.missing.permission", new String[]{fiscalOfficer.getName(), KFSConstants.PermissionNames.SERVE_AS_FISCAL_OFFICER.namespace, KFSConstants.PermissionNames.SERVE_AS_FISCAL_OFFICER.name});
            success = false;
        }
        if (ObjectUtils.isNotNull((Object)accountSupervisor) && StringUtils.isNotBlank((CharSequence)accountSupervisor.getPrincipalId()) && !this.getDocumentHelperService().getDocumentAuthorizer((Document)maintenanceDocument).isAuthorized((BusinessObject)maintenanceDocument, KFSConstants.PermissionNames.SERVE_AS_ACCOUNT_SUPERVISOR.namespace, KFSConstants.PermissionNames.SERVE_AS_ACCOUNT_SUPERVISOR.name, accountSupervisor.getPrincipalId())) {
            super.putFieldError("accountSupervisoryUser.principalName", "error.user.missing.permission", new String[]{accountSupervisor.getName(), KFSConstants.PermissionNames.SERVE_AS_ACCOUNT_SUPERVISOR.namespace, KFSConstants.PermissionNames.SERVE_AS_ACCOUNT_SUPERVISOR.name});
            success = false;
        }
        if (ObjectUtils.isNotNull((Object)accountManager) && StringUtils.isNotBlank((CharSequence)accountManager.getPrincipalId()) && !this.getDocumentHelperService().getDocumentAuthorizer((Document)maintenanceDocument).isAuthorized((BusinessObject)maintenanceDocument, KFSConstants.PermissionNames.SERVE_AS_ACCOUNT_MANAGER.namespace, KFSConstants.PermissionNames.SERVE_AS_ACCOUNT_MANAGER.name, accountManager.getPrincipalId())) {
            super.putFieldError("accountManagerUser.principalName", "error.user.missing.permission", new String[]{accountManager.getName(), KFSConstants.PermissionNames.SERVE_AS_ACCOUNT_MANAGER.namespace, KFSConstants.PermissionNames.SERVE_AS_ACCOUNT_MANAGER.name});
            success = false;
        }
        if (this.isSupervisorSameAsFiscalOfficer()) {
            success = false;
            this.putFieldError("accountsSupervisorySystemsIdentifier", "error.document.accountMaintenance.accountSupervisorCannotBeFiscalOfficer");
        }
        if (this.isSupervisorSameAsManager()) {
            success = false;
            this.putFieldError("accountManagerSystemIdentifier", "error.document.accountMaintenance.accountSupervisorCannotBeAcctManager");
        }
        if (this.isContinuationAccountExpired()) {
            success = false;
            this.putFieldError("continuationAccountNumber", "error.document.accountMaintenance.expiredAccount.continuationAccount");
        }
        return success;
    }

    protected boolean checkFringeBenefitAccountRule() {
        boolean result = true;
        if (this.newAccountAutoCreateDefaults.isAccountsFringesBnftIndicator()) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)this.newAccountAutoCreateDefaults.getReportsToAccountNumber())) {
            this.putFieldError("reportsToAccountNumber", "error.document.accountMaintenance.reportsToAccountRequiredIfFringeBenefitsFalse");
            result = false;
        }
        if (StringUtils.isBlank((CharSequence)this.newAccountAutoCreateDefaults.getReportsToChartOfAccountsCode())) {
            this.putFieldError("reportsToChartOfAccountsCode", "error.document.accountMaintenance.reportsToAccountRequiredIfFringeBenefitsFalse");
            result = false;
        }
        if (!result) {
            return false;
        }
        Account fringeBenefitAccount = this.accountService.getByPrimaryId(this.newAccountAutoCreateDefaults.getReportsToChartOfAccountsCode(), this.newAccountAutoCreateDefaults.getReportsToAccountNumber());
        if (fringeBenefitAccount == null) {
            this.putFieldError("reportsToAccountNumber", "error.existence", this.getFieldLabel(Account.class, "reportsToAccountNumber"));
            return false;
        }
        if (!fringeBenefitAccount.isActive()) {
            this.putFieldError("reportsToAccountNumber", "error.inactive", this.getFieldLabel(Account.class, "reportsToAccountNumber"));
            result = false;
        }
        if (!fringeBenefitAccount.isAccountsFringesBnftIndicator()) {
            this.putFieldError("reportsToAccountNumber", "error.document.accountMaintenance.reportsToAccountMustBeFringeBenefitFlaggedIfThisAccountFringeBenefitsIsFalse", fringeBenefitAccount.getChartOfAccountsCode() + "-" + fringeBenefitAccount.getAccountNumber());
            result = false;
        }
        return result;
    }

    protected boolean isSupervisorSameAsFiscalOfficer() {
        return this.areTwoUsersTheSame(this.newAccountAutoCreateDefaults.getAccountSupervisoryUser(), this.newAccountAutoCreateDefaults.getAccountFiscalOfficerUser());
    }

    protected boolean isSupervisorSameAsManager() {
        return this.areTwoUsersTheSame(this.newAccountAutoCreateDefaults.getAccountSupervisoryUser(), this.newAccountAutoCreateDefaults.getAccountManagerUser());
    }

    protected boolean isContinuationAccountExpired() {
        String chartCode = this.newAccountAutoCreateDefaults.getContinuationFinChrtOfAcctCd();
        String accountNumber = this.newAccountAutoCreateDefaults.getContinuationAccountNumber();
        if (StringUtils.isBlank((CharSequence)chartCode) || StringUtils.isBlank((CharSequence)accountNumber)) {
            return false;
        }
        Account continuation = this.accountService.getByPrimaryId(chartCode, accountNumber);
        if (ObjectUtils.isNull((Object)continuation)) {
            return false;
        }
        return continuation.isExpired();
    }

    protected boolean checkContractsAndGrants(MaintenanceDocument maintenanceDocument) {
        LOG.info("checkContractsAndGrants called");
        boolean success = this.checkCgRequiredFields();
        success &= this.checkIncomeStreamValid();
        if (!ObjectUtils.isNull((Object)((Object)this.newAccountAutoCreateDefaults))) {
            Account account = new Account();
            account.setContractsAndGrantsAccountResponsibilityId(this.newAccountAutoCreateDefaults.getContractsAndGrantsAccountResponsibilityId());
            boolean hasValidAccountResponsibility = this.contractsAndGrantsModuleService.hasValidAccountReponsiblityIdIfNotNull(account);
            if (!hasValidAccountResponsibility) {
                success = false;
                this.putFieldError("contractsAndGrantsAccountResponsibilityId", "error.document.accountMaintenance.invalidContractsAndGrantsResponsibility", new String[]{this.newAccountAutoCreateDefaults.getContractsAndGrantsAccountResponsibilityId().toString(), this.newAccountAutoCreateDefaults.getChartOfAccountsCode(), ""});
            }
        }
        return success;
    }

    protected boolean checkCgRequiredFields() {
        boolean result = true;
        if (ObjectUtils.isNotNull((Object)this.newAccountAutoCreateDefaults.getSubFundGroup())) {
            result = this.getSubFundGroupService().isForContractsAndGrants(this.newAccountAutoCreateDefaults.getSubFundGroup()) ? this.checkICRCollectionExistWithErrorMessage(true, "error.document.accountMaintenance.icrChartCodeCannotBeEmpty", new String[]{this.getSubFundGroupService().getContractsAndGrantsDenotingAttributeLabel(), this.getSubFundGroupService().getContractsAndGrantsDenotingValueForMessage()}) : this.checkICRCollectionExistWithErrorMessage(false, "error.document.accountMaintenance.cgFieldsFilledInForNonCGAccount", new String[]{this.getSubFundGroupService().getContractsAndGrantsDenotingAttributeLabel(), this.getSubFundGroupService().getContractsAndGrantsDenotingValueForMessage()});
        }
        return result;
    }

    protected boolean checkIncomeStreamValid() {
        if (ObjectUtils.isNull((Object)this.newAccountAutoCreateDefaults.getSubFundGroup())) {
            return true;
        }
        String subFundGroupCode = this.newAccountAutoCreateDefaults.getSubFundGroupCode().trim();
        String fundGroupCode = this.newAccountAutoCreateDefaults.getSubFundGroup().getFundGroupCode().trim();
        boolean valid = true;
        if (((ParameterEvaluatorService)SpringContext.getBean(ParameterEvaluatorService.class)).getParameterEvaluator(Account.class, "INCOME_STREAM_ACCOUNT_REQUIRING_FUND_GROUPS", fundGroupCode).evaluationSucceeds() && ((ParameterEvaluatorService)SpringContext.getBean(ParameterEvaluatorService.class)).getParameterEvaluator(Account.class, "INCOME_STREAM_ACCOUNT_REQUIRING_SUB_FUND_GROUPS", subFundGroupCode).evaluationSucceeds()) {
            if (StringUtils.isBlank((CharSequence)this.newAccountAutoCreateDefaults.getIncomeStreamFinancialCoaCode())) {
                this.putFieldError("incomeStreamFinancialCoaCode", "error.document.accountMaintenance.incomeStreamAcctCOACannotBeEmpty", new String[]{this.getDdService().getAttributeLabel(FundGroup.class, "code"), fundGroupCode, this.getDdService().getAttributeLabel(SubFundGroup.class, "subFundGroupCode"), subFundGroupCode});
                valid = false;
            }
            if (StringUtils.isBlank((CharSequence)this.newAccountAutoCreateDefaults.getIncomeStreamAccountNumber())) {
                this.putFieldError("incomeStreamAccountNumber", "error.document.accountMaintenance.incomeStreamAcctNbrCannotBeEmpty", new String[]{this.getDdService().getAttributeLabel(FundGroup.class, "code"), fundGroupCode, this.getDdService().getAttributeLabel(SubFundGroup.class, "subFundGroupCode"), subFundGroupCode});
                valid = false;
            }
        }
        return valid;
    }

    protected boolean checkCGFieldNotFilledIn(String propertyName) {
        boolean success = true;
        Object value = ObjectUtils.getPropertyValue((Object)((Object)this.newAccountAutoCreateDefaults), (String)propertyName);
        if (value instanceof String && !StringUtils.isBlank((CharSequence)value.toString()) || value != null) {
            success = false;
            this.putFieldError(propertyName, "error.document.accountMaintenance.cgFieldsFilledInForNonCGAccount", new String[]{this.newAccountAutoCreateDefaults.getSubFundGroupCode()});
        }
        return success;
    }

    protected boolean checkIncomeStreamAccountRule() {
        if (ObjectUtils.isNotNull((Object)this.newAccountAutoCreateDefaults.getSubFundGroup()) && StringUtils.isNotBlank((CharSequence)this.newAccountAutoCreateDefaults.getSubFundGroup().getFundGroupCode()) && ObjectUtils.isNull((Object)this.newAccountAutoCreateDefaults.getIncomeStreamAccount())) {
            String incomeStreamRequiringFundGroupCode = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(Account.class, "INCOME_STREAM_ACCOUNT_REQUIRING_FUND_GROUPS");
            if (StringUtils.containsIgnoreCase((CharSequence)this.newAccountAutoCreateDefaults.getSubFundGroup().getFundGroupCode(), (CharSequence)incomeStreamRequiringFundGroupCode)) {
                GlobalVariables.getMessageMap().putError("accountNumber", "error.document.ba.noIncomeAccount", new String[]{""});
                return false;
            }
        }
        return true;
    }

    protected boolean checkRequiredKcUnit(AccountAutoCreateDefaults newAccountAutoCreateDefaults, boolean isNew) {
        boolean result = true;
        try {
            String kcUnit;
            ContractsAndGrantsUnit unitDTO = newAccountAutoCreateDefaults.getUnitDTO();
            unitDTO = (ContractsAndGrantsUnit)((KualiModuleService)SpringContext.getBean(KualiModuleService.class)).getResponsibleModuleService(ContractsAndGrantsUnit.class).retrieveExternalizableBusinessObjectIfNecessary((BusinessObject)newAccountAutoCreateDefaults, (ExternalizableBusinessObject)unitDTO, "unitDTO");
            if (unitDTO == null) {
                this.putFieldError("kcUnit", "error.kc.account.params.unit.notfound", newAccountAutoCreateDefaults.getKcUnit());
                result = false;
            }
            if (isNew && (kcUnit = newAccountAutoCreateDefaults.getKcUnit()) != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("kcUnit", kcUnit);
                Collection accountAutoCreateDefaultList = this.getBoService().findMatching(AccountAutoCreateDefaults.class, map);
                if (accountAutoCreateDefaultList == null || !accountAutoCreateDefaultList.isEmpty()) {
                    this.putFieldError("kcUnit", "error.kc.account.params.KcUnitDefined", newAccountAutoCreateDefaults.getKcUnit());
                    result = false;
                }
            }
            return result;
        }
        catch (Exception ex) {
            this.putFieldError("kcUnit", "error.kc.account.params.unit.notfound", newAccountAutoCreateDefaults.getKcUnit());
            return false;
        }
    }

    public void setContractsAndGrantsModuleService(ContractsAndGrantsModuleService contractsAndGrantsModuleService) {
        this.contractsAndGrantsModuleService = contractsAndGrantsModuleService;
    }

    public ParameterService getParameterService() {
        if (parameterService == null) {
            parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        }
        return parameterService;
    }

    protected boolean checkICRCollectionExist(boolean expectFilled) {
        boolean success;
        List<IndirectCostRecoveryAutoDefAccount> indirectCostRecoveryAccountList = this.newAccountAutoCreateDefaults.getIndirectCostRecoveryAutoDefAccounts();
        boolean bl = success = expectFilled != this.newAccountAutoCreateDefaults.getIndirectCostRecoveryAutoDefAccounts().isEmpty();
        if (!success && expectFilled) {
            for (IndirectCostRecoveryAutoDefAccount account : indirectCostRecoveryAccountList) {
                success &= StringUtils.isNotBlank((CharSequence)account.getIndirectCostRecoveryAccountNumber()) && StringUtils.isNotBlank((CharSequence)account.getIndirectCostRecoveryFinCoaCode());
            }
        }
        return success;
    }

    protected boolean checkIndirectCostRecoveryAccountDistributions() {
        List<IndirectCostRecoveryAutoDefAccount> indirectCostRecoveryAccountList = this.newAccountAutoCreateDefaults.getActiveIndirectCostRecoveryAccounts();
        if (ObjectUtils.isNull(indirectCostRecoveryAccountList) || indirectCostRecoveryAccountList.size() == 0) {
            return true;
        }
        int i = 0;
        BigDecimal totalDistribution = BigDecimal.ZERO;
        for (IndirectCostRecoveryAutoDefAccount icra : indirectCostRecoveryAccountList) {
            String errorPath = "document.newMaintainableObject." + this.boFieldPath + "[" + i++ + "]";
            GlobalVariables.getMessageMap().addToErrorPath(errorPath);
            this.checkIndirectCostRecoveryAccount(icra);
            GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
            if (ObjectUtils.isNull((Object)icra.getAccountLinePercent())) continue;
            totalDistribution = totalDistribution.add(icra.getAccountLinePercent());
        }
        if (totalDistribution.compareTo(BD100) != 0) {
            this.putFieldError(this.boFieldPath, "error.document.accountMaintenance.indirectCostRecoveryAccounts.totalNot100Percent");
            return false;
        }
        return true;
    }

    protected boolean checkIndirectCostRecoveryAccount(IndirectCostRecoveryAutoDefAccount icra) {
        String chartOfAccountsCode = icra.getIndirectCostRecoveryFinCoaCode();
        String accountNumber = icra.getIndirectCostRecoveryAccountNumber();
        BigDecimal icraAccountLinePercentage = ObjectUtils.isNotNull((Object)icra.getAccountLinePercent()) ? icra.getAccountLinePercent() : BigDecimal.ZERO;
        boolean active = icra.isActive();
        return this.checkIndirectCostRecoveryAccount(chartOfAccountsCode, accountNumber, icraAccountLinePercentage, active);
    }
}

